/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.util.Collections;
import java.util.Set;
import org.minidns.MiniDnsException;
import org.minidns.dnssec.UnverifiedReason;

public class DnssecResultNotAuthenticException
extends MiniDnsException {
    private static final long serialVersionUID = 1L;
    private final Set<UnverifiedReason> unverifiedReasons;

    private DnssecResultNotAuthenticException(String message, Set<UnverifiedReason> unverifiedReasons) {
        super(message);
        if (unverifiedReasons.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.unverifiedReasons = Collections.unmodifiableSet(unverifiedReasons);
    }

    public static DnssecResultNotAuthenticException from(Set<UnverifiedReason> unverifiedReasons) {
        StringBuilder sb = new StringBuilder();
        sb.append("DNSSEC result not authentic. Reasons: ");
        for (UnverifiedReason reason : unverifiedReasons) {
            sb.append(reason).append('.');
        }
        return new DnssecResultNotAuthenticException(sb.toString(), unverifiedReasons);
    }

    public Set<UnverifiedReason> getUnverifiedReasons() {
        return this.unverifiedReasons;
    }
}

