/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.omemo;

import java.util.HashMap;
import java.util.Map;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.state.SignedPreKeyStore;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.eventbus.EventBus;

public class XmppOMEMOSession {
    private final Map<SignalProtocolAddress, SessionCipher> deviceCiphers = new HashMap<SignalProtocolAddress, SessionCipher>();
    private final transient EventBus eventBus;
    private final BareJID jid;

    XmppOMEMOSession(EventBus eventBus, BareJID jid) {
        this.jid = jid;
        this.eventBus = eventBus;
    }

    public boolean hasCiphers() {
        for (SignalProtocolAddress signalProtocolAddress : this.deviceCiphers.keySet()) {
            if (!signalProtocolAddress.getName().equals(this.jid.toString())) continue;
            return true;
        }
        return false;
    }

    public Map<SignalProtocolAddress, SessionCipher> getDeviceCiphers() {
        return this.deviceCiphers;
    }

    public BareJID getJid() {
        return this.jid;
    }

    public void addDeviceCipher(SignalProtocolAddress addr, SessionCipher sessionCipher) {
        this.deviceCiphers.put(addr, sessionCipher);
    }

    public void addDeviceCipher(SignalProtocolStore store, SignalProtocolAddress address) {
        SessionCipher sessionCipher = new SessionCipher((SessionStore)store, (PreKeyStore)store, (SignedPreKeyStore)store, (IdentityKeyStore)store, address);
        this.addDeviceCipher(address, sessionCipher);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmppOMEMOSession)) {
            return false;
        }
        XmppOMEMOSession session = (XmppOMEMOSession)o;
        return this.jid.equals((Object)session.jid);
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XmppOMEMOSession{");
        sb.append("jid=").append(this.jid);
        sb.append(", devices=").append(this.deviceCiphers.size());
        sb.append('}');
        return sb.toString();
    }

    byte[] processEncryptedKey(SignalProtocolStore store, int senderDeviceId, byte[] encryptedKey, boolean prekey) throws InvalidVersionException, InvalidMessageException, LegacyMessageException, DuplicateMessageException, InvalidKeyIdException, UntrustedIdentityException, InvalidKeyException, NoSessionException {
        PreKeySignalMessage m;
        SessionCipher sc = this.deviceCiphers.get(senderDeviceId);
        if (sc == null) {
            SignalProtocolAddress addr = new SignalProtocolAddress(this.jid.toString(), senderDeviceId);
            sc = new SessionCipher(store, addr);
            this.deviceCiphers.put(addr, sc);
        }
        if (prekey) {
            m = new PreKeySignalMessage(encryptedKey);
            return sc.decrypt(m);
        }
        m = new SignalMessage(encryptedKey);
        return sc.decrypt((SignalMessage)m);
    }
}

