/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.omemo;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementBuilder;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.extensions.Extension;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.CannotEncryptException;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.JaXMPPSignalProtocolStore;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.OMEMOEncryptableMessage;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.OMEMOMessage;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.OmemoModule;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.XmppOMEMOSession;
import tigase.jaxmpp.core.client.xmpp.stanzas.Message;
import tigase.jaxmpp.core.client.xmpp.stanzas.StanzaType;

public class OmemoExtension
implements Extension {
    public static final String OMEMO_ERROR_FLAG = "eu.siacs.conversations.axolotl#ERROR";
    public static final String CIPHER_NAME = "AES/GCM/NoPadding";
    public static final String ALGORITHM_NAME = "AES";
    private static final int KEY_SIZE = 128;
    private static final boolean AUTHTAG = true;
    private final OmemoModule module;
    private Logger log = Logger.getLogger(this.getClass().getName());

    private static byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(ALGORITHM_NAME);
        generator.init(128);
        return generator.generateKey().getEncoded();
    }

    private static byte[] getCiphertext(Element encElement) throws XMLException {
        Element e = encElement.getFirstChild("payload");
        return e == null ? null : Base64.decode((String)e.getValue());
    }

    private static BareJID getFromJid(Element stanza) throws XMLException {
        String t = stanza.getAttribute("from");
        if (t == null) {
            return null;
        }
        return BareJID.bareJIDInstance((String)t);
    }

    private static byte[] getIV(Element encElement) throws XMLException {
        Element header = encElement.getFirstChild("header");
        Element e = header.getFirstChild("iv");
        return e == null ? null : Base64.decode((String)e.getValue());
    }

    private static Element getKeyElement(Element encElement, int localRegistrationId) throws XMLException {
        Element header = encElement.getFirstChild("header");
        for (Element c : header.getChildren("key")) {
            if (Integer.valueOf(c.getAttribute("rid")) != localRegistrationId) continue;
            return c;
        }
        return null;
    }

    private static Integer getSenderDeviceId(Element encElement) throws XMLException {
        Element header = encElement.getFirstChild("header");
        return header == null ? null : Integer.valueOf(header.getAttribute("sid"));
    }

    private static BareJID getToJid(Element stanza) throws XMLException {
        String t = stanza.getAttribute("to");
        if (t == null) {
            return null;
        }
        return BareJID.bareJIDInstance((String)t);
    }

    OmemoExtension(OmemoModule omemoModule) {
        this.module = omemoModule;
    }

    public Element afterReceive(Element stanza) throws JaxmppException {
        BareJID jid = OmemoExtension.getFromJid(stanza);
        Element encElement = stanza.getChildrenNS("encrypted", "eu.siacs.conversations.axolotl");
        if (jid == null || encElement == null) {
            return stanza;
        }
        JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.module.getSessionObject());
        XmppOMEMOSession session = this.getOrCreateSession(jid);
        int senderDeviceId = OmemoExtension.getSenderDeviceId(encElement);
        byte[] iv = OmemoExtension.getIV(encElement);
        Element encKeyElement = OmemoExtension.getKeyElement(encElement, store.getLocalRegistrationId());
        byte[] encryptedKey = this.extractKey(encKeyElement);
        if (encryptedKey == null) {
            Message m = (Message)Message.create((Element)ElementFactory.create((Element)stanza));
            m.addFlag(OMEMO_ERROR_FLAG);
            m.setBody("Message is not encrypted for this device.");
            return m;
        }
        boolean prekey = this.isPreKey(encKeyElement);
        byte[] ciphertext = OmemoExtension.getCiphertext(encElement);
        OMEMOMessage result = new OMEMOMessage(false, ElementFactory.create((Element)stanza));
        result.removeChild(result.getChildrenNS("encrypted", "eu.siacs.conversations.axolotl"));
        try {
            byte[] plain;
            byte[] key = session.processEncryptedKey(store, senderDeviceId, encryptedKey, prekey);
            if (key.length >= 32) {
                int authtaglength = key.length - 16;
                byte[] newCipherText = new byte[key.length - 16 + ciphertext.length];
                byte[] newKey = new byte[16];
                System.arraycopy(ciphertext, 0, newCipherText, 0, ciphertext.length);
                System.arraycopy(key, 16, newCipherText, ciphertext.length, authtaglength);
                System.arraycopy(key, 0, newKey, 0, newKey.length);
                ciphertext = newCipherText;
                key = newKey;
            }
            SecretKeySpec keySpec = new SecretKeySpec(key, ALGORITHM_NAME);
            Cipher cipher = this.module.getCipherFactory().cipherInstance(2, keySpec, iv);
            byte[] byArray = plain = ciphertext == null ? null : cipher.doFinal(ciphertext);
            if (plain == null) {
                result.setBody(null);
            } else {
                result.setBody(new String(plain));
            }
            result.setSecured(true);
        }
        catch (InvalidMessageException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (LegacyMessageException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (DuplicateMessageException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (NoSessionException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (UntrustedIdentityException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (NoSuchPaddingException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (BadPaddingException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (IllegalBlockSizeException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (InvalidKeyException e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on processing OMEMO data", e);
            result.addFlag(OMEMO_ERROR_FLAG);
            result.setBody(e.getMessage());
            result.setType(StanzaType.error);
        }
        return result;
    }

    public Element beforeSend(Element stanza) throws JaxmppException {
        BareJID jid = OmemoExtension.getToJid(stanza);
        Element bd = stanza.getFirstChild("body");
        boolean encryptableStanza = bd != null && jid != null;
        OMEMOEncryptableMessage.Encryption encryption = this.calculateEncryptionStatus(jid, stanza);
        XmppOMEMOSession session = this.module.getOMEMOSession(jid, encryption == OMEMOEncryptableMessage.Encryption.Required);
        if (encryption == OMEMOEncryptableMessage.Encryption.Disabled) {
            return stanza;
        }
        if (encryptableStanza && encryption == OMEMOEncryptableMessage.Encryption.Required && session == null) {
            throw new CannotEncryptException();
        }
        if (!encryptableStanza || session == null) {
            return stanza;
        }
        stanza.removeChild(bd);
        try {
            stanza.addChild(this.createEncryptedElement(bd, session));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JaxmppException((Throwable)e);
        }
        stanza.addChild(ElementBuilder.create((String)"store", (String)"urn:xmpp:hints").getElement());
        return new OMEMOMessage(true, stanza);
    }

    public String[] getFeatures() {
        return new String[]{"eu.siacs.conversations.axolotl"};
    }

    private OMEMOEncryptableMessage.Encryption calculateEncryptionStatus(BareJID jid, Element stanza) {
        if (this.module.isOMEMORequired(jid)) {
            return OMEMOEncryptableMessage.Encryption.Required;
        }
        if (stanza instanceof OMEMOEncryptableMessage) {
            return ((OMEMOEncryptableMessage)stanza).getEncryption();
        }
        return OMEMOEncryptableMessage.Encryption.Default;
    }

    private XmppOMEMOSession getOrCreateSession(BareJID jid) {
        XmppOMEMOSession s = this.module.getOMEMOSession(jid);
        if (s == null) {
            s = this.module.createOMEMOSession(jid);
            this.module.addOwnKeysToSession(s);
        }
        return s;
    }

    private byte[] extractKey(Element keyElement) throws XMLException {
        if (keyElement == null || keyElement.getValue() == null) {
            return null;
        }
        return Base64.decode((String)keyElement.getValue());
    }

    private boolean isPreKey(Element keyElement) throws XMLException {
        if (keyElement == null) {
            return false;
        }
        String a = keyElement.getAttribute("prekey");
        return a != null && (a.equals("1") || a.equals("true"));
    }

    private Element createEncryptedElement(Element body, XmppOMEMOSession session) throws XMLException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UntrustedIdentityException, NoSuchProviderException {
        String plaintext = body.getValue();
        JaXMPPSignalProtocolStore store = OmemoModule.getSignalProtocolStore(this.module.getSessionObject());
        ElementBuilder encryptedElement = ElementBuilder.create((String)"encrypted", (String)"eu.siacs.conversations.axolotl");
        byte[] keyData = OmemoExtension.generateKey();
        byte[] iv = this.module.generateIV();
        SecretKeySpec secretKey = new SecretKeySpec(keyData, ALGORITHM_NAME);
        Cipher cipher = this.module.getCipherFactory().cipherInstance(1, secretKey, iv);
        byte[] ciphertext = cipher.doFinal(plaintext.getBytes());
        byte[] authtagPlusInnerKey = new byte[32];
        byte[] encData = new byte[ciphertext.length - 16];
        System.arraycopy(ciphertext, 0, encData, 0, encData.length);
        System.arraycopy(ciphertext, encData.length, authtagPlusInnerKey, 16, 16);
        System.arraycopy(keyData, 0, authtagPlusInnerKey, 0, keyData.length);
        ciphertext = encData;
        encryptedElement.child("header").setAttribute("sid", String.valueOf(store.getLocalRegistrationId()));
        for (Map.Entry<SignalProtocolAddress, SessionCipher> s : session.getDeviceCiphers().entrySet()) {
            SignalProtocolAddress addr = s.getKey();
            encryptedElement.child("key").setAttribute("rid", String.valueOf(addr.getDeviceId()));
            CiphertextMessage m = authtagPlusInnerKey != null ? s.getValue().encrypt(authtagPlusInnerKey) : s.getValue().encrypt(secretKey.getEncoded());
            if (m.getType() == 3) {
                encryptedElement.setAttribute("prekey", "true");
            }
            encryptedElement.setValue(Base64.encode((byte[])m.serialize()));
            encryptedElement.up();
        }
        encryptedElement.child("iv").setValue(Base64.encode((byte[])iv)).up();
        encryptedElement.up().child("payload").setValue(Base64.encode((byte[])ciphertext));
        return encryptedElement.getElement();
    }
}

