/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.omemo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xmpp.modules.omemo.Bundle;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubErrorCondition;
import tigase.jaxmpp.core.client.xmpp.modules.pubsub.PubSubModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;

public abstract class KeysRetriever {
    private final Context context;
    private final BareJID jid;
    private final PubSubModule pubsub;

    public static Collection<Integer> getDeviceIDsFromPayload(Collection<PubSubModule.RetrieveItemsAsyncCallback.Item> items) {
        HashSet<Integer> ids = new HashSet<Integer>();
        try {
            for (PubSubModule.RetrieveItemsAsyncCallback.Item item : items) {
                Element list = item.getPayload();
                if (list == null || !list.getName().equals("list") || !list.getXMLNS().equals("eu.siacs.conversations.axolotl")) continue;
                List devices = list.getChildren("device");
                for (Element device : devices) {
                    ids.add(Integer.valueOf(device.getAttribute("id")));
                }
            }
        }
        catch (JaxmppException e) {
            e.printStackTrace();
        }
        return ids;
    }

    public KeysRetriever(Context context, BareJID jid) {
        this.context = context;
        this.jid = jid;
        this.pubsub = (PubSubModule)context.getModuleProvider().getModule(PubSubModule.class);
    }

    public void retrieve(Collection<Integer> deviceIds) throws JaxmppException {
        this.getKeysOfDevices(deviceIds);
    }

    public void retrieve() throws JaxmppException {
        this.pubsub.retrieveItem(this.jid, "eu.siacs.conversations.axolotl.devicelist", new PubSubModule.RetrieveItemsAsyncCallback(){

            public void onTimeout() throws JaxmppException {
                System.out.println("ERROR: timeout");
                KeysRetriever.this.error();
            }

            protected void onRetrieve(IQ responseStanza, String nodeName, Collection<PubSubModule.RetrieveItemsAsyncCallback.Item> items) {
                try {
                    Collection<Integer> ids = KeysRetriever.getDeviceIDsFromPayload(items);
                    KeysRetriever.this.getKeysOfDevices(ids);
                }
                catch (JaxmppException e) {
                    e.printStackTrace();
                }
            }

            protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                System.out.println("ERROR: " + pubSubErrorCondition);
                KeysRetriever.this.error();
            }
        });
    }

    abstract void finish(List<Bundle> var1);

    abstract void error();

    private void getKeysOfDevices(Collection<?> devicesId) throws JaxmppException {
        int count = devicesId.size();
        final ArrayList result = new ArrayList();
        final HashSet requests = new HashSet();
        requests.addAll(devicesId);
        for (final Object id : devicesId) {
            this.pubsub.retrieveItem(this.jid, "eu.siacs.conversations.axolotl.bundles:" + id, new PubSubModule.RetrieveItemsAsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onTimeout() throws JaxmppException {
                    this.log.fine("Request for device " + KeysRetriever.this.jid + "#" + id + " timeout");
                    Context context = KeysRetriever.this.context;
                    synchronized (context) {
                        requests.remove(id);
                        if (requests.isEmpty()) {
                            KeysRetriever.this.finish(result);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onEror(IQ response, XMPPException.ErrorCondition errorCondition, PubSubErrorCondition pubSubErrorCondition) throws JaxmppException {
                    this.log.fine("Request for device " + KeysRetriever.this.jid + "#" + id + " error: " + errorCondition);
                    Context context = KeysRetriever.this.context;
                    synchronized (context) {
                        requests.remove(id);
                        if (requests.isEmpty()) {
                            KeysRetriever.this.finish(result);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onRetrieve(IQ responseStanza, String nodeName, Collection<PubSubModule.RetrieveItemsAsyncCallback.Item> items) {
                    this.log.fine("Request for device " + KeysRetriever.this.jid + "#" + id + " success.");
                    try {
                        for (PubSubModule.RetrieveItemsAsyncCallback.Item item : items) {
                            if (!item.getId().equals("current")) continue;
                            result.add(new Bundle(KeysRetriever.this.jid, new Integer(id.toString()), item.getPayload()));
                        }
                        Context context = KeysRetriever.this.context;
                        synchronized (context) {
                            requests.remove(id);
                            if (requests.isEmpty()) {
                                KeysRetriever.this.finish(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

