/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.capabilities;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.criteria.Criteria;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ContextAware;
import tigase.jaxmpp.core.client.xmpp.modules.InitializingModule;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesCache;
import tigase.jaxmpp.core.client.xmpp.modules.disco.DiscoveryModule;
import tigase.jaxmpp.core.client.xmpp.modules.disco.NodeDetailsCallback;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.Presence;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;

public class CapabilitiesModule
implements XmppModule,
ContextAware,
InitializingModule {
    public static final String NODE_NAME_KEY = "NODE_NAME_KEY";
    public static final String VERIFICATION_STRING_KEY = "XEP115VerificationString";
    private static final String ALGORITHM = "SHA-1";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private CapabilitiesCache cache;
    private Context context;
    private DiscoveryModule discoveryModule;
    private NodeDetailsCallback nodeDetailsCallback;

    public void afterRegister() {
    }

    public void beforeRegister() {
        if (this.context == null) {
            throw new RuntimeException("Context cannot be null");
        }
        this.discoveryModule = (DiscoveryModule)this.context.getModuleProvider().getModule(DiscoveryModule.class);
        if (this.discoveryModule == null) {
            throw new RuntimeException("Required module: DiscoveryModule not available.");
        }
        PresenceModule presenceModule = (PresenceModule)this.context.getModuleProvider().getModule(PresenceModule.class);
        if (presenceModule == null) {
            throw new RuntimeException("Required module: PresenceModule not available.");
        }
        PresenceModule.BeforePresenceSendHandler beforePresenceSendHandler = new PresenceModule.BeforePresenceSendHandler(){

            public void onBeforePresenceSend(SessionObject sessionObject, Presence presence) throws JaxmppException {
                CapabilitiesModule.this.onBeforePresenceSend(presence);
            }
        };
        PresenceModule.ContactAvailableHandler contactAvailableHandler = new PresenceModule.ContactAvailableHandler(){

            public void onContactAvailable(SessionObject sessionObject, Presence stanza, JID jid, Presence.Show show, String status, Integer priority) throws JaxmppException {
                CapabilitiesModule.this.onReceivedPresence(stanza);
            }
        };
        PresenceModule.ContactChangedPresenceHandler contactChangedPresenceHandler = new PresenceModule.ContactChangedPresenceHandler(){

            public void onContactChangedPresence(SessionObject sessionObject, Presence stanza, JID jid, Presence.Show show, String status, Integer priority) throws JaxmppException {
                CapabilitiesModule.this.onReceivedPresence(stanza);
            }
        };
        this.nodeDetailsCallback = new DiscoveryModule.DefaultNodeDetailsCallback(this.discoveryModule);
        presenceModule.addBeforePresenceSendHandler(beforePresenceSendHandler);
        presenceModule.addContactAvailableHandler(contactAvailableHandler);
        presenceModule.addContactChangedPresenceHandler(contactChangedPresenceHandler);
        this.discoveryModule.setNodeCallback("", this.nodeDetailsCallback);
    }

    public void beforeUnregister() {
    }

    private String calculateVerificationString() {
        String category = (String)this.context.getSessionObject().getProperty("IDENTITY_CATEGORY_KEY");
        String type = (String)this.context.getSessionObject().getProperty("IDENTITY_TYPE_KEY");
        String nme = (String)this.context.getSessionObject().getProperty("SOFTWARE_VERSION#NAME_KEY");
        String v = (String)this.context.getSessionObject().getProperty("SOFTWARE_VERSION#VERSION_KEY");
        String identity = category + "/" + type + "//" + nme + " " + v;
        String ver = this.generateVerificationString(new String[]{identity}, this.context.getModuleProvider().getAvailableFeatures().toArray(new String[0]));
        String oldVer = (String)this.context.getSessionObject().getProperty(VERIFICATION_STRING_KEY);
        if (oldVer != null && !oldVer.equals(ver)) {
            this.discoveryModule.removeNodeCallback(this.getNodeName() + "#" + oldVer);
        }
        this.context.getSessionObject().setProperty(VERIFICATION_STRING_KEY, (Object)ver);
        this.discoveryModule.setNodeCallback(this.getNodeName() + "#" + ver, this.nodeDetailsCallback);
        return ver;
    }

    public final String generateVerificationString(String[] identities, String[] features) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            for (String id : identities) {
                md.update(id.getBytes("UTF-8"));
                md.update((byte)60);
            }
            Arrays.sort(features);
            for (String f : features) {
                md.update(f.getBytes("UTF-8"));
                md.update((byte)60);
            }
            byte[] digest = md.digest();
            return Base64.encode((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.warning("Cannot calculate verification string.");
        }
        catch (UnsupportedEncodingException e) {
            this.log.warning("Cannot calculate verification string.");
        }
        return null;
    }

    public CapabilitiesCache getCache() {
        return this.cache;
    }

    public void setCache(CapabilitiesCache cache) {
        this.cache = cache;
    }

    public Criteria getCriteria() {
        return null;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/caps"};
    }

    protected String getNodeName() {
        String s = (String)this.context.getSessionObject().getProperty(NODE_NAME_KEY);
        return s == null ? "http://tigase.org/jaxmpp" : s;
    }

    protected boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBeforePresenceSend(Presence presence) throws XMLException {
        if (!this.isEnabled()) {
            return;
        }
        String ver = (String)this.context.getSessionObject().getProperty(VERIFICATION_STRING_KEY);
        if (ver == null) {
            ver = this.calculateVerificationString();
        }
        if (ver == null) {
            return;
        }
        if (presence != null) {
            Presence presence2 = presence;
            synchronized (presence2) {
                Element c = ElementFactory.create((String)"c", null, (String)"http://jabber.org/protocol/caps");
                c.setAttribute("hash", "sha-1");
                c.setAttribute("node", this.getNodeName());
                c.setAttribute("ver", ver);
                presence.addChild(c);
            }
        }
    }

    protected void onReceivedPresence(Presence presence) throws JaxmppException {
        if (this.cache == null) {
            return;
        }
        if (presence == null) {
            return;
        }
        Element c = presence.getChildrenNS("c", "http://jabber.org/protocol/caps");
        if (c == null) {
            return;
        }
        String node = c.getAttribute("node");
        String ver = c.getAttribute("ver");
        if (node == null || ver == null) {
            return;
        }
        if (this.cache.isCached(node + "#" + ver)) {
            return;
        }
        this.discoveryModule.getInfo(presence.getFrom(), node + "#" + ver, new DiscoveryModule.DiscoInfoAsyncCallback(node + "#" + ver){

            public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                System.out.println("Error disco#info request: " + error);
            }

            protected void onInfoReceived(String node, Collection<DiscoveryModule.Identity> identities, Collection<String> features) throws XMLException {
                String name = "?";
                String category = "?";
                String type = "?";
                if (identities != null && identities.size() > 0) {
                    DiscoveryModule.Identity identity = identities.iterator().next();
                    name = identity.getName();
                    category = identity.getCategory();
                    type = identity.getType();
                }
                if (CapabilitiesModule.this.cache != null) {
                    CapabilitiesModule.this.cache.store(node, name, category, type, features);
                }
            }

            public void onTimeout() throws JaxmppException {
                System.out.println("Error disco#info request: timeout");
            }
        });
    }

    public void process(Element element) throws JaxmppException {
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

