/*
 * Decompiled with CFR 0.152.
 */
package tigase.xml;

import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import tigase.xml.CData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;

public class Element
implements XMLNodeIfc<Element> {
    protected XMLIdentityHashMap<String, String> attributes = null;
    protected LinkedList<XMLNodeIfc> children = null;
    protected String defxmlns = null;
    protected String name = null;
    protected String xmlns = null;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("You must give file name as parameter.");
            System.exit(1);
        }
        FileReader file = new FileReader(args[0]);
        char[] buff = new char[1];
        SimpleParser parser = new SimpleParser();
        DomBuilderHandler dom = new DomBuilderHandler();
        int result = -1;
        while ((result = file.read(buff)) != -1) {
            parser.parse(dom, buff, 0, result);
        }
        file.close();
        Queue<Element> elems = dom.getParsedElements();
        for (Element elem : elems) {
            elem.clone();
            System.out.println(elem.toString());
        }
    }

    public Element(Element element) {
        Element src = element.clone();
        this.attributes = src.attributes;
        this.name = src.name;
        this.defxmlns = src.defxmlns;
        this.xmlns = src.xmlns;
        this.children = src.children;
    }

    public Element(String argName) {
        this.setName(argName);
    }

    public Element(String argName, String argCData) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
    }

    public Element(String argName, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, Element[] children, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
        this.addChildren(Arrays.asList(children));
    }

    public Element(String argName, String argCData, String[] att_names, String[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public Element(String argName, String argCData, StringBuilder[] att_names, StringBuilder[] att_values) {
        this.setName(argName);
        if (argCData != null) {
            this.setCData(argCData);
        }
        if (att_names != null) {
            this.setAttributes(att_names, att_values);
        }
    }

    public void addAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
    }

    public void addAttributes(Map<String, String> attrs) {
        if (this.attributes == null) {
            this.attributes = new XMLIdentityHashMap(attrs.size());
        }
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            this.attributes.put(entry.getKey().intern(), entry.getValue());
        }
    }

    public void addCData(String argCData) {
        this.addChild(new CData(argCData));
    }

    public void addChild(XMLNodeIfc child) {
        if (child == null) {
            throw new NullPointerException("Element child can not be null.");
        }
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
    }

    public void addChildren(List<Element> children) {
        if (children == null) {
            return;
        }
        if (this.children == null) {
            this.children = new LinkedList();
        }
        for (XMLNodeIfc xMLNodeIfc : children) {
            this.children.add((XMLNodeIfc)xMLNodeIfc.clone());
        }
    }

    public String childrenToString() {
        StringBuilder result = new StringBuilder();
        this.childrenToString(result);
        return result.length() > 0 ? result.toString() : null;
    }

    public void childrenToString(StringBuilder result) {
        if (this.children != null) {
            for (XMLNodeIfc child : this.children) {
                if (child == null) continue;
                if (child instanceof Element) {
                    ((Element)child).toString(result);
                    continue;
                }
                result.append(child.toString());
            }
        }
    }

    public String childrenToStringPretty() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            for (XMLNodeIfc child : this.children) {
                if (child == null) continue;
                result.append(child.toStringPretty());
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public String childrenToStringSecure() {
        StringBuilder result = new StringBuilder();
        this.childrenToStringSecure(result);
        return result.length() > 0 ? result.toString() : null;
    }

    public void childrenToStringSecure(StringBuilder result) {
        if (this.children != null) {
            for (XMLNodeIfc child : this.children) {
                if (child == null) continue;
                if (child instanceof Element) {
                    ((Element)child).toStringSecure(result);
                    continue;
                }
                result.append(child.toStringSecure());
            }
        }
    }

    @Override
    public Element clone() {
        Element result = null;
        try {
            result = (Element)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.attributes = this.attributes != null ? (XMLIdentityHashMap)this.attributes.clone() : null;
        if (this.children != null) {
            result.setChildren(this.children);
        } else {
            result.children = null;
        }
        return result;
    }

    @Override
    public int compareTo(Element elem) {
        return this.toStringNoChildren().compareTo(elem.toStringNoChildren());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            return this.toStringNoChildren().equals(elem.toStringNoChildren());
        }
        return false;
    }

    public Element findChildStaticStr(String[] elementPath) {
        String str;
        if (elementPath[0] != this.getName()) {
            return null;
        }
        Element child = this;
        for (int i = 1; i < elementPath.length && child != null; child = child.getChildStaticStr(str), ++i) {
            str = elementPath[i];
        }
        return child;
    }

    public Element findChild(String[] elemPath) {
        String str;
        if (elemPath[0].isEmpty()) {
            elemPath = Arrays.copyOfRange(elemPath, 1, elemPath.length);
        }
        if (!elemPath[0].equals(this.getName())) {
            return null;
        }
        Element child = this;
        for (int i = 1; i < elemPath.length && child != null; child = child.getChild(str), ++i) {
            str = elemPath[i];
        }
        return child;
    }

    @Deprecated
    public Element findChild(String elementPath) {
        return this.findChild(elementPath.split("/"));
    }

    public Element findChild(Matcher<Element> matcher) {
        if (this.children != null) {
            for (XMLNodeIfc node : this.children) {
                Element el;
                if (!(node instanceof Element) || !matcher.match(el = (Element)node)) continue;
                return el;
            }
        }
        return null;
    }

    public List<Element> findChildren(Matcher<Element> matcher) {
        if (this.children != null) {
            LinkedList<Element> result = new LinkedList<Element>();
            for (XMLNodeIfc node : this.children) {
                Element el;
                if (!(node instanceof Element) || !matcher.match(el = (Element)node)) continue;
                result.add(el);
            }
            return result;
        }
        return null;
    }

    public <R> List<R> flatMapChildren(Function<Element, Collection<? extends R>> mapper) {
        if (this.children != null) {
            LinkedList<? extends R> result = new LinkedList<R>();
            for (XMLNodeIfc node : this.children) {
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                result.addAll(mapper.apply(el));
            }
            return result;
        }
        return null;
    }

    public void forEachChild(Consumer<Element> consumer) {
        if (this.children != null) {
            for (XMLNodeIfc node : this.children) {
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                consumer.accept(el);
            }
        }
    }

    @Deprecated
    public String getAttribute(String attName) {
        if (this.attributes != null) {
            return (String)this.attributes.get(attName.intern());
        }
        return null;
    }

    @Deprecated
    public String getChildAttribute(String childName, String attName) {
        String result = null;
        Element child = this.getChild(childName);
        if (child != null) {
            result = child.getAttribute(attName);
        }
        return result;
    }

    public String getChildAttributeStaticStr(String childName, String attName) {
        String result = null;
        Element child = this.getChild(childName);
        if (child != null) {
            result = child.getAttributeStaticStr(attName);
        }
        return result;
    }

    public String getAttributeStaticStr(String attName) {
        if (this.attributes != null) {
            return (String)this.attributes.get(attName);
        }
        return null;
    }

    @Deprecated
    public String getAttribute(String elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    @Deprecated
    public String getAttribute(String[] elementPath, String att_name) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getAttribute(att_name) : null;
    }

    public String getAttributeStaticStr(String[] elementPath, String att_name) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getAttributeStaticStr(att_name) : null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes != null ? new LinkedHashMap<String, String>(this.attributes) : null;
    }

    public void setAttributes(Map<String, String> newAttributes) {
        this.attributes = new XMLIdentityHashMap(newAttributes.size());
        for (Map.Entry<String, String> entry : newAttributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public String getCData(String elementPath) {
        return this.getChildCData(elementPath);
    }

    public String getCData(String[] elementPath) {
        return this.getChildCData(elementPath);
    }

    public String getCDataStaticStr(String[] elementPath) {
        return this.getChildCDataStaticStr(elementPath);
    }

    public String getCData() {
        return this.cdataToString();
    }

    public void setCData(String argCData) {
        if (this.children != null) {
            for (XMLNodeIfc child : this.children) {
                if (child == null || !(child instanceof CData)) continue;
                ((CData)child).setCdata(argCData);
                return;
            }
        }
        this.addChild(new CData(argCData));
    }

    public Element getChild(String name) {
        if (this.children != null) {
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name)) continue;
                return elem;
            }
        }
        return null;
    }

    public Element getChildStaticStr(String name) {
        if (this.children != null) {
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || (elem = (Element)el).getName() != name) continue;
                return elem;
            }
        }
        return null;
    }

    public Element getChild(String name, String child_xmlns) {
        if (child_xmlns == null) {
            return this.getChild(name);
        }
        if (this.children != null) {
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || !(elem = (Element)el).getName().equals(name) || elem.getXMLNS() != child_xmlns && !child_xmlns.equals(elem.getXMLNS())) continue;
                return elem;
            }
        }
        return null;
    }

    public Element getChildStaticStr(String name, String child_xmlns) {
        if (child_xmlns == null) {
            return this.getChildStaticStr(name);
        }
        if (this.children != null) {
            for (XMLNodeIfc el : this.children) {
                Element elem;
                if (!(el instanceof Element) || (elem = (Element)el).getName() != name || elem.getXMLNS() != child_xmlns) continue;
                return elem;
            }
        }
        return null;
    }

    @Deprecated
    public String getChildCData(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getChildCData(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getChildCDataStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getCData() : null;
    }

    public String getChildCData(Matcher<Element> matcher) {
        Element child = this.findChild(matcher);
        return child != null ? child.getCData() : null;
    }

    public List<Element> getChildren() {
        if (this.children != null) {
            LinkedList<Element> result = new LinkedList<Element>();
            for (XMLNodeIfc node : this.children) {
                if (!(node instanceof Element)) continue;
                result.add((Element)node);
            }
            return result;
        }
        return null;
    }

    public void setChildren(List<XMLNodeIfc> children) {
        this.children = new LinkedList();
        for (XMLNodeIfc child : children) {
            this.children.add((XMLNodeIfc)child.clone());
        }
    }

    @Deprecated
    public List<Element> getChildren(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public List<Element> getChildren(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public List<Element> getChildrenStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getChildren() : null;
    }

    public List<Element> getChildren(Matcher<Element> matcher) {
        Element child = this.findChild(matcher);
        return child != null ? child.getChildren() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName.intern();
    }

    public String getXMLNS() {
        if (this.xmlns == null) {
            this.xmlns = this.getAttributeStaticStr("xmlns");
            this.xmlns = this.xmlns != null ? this.xmlns.intern() : null;
        }
        return this.xmlns != null ? this.xmlns : this.defxmlns;
    }

    public void setXMLNS(String ns) {
        if (ns == null) {
            this.xmlns = null;
            this.removeAttribute("xmlns");
        } else {
            this.xmlns = ns.intern();
            this.setAttribute("xmlns", this.xmlns);
        }
    }

    @Deprecated
    public String getXMLNS(String elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getXMLNS(String[] elementPath) {
        Element child = this.findChild(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public String getXMLNSStaticStr(String[] elementPath) {
        Element child = this.findChildStaticStr(elementPath);
        return child != null ? child.getXMLNS() : null;
    }

    public int hashCode() {
        return this.toStringNoChildren().hashCode();
    }

    public <R> R map(Function<Element, ? extends R> mapper) {
        return mapper.apply(this);
    }

    public <R> List<R> mapChildren(Function<Element, ? extends R> mapper) {
        return this.mapChildren(null, mapper);
    }

    public <R> List<R> mapChildren(Matcher<Element> matcher, Function<Element, ? extends R> mapper) {
        if (this.children != null) {
            LinkedList<R> result = new LinkedList<R>();
            for (XMLNodeIfc node : this.children) {
                if (!(node instanceof Element)) continue;
                Element el = (Element)node;
                if (matcher != null && !matcher.match(el)) continue;
                result.add(mapper.apply(el));
            }
            return result;
        }
        return null;
    }

    public boolean matches(Matcher<Element> matcher) {
        return matcher.match(this);
    }

    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key.intern());
        }
    }

    public boolean removeChild(Element child) {
        boolean res = false;
        if (this.children != null) {
            res = this.children.remove(child);
        }
        return res;
    }

    public void setAttributeStaticStr(String[] elementPath, String att_name, String att_value) {
        Element child = this.findChildStaticStr(elementPath);
        if (child != null) {
            child.setAttribute(att_name, att_value);
        }
    }

    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new XMLIdentityHashMap(5);
        }
        String k = key.intern();
        String v = value;
        if (k == "xmlns") {
            v = this.xmlns = value.intern();
        }
        this.attributes.put(k, v);
    }

    public void setAttributes(StringBuilder[] names, StringBuilder[] values) {
        this.attributes = new XMLIdentityHashMap(names.length);
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            this.setAttribute(names[i].toString(), values[i].toString());
        }
    }

    public void setAttributes(String[] names, String[] values) {
        this.attributes = new XMLIdentityHashMap(names.length);
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            this.setAttribute(names[i], values[i]);
        }
    }

    public void setDefXMLNS(String ns) {
        this.defxmlns = ns.intern();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(result);
        return result.toString();
    }

    public void toString(StringBuilder result) {
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            result.append(">");
            this.childrenToString(result);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
    }

    @Override
    public String toStringPretty() {
        String childrenStr;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((childrenStr = this.childrenToStringPretty()) != null && childrenStr.length() > 0) {
            result.append(">");
            result.append("\n");
            result.append(childrenStr);
            result.append("</").append(this.name).append(">");
            result.append("\n");
        } else {
            result.append("/>");
            result.append("\n");
        }
        return result.toString();
    }

    public String toStringNoChildren() {
        String cdata;
        StringBuilder result = new StringBuilder();
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if ((cdata = this.cdataToString()) != null) {
            result.append(">");
            if (cdata != null) {
                result.append(cdata);
            }
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    @Override
    public String toStringSecure() {
        StringBuilder result = new StringBuilder();
        this.toStringSecure(result);
        return result.toString();
    }

    public void toStringSecure(StringBuilder result) {
        result.append("<").append(this.name);
        if (this.attributes != null) {
            for (String key : this.attributes.keySet()) {
                result.append(" ").append(key).append("=\"").append((String)this.attributes.get(key)).append("\"");
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            result.append(">");
            this.childrenToStringSecure(result);
            result.append("</").append(this.name).append(">");
        } else {
            result.append("/>");
        }
    }

    public Element withAttribute(String attName, String attValue) {
        this.setAttribute(attName, attValue);
        return this;
    }

    public Element withElement(String name, Consumer<Element> consumer) {
        return this.withElement(name, null, consumer);
    }

    public Element withElement(String name, String xmlns, String cdata) {
        Element el = new Element(name);
        if (xmlns != null) {
            el.setXMLNS(xmlns);
        }
        if (cdata != null) {
            el.addCData(cdata);
        }
        this.addChild(el);
        return this;
    }

    public Element withElement(String name, String xmlns, Consumer<Element> consumer) {
        Element el = new Element(name);
        if (xmlns != null) {
            el.setXMLNS(xmlns);
        }
        consumer.accept(el);
        this.addChild(el);
        return this;
    }

    protected String cdataToString() {
        StringBuilder result = new StringBuilder();
        if (this.children != null) {
            for (XMLNodeIfc child : this.children) {
                if (child == null || !(child instanceof CData)) continue;
                result.append(child.toString());
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    protected class XMLIdentityHashMap<K, V>
    extends IdentityHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        private XMLIdentityHashMap(int size) {
            super(size);
        }

        @Override
        public V put(K key, V value) {
            if (key == null || value == null) {
                throw new NullPointerException("Neither attribute key or value can be set to null. Attribute: " + key + ", value: " + value);
            }
            return super.put(key, value);
        }
    }

    public static interface Matcher<T> {
        public boolean match(T var1);
    }
}

