/*
 * Decompiled with CFR 0.152.
 */
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.UIDGenerator;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.JaxmppEvent;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xmpp.modules.chat.Chat;
import tigase.jaxmpp.core.client.xmpp.modules.chat.MessageModuleExtension;
import tigase.jaxmpp.core.client.xmpp.modules.extensions.Extension;
import tigase.jaxmpp.core.client.xmpp.stanzas.Message;

public class MessageDeliveryReceiptsExtension
implements MessageModuleExtension,
Extension {
    public static final String XMLNS = "urn:xmpp:receipts";
    private static final String RECEIVED_NAME = "received";
    private static final String REQUEST_NAME = "request";
    private final Context context;

    public MessageDeliveryReceiptsExtension(Context context) {
        this.context = context;
    }

    public Element afterReceive(Element received) throws JaxmppException {
        return received;
    }

    public Message beforeMessageProcess(Message message, Chat chat) throws JaxmppException {
        Element received;
        Element request = message.getChildrenNS(REQUEST_NAME, XMLNS);
        if (request != null) {
            String id = message.getId();
            Message response = Message.create();
            response.setId(UIDGenerator.next());
            response.setTo(message.getFrom());
            Element received2 = ElementFactory.create((String)RECEIVED_NAME, null, (String)XMLNS);
            if (id != null) {
                received2.setAttribute("id", id);
            }
            response.addChild(received2);
            this.context.getWriter().write((Element)response);
        }
        if ((received = message.getChildrenNS(RECEIVED_NAME, XMLNS)) != null) {
            String id = received.getAttribute("id");
            this.context.getEventBus().fire((Event)new ReceiptReceivedHandler.ReceiptReceivedEvent(this.context.getSessionObject(), chat, message, id));
        }
        return message;
    }

    public Element beforeSend(Element element) throws JaxmppException {
        if ("message".equals(element.getName())) {
            if (element.getAttribute("id") == null) {
                element.setAttribute("id", UIDGenerator.next());
            }
            element.addChild(ElementFactory.create((String)REQUEST_NAME, null, (String)XMLNS));
        }
        return element;
    }

    public String[] getFeatures() {
        return new String[]{XMLNS};
    }

    public static interface ReceiptReceivedHandler
    extends EventHandler {
        public void onReceiptReceived(SessionObject var1, Chat var2, Message var3, String var4);

        public static class ReceiptReceivedEvent
        extends JaxmppEvent<ReceiptReceivedHandler> {
            private Chat chat;
            private String confirmedId;
            private Message message;

            public ReceiptReceivedEvent(SessionObject sessionObject, Chat chat, Message msg, String confirmedId) {
                super(sessionObject);
                this.chat = chat;
                this.message = msg;
                this.confirmedId = confirmedId;
            }

            public void dispatch(ReceiptReceivedHandler handler) {
                handler.onReceiptReceived(this.sessionObject, this.chat, this.message, this.confirmedId);
            }

            public Chat getChat() {
                return this.chat;
            }

            public void setChat(Chat chat) {
                this.chat = chat;
            }

            public String getConfirmedId() {
                return this.confirmedId;
            }

            public void setConfirmedId(String confirmedId) {
                this.confirmedId = confirmedId;
            }

            public Message getMessage() {
                return this.message;
            }

            public void setMessage(Message message) {
                this.message = message;
            }
        }
    }
}

