/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;

public class BcTlsRSAVerifier
implements TlsVerifier {
    protected RSAKeyParameters pubKeyRSA;

    public BcTlsRSAVerifier(RSAKeyParameters rSAKeyParameters) {
        if (rSAKeyParameters == null) {
            throw new IllegalArgumentException("'pubKeyRSA' cannot be null");
        }
        if (rSAKeyParameters.isPrivate()) {
            throw new IllegalArgumentException("'pubKeyRSA' must be a public key");
        }
        this.pubKeyRSA = rSAKeyParameters;
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        GenericSigner genericSigner;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null) {
            if (signatureAndHashAlgorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            genericSigner = new RSADigestSigner((Digest)new NullDigest(), TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()));
        } else {
            genericSigner = new GenericSigner((AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine()), (Digest)new NullDigest());
        }
        genericSigner.init(false, (CipherParameters)this.pubKeyRSA);
        genericSigner.update(byArray, 0, byArray.length);
        return genericSigner.verifySignature(digitallySigned.getSignature());
    }
}

