/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import org.bouncycastle.util.BigIntegers;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhDomain;

    public BcTlsDHDomain(BcTlsCrypto bcTlsCrypto, TlsDHConfig tlsDHConfig) {
        this.crypto = bcTlsCrypto;
        this.dhConfig = tlsDHConfig;
        this.dhDomain = this.getParameters(tlsDHConfig);
    }

    public byte[] calculateDHAgreement(DHPublicKeyParameters dHPublicKeyParameters, DHPrivateKeyParameters dHPrivateKeyParameters) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init((CipherParameters)dHPrivateKeyParameters);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement((CipherParameters)dHPublicKeyParameters);
        return BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
    }

    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public static BigInteger decodeParameter(byte[] byArray) throws IOException {
        return new BigInteger(1, byArray);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] byArray) throws IOException {
        try {
            BigInteger bigInteger = BcTlsDHDomain.decodeParameter(byArray);
            return new DHPublicKeyParameters(bigInteger, this.dhDomain);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public byte[] encodeParameter(BigInteger bigInteger) throws IOException {
        return BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters dHPublicKeyParameters) throws IOException {
        return this.encodeParameter(dHPublicKeyParameters.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init((KeyGenerationParameters)new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhDomain));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }

    public BcTlsCrypto getCrypto() {
        return this.crypto;
    }

    public DHParameters getParameters(TlsDHConfig tlsDHConfig) {
        BigInteger[] bigIntegerArray = tlsDHConfig.getExplicitPG();
        if (bigIntegerArray != null) {
            return new DHParameters(bigIntegerArray[0], bigIntegerArray[1]);
        }
        throw new IllegalStateException("No DH configuration provided");
    }
}

