/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_elliptic_curves = Integers.valueOf((int)10);
    public static final Integer EXT_ec_point_formats = Integers.valueOf((int)11);

    public static void addSupportedEllipticCurvesExtension(Hashtable hashtable, int[] nArray) throws IOException {
        hashtable.put(EXT_elliptic_curves, TlsECCUtils.createSupportedEllipticCurvesExtension(nArray));
    }

    public static void addSupportedPointFormatsExtension(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(sArray));
    }

    public static int[] getSupportedEllipticCurvesExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_elliptic_curves);
        return byArray == null ? null : TlsECCUtils.readSupportedEllipticCurvesExtension(byArray);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_ec_point_formats);
        return byArray == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static byte[] createSupportedEllipticCurvesExtension(int[] nArray) throws IOException {
        if (nArray == null || nArray.length < 1) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(nArray);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] sArray) throws IOException {
        if (sArray == null || !Arrays.contains((short[])sArray, (short)0)) {
            sArray = Arrays.append((short[])sArray, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static int[] readSupportedEllipticCurvesExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (s < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = TlsUtils.readUint8Array(s, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static boolean containsECCipherSuites(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!TlsECCUtils.isECCipherSuite(nArray[i])) continue;
            return true;
        }
        return false;
    }

    public static int getMinimumCurveBits(int n) {
        switch (n) {
            case 65024: 
            case 65026: 
            case 65028: {
                return 255;
            }
            case 65025: 
            case 65027: 
            case 65029: {
                return 384;
            }
        }
        if (!TlsECCUtils.isECCipherSuite(n)) {
            return 0;
        }
        return 1;
    }

    public static boolean isECCipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static short getCompressionFormat(int n) throws IOException {
        if (NamedCurve.isPrime(n)) {
            return 1;
        }
        if (NamedCurve.isChar2(n)) {
            return 2;
        }
        throw new TlsFatalAlert(47);
    }

    public static boolean isCompressionPreferred(short[] sArray, int n) throws IOException {
        return TlsECCUtils.isCompressionPreferred(sArray, TlsECCUtils.getCompressionFormat(n));
    }

    public static boolean isCompressionPreferred(short[] sArray, short s) {
        if (sArray == null || s == 0) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            short s2 = sArray[i];
            if (s2 == 0) {
                return false;
            }
            if (s2 != s) continue;
            return true;
        }
        return false;
    }

    public static void checkPointEncoding(short[] sArray, int n, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 1) {
            throw new TlsFatalAlert(47);
        }
        short s = TlsECCUtils.getActualFormat(n, byArray);
        TlsECCUtils.checkActualFormat(sArray, s);
    }

    public static void checkActualFormat(short[] sArray, short s) throws IOException {
        if (!(s == 0 || sArray != null && Arrays.contains((short[])sArray, (short)s))) {
            throw new TlsFatalAlert(47);
        }
    }

    public static short getActualFormat(int n, byte[] byArray) throws IOException {
        switch (byArray[0]) {
            case 2: 
            case 3: {
                return TlsECCUtils.getCompressionFormat(n);
            }
            case 4: {
                return 0;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig readECConfig(short[] sArray, InputStream inputStream) throws IOException {
        short s = TlsUtils.readUint8(inputStream);
        if (s != 3) {
            throw new TlsFatalAlert(40);
        }
        int n = TlsUtils.readUint16(inputStream);
        if (!NamedCurve.refersToASpecificNamedCurve(n)) {
            throw new TlsFatalAlert(47);
        }
        boolean bl = TlsECCUtils.isCompressionPreferred(sArray, n);
        TlsECConfig tlsECConfig = new TlsECConfig();
        tlsECConfig.setNamedCurve(n);
        tlsECConfig.setPointCompression(bl);
        return tlsECConfig;
    }

    public static TlsECConfig receiveECConfig(TlsECConfigVerifier tlsECConfigVerifier, short[] sArray, InputStream inputStream) throws IOException {
        TlsECConfig tlsECConfig = TlsECCUtils.readECConfig(sArray, inputStream);
        if (!tlsECConfigVerifier.accept(tlsECConfig)) {
            throw new TlsFatalAlert(47);
        }
        return tlsECConfig;
    }

    public static void writeECConfig(TlsECConfig tlsECConfig, OutputStream outputStream) throws IOException {
        TlsECCUtils.writeNamedECParameters(tlsECConfig.getNamedCurve(), outputStream);
    }

    public static void writeNamedECParameters(int n, OutputStream outputStream) throws IOException {
        if (!NamedCurve.refersToASpecificNamedCurve(n)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, outputStream);
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
    }
}

