/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.filetransfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.Property;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.JaxmppEvent;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.factory.UniversalFactory;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.ContextAware;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.disco.DiscoveryModule;
import tigase.jaxmpp.core.client.xmpp.modules.disco.NodeDetailsCallback;
import tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransferModule;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.JingleModule;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Socks5BytestreamsModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;
import tigase.jaxmpp.core.client.xmpp.stanzas.Presence;
import tigase.jaxmpp.j2se.J2SECapabiliesCache;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.socks5bytestream.J2SEStreamhostsResolver;
import tigase.jaxmpp.j2se.connection.socks5bytestream.StreamhostsResolver;
import tigase.jaxmpp.j2se.filetransfer.FileTransfer;
import tigase.jaxmpp.j2se.filetransfer.FileTransferNegotiator;
import tigase.jaxmpp.j2se.filetransfer.JingleFileTransferNegotiator;
import tigase.jaxmpp.j2se.filetransfer.Socks5FileTransferNegotiator;

public class FileTransferManager
implements ContextAware,
FileTransferNegotiator.NegotiationFailureHandler,
FileTransferNegotiator.NegotiationRejectHandler,
FileTransferNegotiator.NegotiationRequestHandler,
ConnectionManager.ConnectionEstablishedHandler,
Property {
    private static final Logger log = Logger.getLogger(FileTransferManager.class.getCanonicalName());
    protected Context context = null;
    private JaxmppCore jaxmpp = null;
    private final List<FileTransferNegotiator> negotiators = new ArrayList<FileTransferNegotiator>();

    public static void initialize(JaxmppCore jaxmpp, boolean experimental) {
        CapabilitiesModule capsModule = (CapabilitiesModule)jaxmpp.getModule(CapabilitiesModule.class);
        if (capsModule != null && capsModule.getCache() == null) {
            capsModule.setCache(new J2SECapabiliesCache());
        }
        FileTransferManager fileTransferManager = new FileTransferManager();
        fileTransferManager.setContext(jaxmpp.getContext());
        fileTransferManager.setJaxmpp(jaxmpp);
        jaxmpp.getModulesManager().register((XmppModule)new FileTransferModule(jaxmpp.getContext()));
        jaxmpp.getModulesManager().register((XmppModule)new Socks5BytestreamsModule(jaxmpp.getContext()));
        if (experimental) {
            jaxmpp.getModulesManager().register((XmppModule)new JingleModule(jaxmpp.getContext()));
            fileTransferManager.addNegotiator(new JingleFileTransferNegotiator());
        }
        fileTransferManager.addNegotiator(new Socks5FileTransferNegotiator());
    }

    protected static String getCapsNode(Presence presence) throws XMLException {
        if (presence == null) {
            return null;
        }
        Element c = presence.getChildrenNS("c", "http://jabber.org/protocol/caps");
        if (c == null) {
            return null;
        }
        String node = c.getAttribute("node");
        String ver = c.getAttribute("ver");
        if (node == null || ver == null) {
            return null;
        }
        return node + "#" + ver;
    }

    public void acceptFile(FileTransfer ft) throws JaxmppException {
        if (ft.getFile() == null) {
            this.fireOnFailure(ft);
            throw new JaxmppException("Destination file not set! Cannot accept file transfer without destination file!");
        }
        ft.setIncoming(true);
        ft.getNegotiator().acceptFile(this.jaxmpp, ft);
    }

    public void addNegotiator(FileTransferNegotiator negotiator) {
        negotiator.setContext(this.context);
        negotiator.registerListeners(this.jaxmpp);
        this.negotiators.add(negotiator);
    }

    private void fireOnFailure(FileTransfer ft) {
        this.context.getEventBus().fire((Event)new FileTransferFailureHandler.FileTransferFailureEvent(ft.getSessionObject(), ft));
    }

    private void fireOnProgress(FileTransfer ft) {
        this.context.getEventBus().fire((Event)new FileTransferProgressHandler.FileTransferProgressEvent(ft.getSessionObject(), ft));
    }

    private void fireOnSuccess(FileTransfer ft) {
        this.context.getEventBus().fire((Event)new FileTransferSuccessHandler.FileTransferSuccessEvent(ft.getSessionObject(), ft));
    }

    private String generateSid() {
        return UUID.randomUUID().toString();
    }

    public Class<FileTransferManager> getPropertyClass() {
        return FileTransferManager.class;
    }

    @Override
    public void onConnectionEstablished(SessionObject sessionObject, ConnectionSession connectionSession, Socket socket) throws JaxmppException {
        if (socket == null) {
            throw new JaxmppException("SOCKET IS NULL");
        }
        if (!(connectionSession instanceof FileTransfer)) {
            return;
        }
        FileTransfer fileTransfer = (FileTransfer)connectionSession;
        if (fileTransfer.isIncoming()) {
            this.startReceiving(fileTransfer, socket);
        } else {
            this.startSending(fileTransfer, socket);
        }
    }

    @Override
    public void onFileTransferNegotiationFailure(SessionObject sessionObject, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer fileTransfer) throws JaxmppException {
        FileTransfer ft = (FileTransfer)fileTransfer;
        if (!ft.isIncoming()) {
            FileTransferNegotiator oldNegotiator = ft.getNegotiator();
            boolean start = false;
            for (FileTransferNegotiator negotiator : this.negotiators) {
                if (negotiator == oldNegotiator) {
                    start = true;
                    continue;
                }
                if (!start || !negotiator.isSupported(this.jaxmpp, ft)) continue;
                ft.setNegotiator(negotiator);
                negotiator.sendFile(this.jaxmpp, ft);
                return;
            }
        }
        this.fireOnFailure(ft);
    }

    @Override
    public void onFileTransferNegotiationReject(SessionObject sessionObject, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer fileTransfer) {
        this.context.getEventBus().fire((Event)new FileTransferRejectedHandler.FileTransferRejectedEvent(sessionObject, (FileTransfer)fileTransfer));
    }

    @Override
    public void onFileTransferNegotiationRequest(SessionObject sessionObject, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer fileTransfer) {
        this.context.getEventBus().fire((Event)new FileTransferRequestHandler.FileTransferRequestEvent(sessionObject, (FileTransfer)fileTransfer));
    }

    public void rejectFile(FileTransfer ft) throws JaxmppException {
        ft.setIncoming(true);
        ft.getNegotiator().rejectFile(this.jaxmpp, ft);
    }

    public void removeNegotiator(FileTransferNegotiator negotiator) {
        this.negotiators.remove(negotiator);
        negotiator.unregisterListeners(this.jaxmpp);
        negotiator.setContext(this.context);
    }

    private FileTransfer sendFile(FileTransfer ft) throws JaxmppException {
        boolean send = false;
        for (FileTransferNegotiator negotiator : this.negotiators) {
            if (!negotiator.isSupported(this.jaxmpp, ft)) continue;
            ft.setNegotiator(negotiator);
            negotiator.sendFile(this.jaxmpp, ft);
            send = true;
            break;
        }
        if (!send) {
            throw new JaxmppException("No file transfer methods supported by recipient = " + ft.getPeer().toString());
        }
        return ft;
    }

    public FileTransfer sendFile(JID peer, File file) throws JaxmppException {
        FileTransfer ft = new FileTransfer(this.jaxmpp.getSessionObject(), peer, this.generateSid());
        ft.setIncoming(false);
        ft.setFileInfo(file.getName(), file.length(), new Date(file.lastModified()), null);
        ft.setFile(file);
        return this.sendFile(ft);
    }

    public FileTransfer sendFile(JID peer, String filename, long fileSize, InputStream is, Date lastModified) throws JaxmppException {
        FileTransfer ft = new FileTransfer(this.jaxmpp.getSessionObject(), peer, this.generateSid());
        ft.setIncoming(false);
        ft.setFileInfo(filename, fileSize, lastModified, null);
        ft.setInputStream(is);
        return this.sendFile(ft);
    }

    public void setContext(Context context) {
        this.context = context;
        this.context.getEventBus().addHandler(ConnectionManager.ConnectionEstablishedHandler.ConnectionEstablishedEvent.class, (EventHandler)this);
        this.context.getEventBus().addHandler(FileTransferNegotiator.NegotiationFailureHandler.FileTransferNegotiationFailureEvent.class, (EventHandler)this);
        this.context.getEventBus().addHandler(FileTransferNegotiator.NegotiationRejectHandler.FileTransferNegotiationRejectEvent.class, (EventHandler)this);
        this.context.getEventBus().addHandler(FileTransferNegotiator.NegotiationRequestHandler.FileTransferNegotiationRequestEvent.class, (EventHandler)this);
    }

    public void setJaxmpp(JaxmppCore jaxmpp) {
        this.jaxmpp = jaxmpp;
        jaxmpp.set((Property)this);
        DiscoveryModule discoveryModule = (DiscoveryModule)jaxmpp.getModule(DiscoveryModule.class);
        if (discoveryModule != null) {
            discoveryModule.setNodeCallback(null, (NodeDetailsCallback)new DiscoveryModule.DefaultNodeDetailsCallback(discoveryModule){

                public String[] getFeatures(SessionObject sessionObject, IQ requestStanza, String node) {
                    HashSet<String> features = new HashSet<String>();
                    String[] defaultFeatures = super.getFeatures(sessionObject, requestStanza, node);
                    if (defaultFeatures == null) {
                        features.addAll(Arrays.asList(defaultFeatures));
                    }
                    for (FileTransferNegotiator negotiator : FileTransferManager.this.negotiators) {
                        String[] negFeatures = negotiator.getFeatures();
                        if (negFeatures == null) continue;
                        for (String negFeature : negFeatures) {
                            features.add(negFeature);
                        }
                    }
                    return features.toArray(new String[features.size()]);
                }
            });
        }
    }

    private void startReceiving(final FileTransfer fileTransfer, final Socket socket) {
        new Thread(){

            @Override
            public void run() {
                try {
                    File f = fileTransfer.getFile();
                    FileOutputStream fos = new FileOutputStream(f);
                    FileTransferManager.this.transferData(fileTransfer, socket.getInputStream(), new BufferedOutputStream(fos));
                    fos.close();
                    socket.close();
                    FileTransferManager.this.fireOnSuccess(fileTransfer);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "exception transfering data", ex);
                    FileTransferManager.this.fireOnFailure(fileTransfer);
                }
            }
        }.start();
    }

    private void startSending(final FileTransfer fileTransfer, final Socket socket) {
        new Thread(){

            @Override
            public void run() {
                try {
                    InputStream fis = fileTransfer.getInputStream();
                    if (fis == null) {
                        File f = fileTransfer.getFile();
                        fis = new BufferedInputStream(new FileInputStream(f));
                    }
                    FileTransferManager.this.transferData(fileTransfer, fis, socket.getOutputStream());
                    fis.close();
                    socket.close();
                    FileTransferManager.this.fireOnSuccess(fileTransfer);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "exception transfering data", ex);
                    FileTransferManager.this.fireOnFailure(fileTransfer);
                }
            }
        }.start();
    }

    private void transferData(FileTransfer ft, InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] data = new byte[16384];
        while ((read = in.read(data)) > -1) {
            out.write(data, 0, read);
            ft.transferredBytes(read);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "transferred bytes = {0}", ft.getTransferredBytes());
            }
            this.fireOnProgress(ft);
        }
        out.flush();
    }

    static {
        UniversalFactory.setSpi((String)StreamhostsResolver.class.getCanonicalName(), (UniversalFactory.FactorySpi)new UniversalFactory.FactorySpi<J2SEStreamhostsResolver>(){

            public J2SEStreamhostsResolver create() {
                return new J2SEStreamhostsResolver();
            }
        });
    }

    public static interface FileTransferSuccessHandler
    extends EventHandler {
        public void onFileTransferSuccess(SessionObject var1, FileTransfer var2);

        public static class FileTransferSuccessEvent
        extends JaxmppEvent<FileTransferSuccessHandler> {
            private FileTransfer fileTransfer;

            public FileTransferSuccessEvent(SessionObject sessionObject, FileTransfer fileTransfer) {
                super(sessionObject);
                this.fileTransfer = fileTransfer;
            }

            protected void dispatch(FileTransferSuccessHandler handler) throws Exception {
                handler.onFileTransferSuccess(this.sessionObject, this.fileTransfer);
            }
        }
    }

    public static interface FileTransferRequestHandler
    extends EventHandler {
        public void onFileTransferRequest(SessionObject var1, FileTransfer var2);

        public static class FileTransferRequestEvent
        extends JaxmppEvent<FileTransferRequestHandler> {
            private FileTransfer fileTransfer;

            public FileTransferRequestEvent(SessionObject sessionObject, FileTransfer fileTransfer) {
                super(sessionObject);
                this.fileTransfer = fileTransfer;
            }

            protected void dispatch(FileTransferRequestHandler handler) throws Exception {
                handler.onFileTransferRequest(this.sessionObject, this.fileTransfer);
            }
        }
    }

    public static interface FileTransferRejectedHandler
    extends EventHandler {
        public void onFileTransferRejected(SessionObject var1, FileTransfer var2);

        public static class FileTransferRejectedEvent
        extends JaxmppEvent<FileTransferRejectedHandler> {
            private FileTransfer fileTransfer;

            public FileTransferRejectedEvent(SessionObject sessionObject, FileTransfer fileTransfer) {
                super(sessionObject);
                this.fileTransfer = fileTransfer;
            }

            protected void dispatch(FileTransferRejectedHandler handler) throws Exception {
                handler.onFileTransferRejected(this.sessionObject, this.fileTransfer);
            }
        }
    }

    public static interface FileTransferProgressHandler
    extends EventHandler {
        public void onFileTransferProgress(SessionObject var1, FileTransfer var2);

        public static class FileTransferProgressEvent
        extends JaxmppEvent<FileTransferProgressHandler> {
            private FileTransfer fileTransfer;

            public FileTransferProgressEvent(SessionObject sessionObject, FileTransfer fileTransfer) {
                super(sessionObject);
                this.fileTransfer = fileTransfer;
            }

            protected void dispatch(FileTransferProgressHandler handler) throws Exception {
                handler.onFileTransferProgress(this.sessionObject, this.fileTransfer);
            }
        }
    }

    public static interface FileTransferFailureHandler
    extends EventHandler {
        public void onFileTransferFailure(SessionObject var1, FileTransfer var2);

        public static class FileTransferFailureEvent
        extends JaxmppEvent<FileTransferFailureHandler> {
            private FileTransfer fileTransfer;

            public FileTransferFailureEvent(SessionObject sessionObject, FileTransfer fileTransfer) {
                super(sessionObject);
                this.fileTransfer = fileTransfer;
            }

            protected void dispatch(FileTransferFailureHandler handler) throws Exception {
                handler.onFileTransferFailure(this.sessionObject, this.fileTransfer);
            }
        }
    }
}

