/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.websocket;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.connector.AbstractWebSocketConnector;
import tigase.jaxmpp.core.client.connector.SeeOtherHostHandler;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.utils.MutableBoolean;
import tigase.jaxmpp.j2se.connectors.socket.Reader;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;
import tigase.jaxmpp.j2se.connectors.socket.Worker;
import tigase.jaxmpp.j2se.connectors.websocket.WebSocketReader;

public class WebSocketConnector
extends AbstractWebSocketConnector {
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final String EOL = "\r\n";
    private static final byte[] HTTP_RESPONSE_101 = "HTTP/1.1 101 ".getBytes(UTF_CHARSET);
    private static final String SEC_UUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String WEB_SOCKET_TIMEOUT_KEY = "WEB_SOCKET_TIMEOUT_KEY";
    private final Object ioMutex = new Object();
    private TimerTask pingTask;
    private Reader reader = null;
    private Socket socket = null;
    private Timer timer = null;
    private Worker worker = null;
    private OutputStream writer = null;
    private Random random = new SecureRandom();
    private byte[] mask = new byte[4];
    private Timer closeTimer;

    public WebSocketConnector(Context context) {
        super(context);
        context.getEventBus().addHandler(SeeOtherHostHandler.SeeOtherHostEvent.class, (EventHandler)new SeeOtherHostHandler(){

            public void onSeeOtherHost(String seeHost, MutableBoolean handled) {
                WebSocketConnector.this.context.getSessionObject().setUserProperty("BOSH_SERVICE_URL_KEY", (Object)seeHost);
            }
        });
    }

    private void closeSocket() {
        if (this.socket.isConnected()) {
            try {
                this.writer.write(new byte[]{-120, 0});
                this.socket.close();
            }
            catch (IOException ex) {
                this.log.log(Level.FINEST, "Problem with closing socket", ex);
            }
        }
    }

    protected KeyManager[] getKeyManagers() throws NoSuchAlgorithmException {
        KeyManager[] result = (KeyManager[])this.context.getSessionObject().getProperty("KEY_MANAGERS_KEY");
        return result == null ? new KeyManager[]{} : result;
    }

    private void handshake(URI uri) throws IOException {
        String wskey = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("GET ").append(uri.getPath() != null ? uri.getPath() : "/").append(" HTTP/1.1").append(EOL);
        sb.append("Host: ").append(uri.getHost());
        if (uri.getPort() != -1) {
            sb.append(":").append(uri.getPort());
        }
        sb.append(EOL);
        sb.append("Connection: Upgrade").append(EOL);
        sb.append("Upgrade: websocket").append(EOL);
        sb.append("Sec-WebSocket-Key: ").append(wskey).append(EOL);
        sb.append("Sec-WebSocket-Protocol: ").append("xmpp").append(",").append("xmpp-framing").append(EOL);
        sb.append("Sec-WebSocket-Version: 13").append(EOL);
        sb.append(EOL);
        byte[] buffer = sb.toString().getBytes(UTF_CHARSET);
        this.socket.getOutputStream().write(buffer);
        buffer = new byte[4096];
        int read = 0;
        HashMap<String, String> headers = new HashMap<String, String>();
        sb = new StringBuilder();
        boolean eol = false;
        boolean httpResponseOk = false;
        String key = null;
        while ((read = this.socket.getInputStream().read(buffer, 0, buffer.length)) != -1) {
            if (!httpResponseOk) {
                for (int i = 0; i < HTTP_RESPONSE_101.length; ++i) {
                    if (buffer[i] == HTTP_RESPONSE_101[i]) continue;
                    throw new IOException("Wrong HTTP response, got: " + new String(buffer));
                }
            }
            boolean headersRead = false;
            for (int i = 0; i < read; ++i) {
                byte b = buffer[i];
                switch (b) {
                    case 58: {
                        if (key == null) {
                            key = sb.toString();
                            sb = new StringBuilder(64);
                            ++i;
                        } else {
                            sb.append((char)b);
                        }
                        eol = false;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 13: {
                        if (eol) {
                            headersRead = true;
                            break;
                        }
                        if (key != null) {
                            headers.put(key.trim(), sb.toString().trim());
                            key = null;
                        }
                        sb = new StringBuilder(64);
                        eol = true;
                        break;
                    }
                    default: {
                        sb.append((char)b);
                        eol = false;
                    }
                }
                if (headersRead) break;
            }
            if (!headersRead) continue;
            break;
        }
        try {
            String accept = Base64.encode((byte[])MessageDigest.getInstance("SHA-1").digest((wskey + SEC_UUID).getBytes(UTF_CHARSET)));
            if (!accept.equals(headers.get("Sec-WebSocket-Accept"))) {
                throw new IOException("Invalid Sec-WebSocket-Accept header value");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Could not validate 'Sec-WebSocket-Accept' header", ex);
        }
        String protocol = (String)headers.get("Sec-WebSocket-Protocol");
        if ("xmpp-framing".equals(protocol)) {
            this.rfcCompatible = true;
        } else if (!"xmpp".equals(protocol)) {
            throw new IOException("Established unsupported WebSocket protocol: " + protocol);
        }
    }

    public boolean isSecure() {
        return (Boolean)this.context.getSessionObject().getProperty("CONNECTOR#ENCRYPTED_KEY") == Boolean.TRUE;
    }

    protected void onErrorInThread(Exception e) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.terminateAllWorkers();
        this.fireOnError(null, e, this.context.getSessionObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(byte[] buffer) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Send: " + new String(buffer));
                    }
                    int size = buffer.length;
                    this.random.nextBytes(this.mask);
                    byte maskedLen = -128;
                    ByteBuffer bbuf = ByteBuffer.allocate(12);
                    bbuf.put((byte)-127);
                    if (size <= 125) {
                        maskedLen = (byte)(maskedLen | (byte)size);
                        bbuf.put(maskedLen);
                    } else if (size <= 65535) {
                        maskedLen = (byte)(maskedLen | 0x7E);
                        bbuf.put(maskedLen);
                        bbuf.putShort((short)size);
                    } else {
                        maskedLen = (byte)(maskedLen | 0x7F);
                        bbuf.put(maskedLen);
                        bbuf.putLong(size);
                    }
                    bbuf.flip();
                    this.writer.write(bbuf.array(), 0, bbuf.remaining());
                    this.writer.write(this.mask, 0, 4);
                    for (int i = 0; i < buffer.length; ++i) {
                        buffer[i] = (byte)(buffer[i] ^ this.mask[i % 4]);
                    }
                    this.writer.write(buffer);
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new JaxmppException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Element stanza) throws XMLException, JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                super.send(stanza);
            }
        }
    }

    public void send(String data) throws JaxmppException {
        if (this.getState() != Connector.State.connected && this.getState() != Connector.State.connecting && this.getState() != Connector.State.disconnecting) {
            throw new JaxmppException("Not connected");
        }
        this.send(data.getBytes(UTF_CHARSET));
    }

    public void start() throws XMLException, JaxmppException {
        this.log.fine("Start connector.");
        super.start();
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.timer = new Timer(true);
        if (this.context.getSessionObject().getProperty("HOSTNAME_VERIFIER_DISABLED_KEY") == Boolean.TRUE) {
            this.context.getSessionObject().setProperty("HOSTNAME_VERIFIER_KEY", null);
        } else if (this.context.getSessionObject().getProperty("HOSTNAME_VERIFIER_KEY") == null) {
            this.context.getSessionObject().setProperty("HOSTNAME_VERIFIER_KEY", (Object)SocketConnector.DEFAULT_HOSTNAME_VERIFIER);
        }
        this.setStage(Connector.State.connecting);
        try {
            String url = (String)this.context.getSessionObject().getProperty("BOSH_SERVICE_URL_KEY");
            URI uri = URI.create(url);
            InetAddress x = InetAddress.getByName(uri.getHost());
            boolean isSecure = uri.getScheme().startsWith("wss");
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Preparing connection to " + uri.getHost());
            }
            int port = uri.getPort() == -1 ? (isSecure ? 443 : 80) : uri.getPort();
            this.log.info("Opening connection to " + x + ":" + port);
            if (this.context.getSessionObject().getProperty("PROXY_HOST_KEY") != null) {
                String proxyHost = (String)this.context.getSessionObject().getProperty("PROXY_HOST_KEY");
                int proxyPort = (Integer)this.context.getSessionObject().getProperty("PROXY_PORT_KEY");
                Proxy.Type proxyType = (Proxy.Type)((Object)this.context.getSessionObject().getProperty("PROXY_TYPE_KEY"));
                if (proxyType == null) {
                    proxyType = Proxy.Type.HTTP;
                }
                this.log.info("Using " + (Object)((Object)proxyType) + " proxy: " + proxyHost + ":" + proxyPort);
                InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(proxyType, addr);
                this.socket = new Socket(proxy);
            } else {
                this.socket = new Socket();
            }
            Integer soTimeout = this.getTimeout(WEB_SOCKET_TIMEOUT_KEY, 180000);
            if (soTimeout != null) {
                this.socket.setSoTimeout(soTimeout);
            }
            this.socket.setKeepAlive(false);
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress(x, port));
            if (isSecure) {
                SSLSocketFactory factory;
                TrustManager[] trustManagers = (TrustManager[])this.context.getSessionObject().getProperty("TRUST_MANAGERS_KEY");
                if (trustManagers == null) {
                    factory = this.context.getSessionObject().getProperty("socket#SSLSocketFactory") != null ? (SSLSocketFactory)this.context.getSessionObject().getProperty("socket#SSLSocketFactory") : (SSLSocketFactory)SSLSocketFactory.getDefault();
                } else {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(this.getKeyManagers(), trustManagers, new SecureRandom());
                    factory = ctx.getSocketFactory();
                }
                this.socket = factory.createSocket(this.socket, x.getHostAddress(), port, true);
                this.socket.setSoTimeout(0);
                this.socket.setKeepAlive(false);
                this.socket.setTcpNoDelay(true);
                ((SSLSocket)this.socket).setUseClientMode(true);
                ((SSLSocket)this.socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                    @Override
                    public void handshakeCompleted(HandshakeCompletedEvent arg0) {
                        WebSocketConnector.this.log.info("TLS completed " + arg0);
                        WebSocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#ENCRYPTED_KEY", (Object)Boolean.TRUE);
                        WebSocketConnector.this.context.getEventBus().fire((Event)new Connector.EncryptionEstablishedHandler.EncryptionEstablishedEvent(WebSocketConnector.this.context.getSessionObject()));
                    }
                });
            }
            this.writer = this.socket.getOutputStream();
            this.worker = new Worker((Connector)this){

                @Override
                protected Reader getReader() {
                    return WebSocketConnector.this.reader;
                }

                @Override
                protected void onErrorInThread(Exception e) throws JaxmppException {
                    WebSocketConnector.this.onErrorInThread(e);
                }

                @Override
                protected void onStreamStart(Map<String, String> attribs) {
                    WebSocketConnector.this.onStreamStart(attribs);
                }

                @Override
                protected void onStreamTerminate() throws JaxmppException {
                    WebSocketConnector.this.onStreamTerminate();
                }

                @Override
                protected void processElement(Element elem) throws JaxmppException {
                    WebSocketConnector.this.processElement(elem);
                }

                @Override
                protected void workerTerminated() {
                    WebSocketConnector.this.workerTerminated(this);
                }
            };
            this.log.finest("Starting WebSocket handshake...");
            this.handshake(uri);
            this.reader = new WebSocketReader(this.socket.getInputStream());
            this.log.finest("Starting worker...");
            this.worker.start();
            this.restartStream();
            this.setStage(Connector.State.connected);
            this.pingTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                WebSocketConnector.this.keepalive();
                            }
                            catch (JaxmppException e) {
                                WebSocketConnector.this.log.log(Level.SEVERE, "Can't ping!", e);
                            }
                        }
                    }.start();
                }
            };
            if (this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY") == null || !((Boolean)this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY")).booleanValue()) {
                Integer defaultDelay = this.getTimeout("PLAIN_SOCKET_TIMEOUT_KEY", 180000);
                defaultDelay = defaultDelay == null ? -1 : defaultDelay - 5000;
                Integer delay = this.getTimeout("KEEP_ALIVE_DELAY_KEY", defaultDelay);
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Whitespace ping period is setted to " + delay + "ms");
                }
                if (delay != null) {
                    this.timer.schedule(this.pingTask, delay.intValue(), (long)delay.intValue());
                }
            }
            this.fireOnConnected(this.context.getSessionObject());
        }
        catch (Exception e) {
            this.terminateAllWorkers();
            this.onError(null, e);
            throw new JaxmppException((Throwable)e);
        }
    }

    protected void terminateAllWorkers() throws JaxmppException {
        this.log.finest("Terminating all workers");
        if (this.pingTask != null) {
            this.pingTask.cancel();
            this.pingTask = null;
        }
        if (this.socket != null && this.socket.isConnected()) {
            if (this.closeTimer != null) {
                this.closeTimer.cancel();
            }
            this.closeTimer = new Timer();
            this.closeTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WebSocketConnector.this.closeSocket();
                    WebSocketConnector.this.closeTimer.cancel();
                    try {
                        WebSocketConnector.this.setStage(Connector.State.disconnected);
                    }
                    catch (JaxmppException ex) {
                        WebSocketConnector.this.log.log(Level.FINEST, "Exception while updating connector state during connection close", ex);
                    }
                    WebSocketConnector.this.closeTimer = null;
                }
            }, 3000L);
        } else {
            this.setStage(Connector.State.disconnected);
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with canceling timer", e);
        }
        finally {
            this.timer = null;
        }
    }

    private void workerTerminated(Worker worker) {
        try {
            if (this.closeTimer != null) {
                this.closeTimer.cancel();
                this.closeTimer = null;
            }
            this.setStage(Connector.State.disconnected);
        }
        catch (JaxmppException jaxmppException) {
            // empty catch block
        }
        this.log.finest("Worker terminated");
        try {
            if (this.context.getSessionObject().getProperty("s:reconnecting") == Boolean.TRUE) {
                this.context.getSessionObject().setProperty("s:reconnecting", null);
                this.context.getEventBus().fire((Event)new SocketConnector.HostChangedHandler.HostChangedEvent(this.context.getSessionObject()));
                this.log.finest("Restarting...");
                this.start();
            } else {
                this.context.getEventBus().fire((Event)new Connector.DisconnectedHandler.DisconnectedEvent(this.context.getSessionObject()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot terminate worker correctly", e);
        }
    }
}

