/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connection.socks5bytestream;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xmpp.modules.ResourceBinderModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionEndpoint;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.Candidate;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.JingleModule;
import tigase.jaxmpp.core.client.xmpp.modules.jingle.Transport;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.Streamhost;
import tigase.jaxmpp.core.client.xmpp.utils.MutableBoolean;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.ConnectionSessionHandler;
import tigase.jaxmpp.j2se.connection.socks5bytestream.Socks5ConnectionManager;

public class JingleSocks5BytestreamsConnectionManager
extends Socks5ConnectionManager {
    public static final String CANDIDATE_USED_KEY = "candidate-used";
    private static final Logger log = Logger.getLogger("JingleSocks5BytestreamsConnectionManager");
    public static final String XMLNS = "urn:xmpp:jingle:transports:s5b:1";
    public static final String SOCKS5_TRANSPORT_KEY = "socks5-transport-key-urn:xmpp:jingle:transports:s5b:1";
    public static final String TRANSPORT_USED_KEY = "transport-used";
    public static final String TRANSPORTS_KEY = "transports-key";
    private final ConnectionManager.ConnectionEstablishedHandler connectionEstablishedHandler = new ConnectionManager.ConnectionEstablishedHandler(){

        @Override
        public void onConnectionEstablished(SessionObject sessionObject, ConnectionSession session, Socket socket) throws JaxmppException {
            if (session.isIncoming()) {
                JingleSocks5BytestreamsConnectionManager.this.sendCandidateUsed(session);
            }
        }
    };
    private final ConnectionSessionHandler connectionSessionHandler;

    public JingleSocks5BytestreamsConnectionManager(ConnectionSessionHandler handler) {
        this.connectionSessionHandler = handler;
    }

    private void candidateUsedReceived(JID sender, String sid, String transportSid, String cid) {
        ConnectionSession session = this.connectionSessionHandler.getSession(sid);
        if (session == null) {
            return;
        }
        try {
            Transport transport = (Transport)session.getData(SOCKS5_TRANSPORT_KEY);
            if (!transport.getSid().equals(transportSid)) {
                return;
            }
            Candidate candidate = null;
            for (Candidate c : transport.getCandidates()) {
                if (!c.getCid().equals(cid)) continue;
                candidate = c;
                break;
            }
            if (candidate.getType() == Candidate.Type.proxy) {
                JaxmppCore jaxmpp = (JaxmppCore)session.getData("jaxmpp");
                this.connectToProxy(jaxmpp, session, transport.getSid(), (ConnectionEndpoint)candidate);
            } else {
                this.fireOnConnected(session);
            }
        }
        catch (Exception ex) {
            this.fireOnFailure(session);
        }
    }

    @Override
    public void connectTcp(JaxmppCore jaxmpp, ConnectionSession session) throws JaxmppException {
        session.setData("jaxmpp", (Object)jaxmpp);
        List transports = (List)session.getData(TRANSPORTS_KEY);
        if (transports != null) {
            boolean established = false;
            for (Transport transport : transports) {
                if (!XMLNS.equals(transport.getXMLNS())) continue;
                List candidates = transport.getCandidates();
                for (Candidate candidate : candidates) {
                    try {
                        session.setData(TRANSPORT_USED_KEY, (Object)transport);
                        session.setData(CANDIDATE_USED_KEY, (Object)candidate);
                        this.connectToProxy(jaxmpp, session, transport.getSid(), (ConnectionEndpoint)candidate);
                        established = true;
                        break;
                    }
                    catch (IOException ex) {
                        session.removeData(TRANSPORT_USED_KEY);
                        session.removeData(CANDIDATE_USED_KEY);
                        log.log(Level.FINER, "exception connection to candidate, trying next one", ex);
                    }
                }
                if (!established) continue;
                break;
            }
        }
    }

    @Override
    public void connectUdp(JaxmppCore jaxmpp, ConnectionSession session) throws JaxmppException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transport getTransport(JaxmppCore jaxmpp, ConnectionSession session) throws JaxmppException {
        session.setData("jaxmpp", (Object)jaxmpp);
        String sid = UUID.randomUUID().toString();
        Transport transport = new Transport(XMLNS, sid, Transport.Mode.tcp);
        List<Streamhost> streamhosts = this.getLocalStreamHosts(session, sid);
        if (streamhosts == null) {
            return null;
        }
        int priority = streamhosts.size();
        for (Streamhost host : streamhosts) {
            String cid = UUID.randomUUID().toString();
            JID jid = host.getJid();
            transport.addCandidate(new Candidate(cid, host.getHost(), host.getPort(), jid, Integer.valueOf(priority), ResourceBinderModule.getBindedJID((SessionObject)session.getSessionObject()).equals((Object)jid) ? Candidate.Type.direct : Candidate.Type.proxy));
        }
        session.setData(SOCKS5_TRANSPORT_KEY, (Object)transport);
        return transport;
    }

    @Override
    public void initConnection(JaxmppCore jaxmpp, ConnectionSession session, ConnectionManager.InitializedCallback callback) throws JaxmppException {
        session.setData("jaxmpp", (Object)jaxmpp);
        JingleModule.JingleTransportInfoHandler handler = (JingleModule.JingleTransportInfoHandler)jaxmpp.getSessionObject().getUserProperty("urn:xmpp:jingle:transports:s5b:1#JingleTransportInfo");
        if (handler == null) {
            handler = new JingleModule.JingleTransportInfoHandler(){

                public void onJingleTransportInfo(SessionObject sessionObject, JID sender, String sid, Element content, MutableBoolean handled) throws JaxmppException {
                    if (content == null) {
                        return;
                    }
                    Element transport = content.getChildrenNS("transport", JingleSocks5BytestreamsConnectionManager.XMLNS);
                    if (transport == null) {
                        return;
                    }
                    handled.setValue(true);
                    String transportSid = transport.getAttribute("sid");
                    List candidatesUsed = transport.getChildren(JingleSocks5BytestreamsConnectionManager.CANDIDATE_USED_KEY);
                    if (candidatesUsed != null && !candidatesUsed.isEmpty()) {
                        Element candidateUsed = (Element)candidatesUsed.get(0);
                        JingleSocks5BytestreamsConnectionManager.this.candidateUsedReceived(sender, sid, transportSid, candidateUsed.getAttribute("cid"));
                    }
                }
            };
            jaxmpp.getEventBus().addHandler(JingleModule.JingleTransportInfoHandler.JingleTransportInfoEvent.class, (EventHandler)handler);
            jaxmpp.getSessionObject().setUserProperty("urn:xmpp:jingle:transports:s5b:1#JingleTransportInfo", (Object)handler);
        }
        if (callback != null) {
            callback.initialized(jaxmpp, session);
        }
    }

    private void sendCandidateUsed(ConnectionSession session) throws JaxmppException {
        JaxmppCore jaxmpp = (JaxmppCore)session.getData("jaxmpp");
        Transport transport = (Transport)session.getData(TRANSPORT_USED_KEY);
        Candidate candidateUsed = (Candidate)session.getData(CANDIDATE_USED_KEY);
        JingleModule jingleModule = (JingleModule)jaxmpp.getModule(JingleModule.class);
        Element candidateUsedEl = ElementFactory.create((String)CANDIDATE_USED_KEY);
        candidateUsedEl.setAttribute("cid", candidateUsed.getCid());
        Element transportEl = ElementFactory.create((String)"transport");
        transportEl.setAttribute("sid", transport.getSid());
        transportEl.setXMLNS(XMLNS);
        transportEl.addChild(candidateUsedEl);
        Element contentEl = ElementFactory.create((String)"content");
        contentEl.setAttribute("initiator", "creator");
        contentEl.setAttribute("name", "ex");
        contentEl.addChild(transportEl);
        jingleModule.transportInfo(session.getPeer(), ResourceBinderModule.getBindedJID((SessionObject)jaxmpp.getSessionObject()), session.getSid(), contentEl);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        context.getEventBus().addHandler(ConnectionManager.ConnectionEstablishedHandler.ConnectionEstablishedEvent.class, (Object)this, (EventHandler)this.connectionEstablishedHandler);
    }
}

