/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.Processor;
import tigase.jaxmpp.core.client.ResponseManager;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.connector.ConnectorWrapper;
import tigase.jaxmpp.core.client.connector.StreamError;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.auth.SaslMechanism;
import tigase.jaxmpp.core.client.xmpp.modules.auth.SaslModule;
import tigase.jaxmpp.core.client.xmpp.modules.streammng.StreamManagementModule;
import tigase.jaxmpp.core.client.xmpp.utils.DateTimeFormat;
import tigase.jaxmpp.j2se.ConnectionConfiguration;
import tigase.jaxmpp.j2se.DateTimeFormatProviderImpl;
import tigase.jaxmpp.j2se.J2SESessionObject;
import tigase.jaxmpp.j2se.ThreadSafeResponseManager;
import tigase.jaxmpp.j2se.connectors.bosh.BoshConnector;
import tigase.jaxmpp.j2se.connectors.socket.SocketConnector;
import tigase.jaxmpp.j2se.connectors.websocket.WebSocketConnector;
import tigase.jaxmpp.j2se.eventbus.ThreadSafeEventBus;
import tigase.jaxmpp.j2se.xmpp.modules.auth.saslmechanisms.ExternalMechanism;

public class Jaxmpp
extends JaxmppCore {
    public static final String CONNECTOR_TYPE = "connectorType";
    public static final String EXCEPTION_KEY = "jaxmpp#ThrowedException";
    public static final String LOGIN_TIMEOUT_KEY = "LOGIN_TIMEOUT_KEY";
    public static final String SYNCHRONIZED_MODE = "jaxmpp#synchronized";
    private static final Executor DEFAULT_EXECUTOR = new Executor(){

        @Override
        public synchronized void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    private final ConnectorWrapper connectorWrapper = new ConnectorWrapper();
    private Executor executor;
    private TimerTask loginTimeoutTask;
    private Timer timer = null;

    public Jaxmpp() {
        this.eventBus = new ThreadSafeEventBus();
        this.sessionObject = new J2SESessionObject();
        this.init();
    }

    public Jaxmpp(SessionObject sessionObject) {
        this.eventBus = new ThreadSafeEventBus();
        this.sessionObject = sessionObject;
        this.init();
    }

    protected void checkTimeouts() throws JaxmppException {
        ResponseManager.getResponseManager((SessionObject)this.sessionObject).checkTimeouts();
    }

    protected Connector createConnector() throws JaxmppException {
        if (this.sessionObject.getProperty(CONNECTOR_TYPE) == null || "socket".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using SocketConnector");
            return new SocketConnector(this.context);
        }
        if ("bosh".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using BOSHConnector");
            return new BoshConnector(this.context);
        }
        if ("websocket".equals(this.sessionObject.getProperty(CONNECTOR_TYPE))) {
            this.log.info("Using WebSocketConnector");
            return new WebSocketConnector(this.context);
        }
        throw new JaxmppException("Unknown connector type");
    }

    public void disconnect() throws JaxmppException {
        this.disconnect(false);
    }

    public void disconnect(boolean snc) throws JaxmppException {
        this.disconnect(snc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disconnect(boolean snc, boolean resetStreamManagement) throws JaxmppException {
        try {
            if (this.connector != null) {
                Boolean sync = (Boolean)this.sessionObject.getProperty(SYNCHRONIZED_MODE);
                sync = snc || sync != null && sync != false;
                Connector.DisconnectedHandler handler = null;
                if (sync.booleanValue()) {
                    handler = new Connector.DisconnectedHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onDisconnected(SessionObject sessionObject) {
                            Jaxmpp jaxmpp = Jaxmpp.this;
                            synchronized (jaxmpp) {
                                ((Object)((Object)Jaxmpp.this)).notifyAll();
                            }
                        }
                    };
                    this.eventBus.addHandler(Connector.DisconnectedHandler.DisconnectedEvent.class, (EventHandler)handler);
                }
                try {
                    this.connector.stop();
                }
                catch (XMLException e) {
                    throw new JaxmppException((Throwable)e);
                }
                if (sync.booleanValue()) {
                    Jaxmpp jaxmpp = this;
                    synchronized (jaxmpp) {
                        if (this.getConnector().getState() != Connector.State.disconnected) {
                            ((Object)((Object)this)).wait();
                        }
                    }
                    this.eventBus.remove(Connector.DisconnectedHandler.DisconnectedEvent.class, (EventHandler)handler);
                }
            }
            if (!resetStreamManagement) return;
        }
        catch (InterruptedException e) {
            try {
                throw new JaxmppException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!resetStreamManagement) throw throwable;
                StreamManagementModule.reset((SessionObject)this.sessionObject);
                this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.session});
                throw throwable;
            }
        }
        StreamManagementModule.reset((SessionObject)this.sessionObject);
        this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.session});
        return;
    }

    public void execute(Runnable runnable) {
        if (runnable != null) {
            this.executor.execute(runnable);
        }
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return new ConnectionConfiguration(this.sessionObject);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
    }

    protected void init() {
        if (ResponseManager.getResponseManager((SessionObject)this.sessionObject) == null) {
            ResponseManager.setResponseManager((SessionObject)this.sessionObject, (ResponseManager)new ThreadSafeResponseManager());
        }
        super.init();
        this.setExecutor(DEFAULT_EXECUTOR);
        this.connector = this.connectorWrapper;
        this.processor = new Processor(this.modulesManager, this.context);
        this.modulesInit();
    }

    public void login() throws JaxmppException {
        this.login(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(boolean sync) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new CheckTimeoutsTask(), 30000L, 30000L);
        }
        this.modulesManager.initIfRequired();
        Connector.State state = (Connector.State)this.sessionObject.getProperty("CONNECTOR#STAGE_KEY");
        if (state != null && state != Connector.State.disconnected) {
            this.log.info("Cannot login, because Connector.State is " + state);
            throw new JaxmppException("Connector is not in disconnected state");
        }
        this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.stream});
        if (this.sessionLogic != null) {
            this.sessionLogic.unbind();
            this.sessionLogic = null;
        }
        ConnectorWrapper connectorWrapper = this.connectorWrapper;
        synchronized (connectorWrapper) {
            if (this.connectorWrapper.getConnector() != null) {
                this.log.info("Found previous instance of Connector. Killing!");
                try {
                    this.connectorWrapper.stop(true);
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Something goes wrong during killing previous connector!", e);
                }
                this.connectorWrapper.setConnector(null);
            }
            this.connectorWrapper.setConnector(this.createConnector());
        }
        this.sessionLogic = this.connector.createSessionLogic(this.modulesManager, this.writer);
        this.sessionLogic.setSessionListener(new XmppSessionLogic.SessionListener(){

            public void onException(JaxmppException e) throws JaxmppException {
                Jaxmpp.this.onException(e);
            }
        });
        try {
            Object e;
            this.sessionLogic.beforeStart();
            this.connector.start();
            this.sessionObject.setProperty(SYNCHRONIZED_MODE, (Object)sync);
            if (sync) {
                this.loginTimeoutTask = new LoginTimeoutTask();
                Long delay = (Long)this.sessionObject.getProperty(LOGIN_TIMEOUT_KEY);
                this.log.finest("Starting LoginTimeoutTask");
                this.timer.schedule(this.loginTimeoutTask, delay == null ? 300000L : delay);
                e = this;
                synchronized (e) {
                    ((Object)((Object)this)).wait();
                    this.log.finest("Waked up");
                    ((Object)((Object)this)).wait(512L);
                }
                if (this.loginTimeoutTask != null) {
                    this.log.finest("Canceling LoginTimeoutTask");
                    this.loginTimeoutTask.cancel();
                    this.loginTimeoutTask = null;
                }
            }
            if (this.sessionObject.getProperty(EXCEPTION_KEY) != null) {
                JaxmppException r = (JaxmppException)((Object)this.sessionObject.getProperty(EXCEPTION_KEY));
                e = new JaxmppException(r.getMessage(), r.getCause());
                throw r;
            }
        }
        catch (JaxmppException e) {
            throw e;
        }
        catch (Exception e1) {
            JaxmppException e = new JaxmppException((Throwable)e1);
            throw e;
        }
    }

    protected void modulesInit() {
        super.modulesInit();
        SaslModule saslModule = (SaslModule)this.modulesManager.getModule(SaslModule.class);
        saslModule.addMechanism((SaslMechanism)new ExternalMechanism(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectorStopped() {
        super.onConnectorStopped();
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(JaxmppException e) throws JaxmppException {
        this.log.log(Level.FINE, "Catching exception", e);
        this.sessionObject.setProperty(EXCEPTION_KEY, (Object)e);
        try {
            this.connector.stop();
        }
        catch (Exception e1) {
            this.log.log(Level.FINE, "Disconnecting error", e1);
        }
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResourceBindSuccess(JID bindedJID) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
        }
        this.eventBus.fire((Event)new JaxmppCore.LoggedInHandler.LoggedInEvent(this.sessionObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStreamError(StreamError condition, Throwable caught) throws JaxmppException {
        if (this.sessionObject.getProperty("s:reconnecting") != Boolean.TRUE) {
            Jaxmpp jaxmpp = this;
            synchronized (jaxmpp) {
                ((Object)((Object)this)).notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStreamResumed(Long h, String previd) throws JaxmppException {
        Jaxmpp jaxmpp = this;
        synchronized (jaxmpp) {
            ((Object)((Object)this)).notify();
        }
        this.eventBus.fire((Event)new JaxmppCore.LoggedInHandler.LoggedInEvent(this.sessionObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStreamTerminated() throws JaxmppException {
        if (this.sessionObject.getProperty("s:reconnecting") == null || !((Boolean)this.sessionObject.getProperty("s:reconnecting")).booleanValue()) {
            Jaxmpp jaxmpp = this;
            synchronized (jaxmpp) {
                ((Object)((Object)this)).notify();
            }
        }
    }

    static {
        DateTimeFormat.setProvider((DateTimeFormat.DateTimeFormatProvider)new DateTimeFormatProviderImpl());
    }

    private class LoginTimeoutTask
    extends TimerTask {
        private LoginTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Jaxmpp jaxmpp = Jaxmpp.this;
            synchronized (jaxmpp) {
                ((Object)((Object)Jaxmpp.this)).notify();
            }
        }
    }

    private class CheckTimeoutsTask
    extends TimerTask {
        private CheckTimeoutsTask() {
        }

        @Override
        public void run() {
            try {
                Jaxmpp.this.checkTimeouts();
            }
            catch (JaxmppException e) {
                Jaxmpp.this.log.warning("Problem on checking timeouts");
            }
        }
    }
}

