/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.connector.StreamError;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.JaxmppEvent;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.factory.UniversalFactory;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.StreamFeaturesModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.core.client.xmpp.stanzas.StreamPacket;
import tigase.jaxmpp.core.client.xmpp.stream.XMPPStream;
import tigase.jaxmpp.j2se.DNSResolver;
import tigase.jaxmpp.j2se.connectors.socket.DefaultHostnameVerifier;
import tigase.jaxmpp.j2se.connectors.socket.OutputStreamFlushWrap;
import tigase.jaxmpp.j2se.connectors.socket.Reader;
import tigase.jaxmpp.j2se.connectors.socket.SocketInBandRegistrationXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.SocketXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.TextStreamReader;
import tigase.jaxmpp.j2se.connectors.socket.Worker;

public class SocketConnector
implements Connector {
    public static final String COMPRESSION_DISABLED_KEY = "COMPRESSION_DISABLED";
    public static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 2048;
    public static final String HOSTNAME_VERIFIER_DISABLED_KEY = "HOSTNAME_VERIFIER_DISABLED_KEY";
    public static final String HOSTNAME_VERIFIER_KEY = "HOSTNAME_VERIFIER_KEY";
    public static final String KEY_MANAGERS_KEY = "KEY_MANAGERS_KEY";
    public static final String SASL_EXTERNAL_ENABLED_KEY = "SASL_EXTERNAL_ENABLED_KEY";
    public static final String SERVER_HOST = "socket#ServerHost";
    public static final String SERVER_PORT = "socket#ServerPort";
    public static final int SOCKET_TIMEOUT = 180000;
    public static final String SSL_SOCKET_FACTORY_KEY = "socket#SSLSocketFactory";
    public static final String TLS_DISABLED_KEY = "TLS_DISABLED";
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final byte[] EMPTY_BYTEARRAY = new byte[0];
    private final Object ioMutex = new Object();
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Context context;
    private TimerTask pingTask;
    private volatile Reader reader;
    private Socket socket;
    private Timer timer;
    private Worker worker;
    private OutputStream writer;
    private Timer closeTimer;

    public SocketConnector(Context context) {
        this.context = context;
    }

    public static boolean isTLSAvailable(SessionObject sessionObject) throws XMLException {
        Element sf = StreamFeaturesModule.getStreamFeatures((SessionObject)sessionObject);
        if (sf == null) {
            return false;
        }
        Element m = sf.getChildrenNS("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        return m != null;
    }

    public static boolean isZLibAvailable(SessionObject sessionObject) throws XMLException {
        Element sf = StreamFeaturesModule.getStreamFeatures((SessionObject)sessionObject);
        if (sf == null) {
            return false;
        }
        Element m = sf.getChildrenNS("compression", "http://jabber.org/features/compress");
        if (m == null) {
            return false;
        }
        for (Element method : m.getChildren("method")) {
            if (!"zlib".equals(method.getValue())) continue;
            return true;
        }
        return false;
    }

    private void closeSocket() {
        if (this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.log.log(Level.FINEST, "Problem with closing socket (oid=" + this.hashCode() + ")", ex);
            }
        }
    }

    public XmppSessionLogic createSessionLogic(XmppModulesManager modulesManager, PacketWriter writer) {
        if (this.context.getSessionObject().getProperty("IN_BAND_REGISTRATION_MODE_KEY") == Boolean.TRUE) {
            this.log.info("Using XEP-0077 mode!!!!");
            return new SocketInBandRegistrationXmppSessionLogic(this, modulesManager, this.context);
        }
        return new SocketXmppSessionLogic(this, modulesManager, this.context);
    }

    protected void fireOnConnected(SessionObject sessionObject) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.context.getEventBus().fire((Event)new Connector.ConnectedHandler.ConnectedEvent(sessionObject));
    }

    protected void fireOnError(Element response, Throwable caught, SessionObject sessionObject) throws JaxmppException {
        Iterator iterator;
        List es;
        StreamError streamError = null;
        if (response != null && (es = response.getChildrenNS("urn:ietf:params:xml:ns:xmpp-streams")) != null && (iterator = es.iterator()).hasNext()) {
            Element element = (Element)iterator.next();
            String n = element.getName();
            streamError = StreamError.getByElementName((String)n);
        }
        this.context.getEventBus().fire((Event)new Connector.ErrorHandler.ErrorEvent(sessionObject, streamError, caught));
    }

    protected void fireOnStanzaReceived(StreamPacket response, SessionObject sessionObject) throws JaxmppException {
        this.context.getEventBus().fire((Event)new Connector.StanzaReceivedHandler.StanzaReceivedEvent(sessionObject, response));
    }

    protected void fireOnTerminate(SessionObject sessionObject) throws JaxmppException {
        this.context.getEventBus().fire((Event)new Connector.StreamTerminatedHandler.StreamTerminatedEvent(sessionObject));
    }

    private Entry getHostFromSessionObject() {
        String serverHost = (String)this.context.getSessionObject().getProperty(SERVER_HOST);
        Integer port = (Integer)this.context.getSessionObject().getProperty(SERVER_PORT);
        if (serverHost == null) {
            return null;
        }
        return new Entry(serverHost, port == null ? 5222 : port);
    }

    protected KeyManager[] getKeyManagers() throws NoSuchAlgorithmException {
        KeyManager[] result = (KeyManager[])this.context.getSessionObject().getProperty(KEY_MANAGERS_KEY);
        return result == null ? new KeyManager[]{} : result;
    }

    public Connector.State getState() {
        if (this.context == null) {
            return Connector.State.disconnected;
        }
        Connector.State st = (Connector.State)this.context.getSessionObject().getProperty("CONNECTOR#STAGE_KEY");
        return st == null ? Connector.State.disconnected : st;
    }

    public boolean isCompressed() {
        return this.context.getSessionObject().getProperty("CONNECTOR#COMPRESSED_KEY") == Boolean.TRUE;
    }

    public boolean isSecure() {
        return this.context.getSessionObject().getProperty("CONNECTOR#ENCRYPTED_KEY") == Boolean.TRUE;
    }

    public void keepalive() throws JaxmppException {
        if (this.context.getSessionObject().getProperty("CONNECTOR#DISABLEKEEPALIVE") == Boolean.TRUE) {
            return;
        }
        if (this.getState() == Connector.State.connected) {
            this.send(new byte[]{32});
        }
    }

    protected void onError(Element response, Throwable caught) throws JaxmppException {
        Element seeOtherHost;
        if (response != null && (seeOtherHost = response.getChildrenNS("see-other-host", "urn:ietf:params:xml:ns:xmpp-streams")) != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Received see-other-host=" + seeOtherHost.getValue());
            }
            this.reconnect(seeOtherHost.getValue());
            return;
        }
        this.terminateAllWorkers();
        this.fireOnError(response, caught, this.context.getSessionObject());
    }

    protected void onErrorInThread(Exception e) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.terminateAllWorkers();
        this.fireOnError(null, e, this.context.getSessionObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResponse(Element response) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if ("error".equals(response.getName()) && response.getXMLNS() != null && response.getXMLNS().equals("http://etherx.jabber.org/streams")) {
                this.onError(response, null);
            } else {
                Object p = Stanza.canBeConverted((Element)response) ? Stanza.create((Element)response) : new StreamPacket(response){};
                p.setXmppStream((XMPPStream)this.context.getStreamsManager().getDefaultStream());
                this.fireOnStanzaReceived((StreamPacket)p, this.context.getSessionObject());
            }
        }
    }

    protected void onStreamStart(Map<String, String> attribs) {
    }

    protected void onStreamTerminate() throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnected);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Stream terminated");
        }
        this.terminateAllWorkers();
        this.fireOnTerminate(this.context.getSessionObject());
    }

    public void onTLSStanza(Element elem) throws JaxmppException {
        if (elem.getName().equals("proceed")) {
            this.proceedTLS();
        } else if (elem.getName().equals("failure")) {
            this.log.info("TLS Failure");
        }
    }

    public void onZLibStanza(Element elem) throws JaxmppException {
        if (elem.getName().equals("compressed") && "http://jabber.org/protocol/compress".equals(elem.getXMLNS())) {
            this.proceedZLib();
        } else if (elem.getName().equals("failure")) {
            this.log.info("ZLIB Failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedTLS() throws JaxmppException {
        this.log.fine("Proceeding TLS");
        try {
            SSLSocketFactory factory;
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            TrustManager[] trustManagers = (TrustManager[])this.context.getSessionObject().getProperty("TRUST_MANAGERS_KEY");
            if (trustManagers == null) {
                factory = this.context.getSessionObject().getProperty(SSL_SOCKET_FACTORY_KEY) != null ? (SSLSocketFactory)this.context.getSessionObject().getProperty(SSL_SOCKET_FACTORY_KEY) : (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(this.getKeyManagers(), trustManagers, new SecureRandom());
                factory = ctx.getSocketFactory();
            }
            SSLSocket s1 = (SSLSocket)factory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
            s1.setSoTimeout(0);
            s1.setKeepAlive(false);
            s1.setTcpNoDelay(true);
            s1.setUseClientMode(true);
            s1.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent arg0) {
                    SocketConnector.this.log.info("TLS completed " + arg0);
                    SocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#ENCRYPTED_KEY", (Object)Boolean.TRUE);
                    SocketConnector.this.context.getEventBus().fire((Event)new Connector.EncryptionEstablishedHandler.EncryptionEstablishedEvent(SocketConnector.this.context.getSessionObject()));
                }
            });
            this.writer = null;
            this.reader = null;
            this.log.fine("Start handshake");
            String hostname = this.context.getSessionObject().getProperty("userBareJid") != null ? ((BareJID)this.context.getSessionObject().getProperty("userBareJid")).getDomain() : (this.context.getSessionObject().getProperty("domainName") != null ? (String)this.context.getSessionObject().getProperty("domainName") : null);
            s1.startHandshake();
            HostnameVerifier hnv = (HostnameVerifier)this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_KEY);
            if (hnv != null && !hnv.verify(hostname, s1.getSession())) {
                throw new SSLHandshakeException("Cerificate hostname doesn't match domain name you want to connect.");
            }
            this.socket = s1;
            this.writer = this.socket.getOutputStream();
            this.reader = new TextStreamReader(this.socket.getInputStream());
            this.restartStream();
        }
        catch (SSLHandshakeException e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        finally {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedZLib() throws JaxmppException {
        this.log.fine("Proceeding ZLIB");
        try {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            this.writer = null;
            this.reader = null;
            this.log.fine("Start ZLIB compression");
            Deflater compressor = new Deflater(9, false);
            try {
                Field f = compressor.getClass().getDeclaredField("flushParm");
                if (f != null) {
                    f.setAccessible(true);
                    f.setInt(compressor, 2);
                    this.writer = new DeflaterOutputStream(this.socket.getOutputStream(), compressor);
                }
            }
            catch (NoSuchFieldException ex) {
                try {
                    Constructor flushable = DeflaterOutputStream.class.getConstructor(OutputStream.class, Deflater.class, Boolean.TYPE);
                    this.writer = new OutputStreamFlushWrap((OutputStream)flushable.newInstance(this.socket.getOutputStream(), compressor, true));
                }
                catch (NoSuchMethodException ex1) {
                    this.writer = new DeflaterOutputStream(this.socket.getOutputStream(), compressor){

                        @Override
                        public void write(byte[] data) throws IOException {
                            super.write(data);
                            super.write(EMPTY_BYTEARRAY);
                            this.def.setLevel(0);
                            super.deflate();
                            this.def.setLevel(9);
                            super.deflate();
                        }
                    };
                }
            }
            Inflater decompressor = new Inflater(false);
            InflaterInputStream is = new InflaterInputStream(this.socket.getInputStream(), decompressor);
            this.reader = new TextStreamReader(is);
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#COMPRESSED_KEY", (Object)true);
            this.log.info("ZLIB compression started");
            this.restartStream();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish compressed connection", e);
            this.onError(null, e);
        }
        finally {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    public void processElement(Element elem) throws JaxmppException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Recv (oid=" + this.hashCode() + "): " + elem.getAsString());
        }
        if (elem != null && elem.getXMLNS() != null && elem.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-tls")) {
            this.onTLSStanza(elem);
        } else if (elem != null && elem.getXMLNS() != null && "http://jabber.org/protocol/compress".equals(elem.getXMLNS())) {
            this.onZLibStanza(elem);
        } else {
            this.onResponse(elem);
        }
    }

    private void reconnect(String newHost) {
        this.log.info("See other host: " + newHost);
        try {
            this.context.getSessionObject().setProperty("s:reconnecting", (Object)Boolean.TRUE);
            this.terminateAllWorkers();
            Object x1 = this.context.getSessionObject().getProperty("jaxmpp#synchronized");
            this.context.getSessionObject().clear(new SessionObject.Scope[]{SessionObject.Scope.stream});
            this.context.getSessionObject().setProperty(SERVER_HOST, (Object)newHost);
            this.worker = null;
            this.reader = null;
            this.writer = null;
            this.context.getSessionObject().setProperty("s:reconnecting", (Object)Boolean.TRUE);
            this.context.getSessionObject().setProperty("jaxmpp#synchronized", x1);
            this.log.finest("Waiting for workers termination");
        }
        catch (JaxmppException e) {
            this.log.log(Level.WARNING, "Error on recconnect", e);
        }
    }

    public void restartStream() throws JaxmppException {
        String to;
        StringBuilder sb = new StringBuilder();
        sb.append("<stream:stream ");
        BareJID from = (BareJID)this.context.getSessionObject().getProperty("userBareJid");
        Boolean seeOtherHost = (Boolean)this.context.getSessionObject().getProperty("BOSH#SEE_OTHER_HOST_KEY");
        if (from != null && (seeOtherHost == null || seeOtherHost.booleanValue())) {
            to = from.getDomain();
            sb.append("from='").append(from.toString()).append("' ");
        } else {
            to = (String)this.context.getSessionObject().getProperty("domainName");
        }
        if (to != null) {
            sb.append("to='").append(to).append("' ");
        }
        sb.append("xmlns='jabber:client' ");
        sb.append("xmlns:stream='http://etherx.jabber.org/streams' ");
        sb.append("version='1.0'>");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Restarting XMPP Stream");
        }
        this.send(sb.toString().getBytes(UTF_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] buffer) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Send (oid=" + this.hashCode() + "): " + new String(buffer));
                    }
                    this.writer.write(buffer);
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new JaxmppException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Element stanza) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    String t = stanza.getAsString();
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Send (oid=" + this.hashCode() + "): " + t);
                    }
                    try {
                        this.context.getEventBus().fire((Event)new Connector.StanzaSendingHandler.StanzaSendingEvent(this.context.getSessionObject(), stanza));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.writer.write(t.getBytes(UTF_CHARSET));
                }
                catch (IOException e) {
                    this.terminateAllWorkers();
                    throw new JaxmppException((Throwable)e);
                }
            }
        }
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException e) {
            this.log.warning("Thread can't sleep. Insomnia?");
        }
    }

    protected void setStage(Connector.State state) throws JaxmppException {
        Connector.State s = (Connector.State)this.context.getSessionObject().getProperty("CONNECTOR#STAGE_KEY");
        this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#STAGE_KEY", (Object)state);
        if (s != state) {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#CONNECTOR_STAGE_TIMESTAMP_KEY", (Object)new Date());
            this.log.fine("Connector (oid=" + this.hashCode() + ") state changed: " + s + "->" + state);
            this.context.getEventBus().fire((Event)new Connector.StateChangedHandler.StateChangedEvent(this.context.getSessionObject(), s, state));
            if (state == Connector.State.disconnected) {
                this.fireOnTerminate(this.context.getSessionObject());
            }
        }
    }

    public void start() throws JaxmppException {
        this.log.fine("Start connector (oid=" + this.hashCode() + ").");
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.timer = new Timer(true);
        if (this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_DISABLED_KEY) == Boolean.TRUE) {
            this.context.getSessionObject().setProperty(HOSTNAME_VERIFIER_KEY, null);
        } else if (this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_KEY) == null) {
            this.context.getSessionObject().setProperty(HOSTNAME_VERIFIER_KEY, (Object)DEFAULT_HOSTNAME_VERIFIER);
        }
        this.setStage(Connector.State.connecting);
        try {
            Object x;
            Entry serverHost = this.getHostFromSessionObject();
            if (serverHost == null) {
                x = (String)this.context.getSessionObject().getProperty("domainName");
                this.log.info("Resolving SRV recrd of domain '" + (String)x + "'");
                DnsResolver dnsResolver = (DnsResolver)UniversalFactory.createInstance((String)DnsResolver.class.getName());
                List<Entry> xx = dnsResolver != null ? dnsResolver.resolve((String)x) : DNSResolver.resolve((String)x);
                if (xx.size() > 0) {
                    serverHost = xx.get(0);
                }
            }
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Preparing connection to " + serverHost);
            }
            x = InetAddress.getByName(serverHost.getHostname());
            this.log.info("Opening connection to " + x + ":" + serverHost.getPort());
            if (this.context.getSessionObject().getProperty("PROXY_HOST_KEY") != null) {
                String proxyHost = (String)this.context.getSessionObject().getProperty("PROXY_HOST_KEY");
                int proxyPort = (Integer)this.context.getSessionObject().getProperty("PROXY_PORT_KEY");
                Proxy.Type proxyType = (Proxy.Type)((Object)this.context.getSessionObject().getProperty("PROXY_TYPE_KEY"));
                if (proxyType == null) {
                    proxyType = Proxy.Type.HTTP;
                }
                this.log.info("Using " + (Object)((Object)proxyType) + " proxy: " + proxyHost + ":" + proxyPort);
                InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(proxyType, addr);
                this.socket = new Socket(proxy);
            } else {
                this.socket = new Socket();
            }
            this.socket.setSoTimeout(180000);
            this.socket.setKeepAlive(false);
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress((InetAddress)x, (int)serverHost.getPort()));
            this.writer = this.socket.getOutputStream();
            this.reader = new TextStreamReader(this.socket.getInputStream());
            this.worker = new Worker(this){

                @Override
                protected Reader getReader() {
                    return SocketConnector.this.reader;
                }

                @Override
                protected void onErrorInThread(Exception e) throws JaxmppException {
                    SocketConnector.this.onErrorInThread(e);
                }

                @Override
                protected void onStreamStart(Map<String, String> attribs) {
                    SocketConnector.this.onStreamStart(attribs);
                }

                @Override
                protected void onStreamTerminate() throws JaxmppException {
                    SocketConnector.this.onStreamTerminate();
                }

                @Override
                protected void processElement(Element elem) throws JaxmppException {
                    SocketConnector.this.processElement(elem);
                }

                @Override
                protected void workerTerminated() {
                    SocketConnector.this.workerTerminated(this);
                }
            };
            this.log.finest("Starting worker...");
            this.worker.start();
            this.restartStream();
            this.setStage(Connector.State.connected);
            this.pingTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                SocketConnector.this.keepalive();
                            }
                            catch (JaxmppException e) {
                                SocketConnector.this.log.log(Level.SEVERE, "Can't ping!", e);
                            }
                        }
                    }.start();
                }
            };
            long delay = 175000L;
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Whitespace ping period is setted to " + delay + "ms");
            }
            if (this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY") == null || !((Boolean)this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY")).booleanValue()) {
                this.timer.schedule(this.pingTask, delay, delay);
            }
            this.fireOnConnected(this.context.getSessionObject());
        }
        catch (Exception e) {
            this.terminateAllWorkers();
            this.onError(null, e);
            throw new JaxmppException((Throwable)e);
        }
    }

    public void startTLS() throws JaxmppException {
        if (this.writer != null) {
            try {
                this.log.fine("Start TLS (oid=" + this.hashCode() + ")");
                Element e = ElementFactory.create((String)"starttls", null, (String)"urn:ietf:params:xml:ns:xmpp-tls");
                this.send(e.getAsString().getBytes(UTF_CHARSET));
            }
            catch (Exception e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void startZLib() throws JaxmppException {
        if (this.writer != null) {
            try {
                this.log.fine("Start ZLIB (oid=" + this.hashCode() + ")");
                Element e = ElementFactory.create((String)"compress", null, (String)"http://jabber.org/protocol/compress");
                e.addChild(ElementFactory.create((String)"method", (String)"zlib", null));
                this.send(e.getAsString().getBytes(UTF_CHARSET));
            }
            catch (Exception e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void stop() throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnecting);
        try {
            this.terminateStream();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on terminating stream", e);
            this.setStage(Connector.State.disconnected);
        }
        finally {
            this.terminateAllWorkers();
        }
    }

    @Deprecated
    public void stop(boolean terminate) throws JaxmppException {
        if (terminate) {
            this.log.finest("Terminating all workers immediatelly (oid=" + this.hashCode() + ")");
            try {
                if (this.pingTask != null) {
                    this.pingTask.cancel();
                    this.pingTask = null;
                }
                this.closeSocket();
            }
            finally {
                this.setStage(Connector.State.disconnected);
                this.context = null;
            }
        } else {
            this.stop();
        }
    }

    private void terminateAllWorkers() throws JaxmppException {
        this.log.finest("Terminating all workers (oid=" + this.hashCode() + ")");
        if (this.pingTask != null) {
            this.pingTask.cancel();
            this.pingTask = null;
        }
        if (this.socket != null && this.socket.isConnected()) {
            if (this.closeTimer != null) {
                this.closeTimer.cancel();
            }
            this.closeTimer = new Timer();
            this.closeTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        SocketConnector.this.setStage(Connector.State.disconnected);
                    }
                    catch (JaxmppException jaxmppException) {
                        // empty catch block
                    }
                    SocketConnector.this.context = null;
                    SocketConnector.this.closeSocket();
                    SocketConnector.this.closeTimer.cancel();
                    SocketConnector.this.closeTimer = null;
                }
            }, 3000L);
        } else {
            try {
                this.setStage(Connector.State.disconnected);
            }
            catch (JaxmppException e) {
                // empty catch block
            }
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with canceling timer", e);
        }
        finally {
            this.timer = null;
        }
    }

    private void terminateStream() throws JaxmppException {
        Connector.State state = this.getState();
        if (state == Connector.State.connected || state == Connector.State.connecting || state == Connector.State.disconnecting) {
            String x = "</stream:stream>";
            this.log.fine("Terminating XMPP Stream");
            this.send(x.getBytes(UTF_CHARSET));
            System.out.println(x);
        } else {
            this.log.fine("Stream terminate not sent, because of connection state==" + state);
        }
    }

    private void workerTerminated(Worker worker) {
        try {
            if (this.closeTimer != null) {
                this.closeTimer.cancel();
                this.closeTimer = null;
            }
            this.setStage(Connector.State.disconnected);
        }
        catch (JaxmppException e) {
            // empty catch block
        }
        this.log.finest("Worker terminated");
        try {
            if (this.context.getSessionObject().getProperty("s:reconnecting") == Boolean.TRUE) {
                this.context.getSessionObject().setProperty("s:reconnecting", null);
                this.context.getEventBus().fire((Event)new HostChangedHandler.HostChangedEvent(this.context.getSessionObject()));
                this.log.finest("Restarting...");
                this.start();
            } else {
                this.context.getEventBus().fire((Event)new Connector.DisconnectedHandler.DisconnectedEvent(this.context.getSessionObject()));
            }
        }
        catch (Exception e) {
            this.log.warning("Problem : " + e.getMessage());
        }
    }

    public static final class Entry {
        private final String hostname;
        private final Integer port;

        public Entry(String host, Integer port) {
            this.hostname = host;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }
    }

    public static interface HostChangedHandler
    extends EventHandler {
        public void onHostChanged(SessionObject var1);

        public static class HostChangedEvent
        extends JaxmppEvent<HostChangedHandler> {
            public HostChangedEvent(SessionObject sessionObject) {
                super(sessionObject);
            }

            protected void dispatch(HostChangedHandler handler) {
                handler.onHostChanged(this.sessionObject);
            }
        }
    }

    public static interface DnsResolver {
        public List<Entry> resolve(String var1);
    }
}

