/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

public class NameTest
extends TestCase {
    public void test_init_from_name() throws TextParseException {
        Name n = new Name("A.B.c.d.");
        Name e = new Name("B.c.d.");
        Name o = new Name(n, 1);
        NameTest.assertEquals((Object)e, (Object)o);
    }

    public void test_init_from_name_root() throws TextParseException {
        Name n = new Name("A.B.c.d.");
        Name o = new Name(n, 4);
        NameTest.assertEquals((Object)Name.root, (Object)o);
    }

    public void test_init_from_name_empty() throws TextParseException {
        Name n = new Name("A.B.c.d.");
        Name n2 = new Name(n, 5);
        NameTest.assertFalse((boolean)n2.isAbsolute());
        NameTest.assertFalse((boolean)n2.isWild());
        NameTest.assertEquals((int)0, (int)n2.labels());
        NameTest.assertEquals((int)0, (int)n2.length());
    }

    public void test_concatenate_basic() throws NameTooLongException, TextParseException {
        Name p = Name.fromString("A.B");
        Name s = Name.fromString("c.d.");
        Name e = Name.fromString("A.B.c.d.");
        Name n = Name.concatenate(p, s);
        NameTest.assertEquals((Object)e, (Object)n);
    }

    public void test_concatenate_abs_prefix() throws NameTooLongException, TextParseException {
        Name p = Name.fromString("A.B.");
        Name s = Name.fromString("c.d.");
        Name e = Name.fromString("A.B.");
        Name n = Name.concatenate(p, s);
        NameTest.assertEquals((Object)e, (Object)n);
    }

    public void test_concatenate_too_long() throws TextParseException {
        Name p = Name.fromString("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
        Name s = Name.fromString("ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc.ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd.");
        try {
            Name.concatenate(p, s);
            NameTest.fail((String)"NameTooLongException not thrown");
        }
        catch (NameTooLongException nameTooLongException) {
            // empty catch block
        }
    }

    public void test_relativize() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name dom = Name.fromString("c.");
        Name exp = Name.fromString("a.b");
        Name n = sub.relativize(dom);
        NameTest.assertEquals((Object)exp, (Object)n);
    }

    public void test_relativize_null_origin() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name dom = null;
        Name n = sub.relativize(dom);
        NameTest.assertEquals((Object)sub, (Object)n);
    }

    public void test_relativize_disjoint() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name dom = Name.fromString("e.f.");
        Name n = sub.relativize(dom);
        NameTest.assertEquals((Object)sub, (Object)n);
    }

    public void test_relativize_root() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name dom = Name.fromString(".");
        Name exp = Name.fromString("a.b.c");
        Name n = sub.relativize(dom);
        NameTest.assertEquals((Object)exp, (Object)n);
    }

    public void test_wild() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name exp = Name.fromString("*.b.c.");
        Name n = sub.wild(1);
        NameTest.assertEquals((Object)exp, (Object)n);
    }

    public void test_wild_abs() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        Name exp = Name.fromString("*.");
        Name n = sub.wild(3);
        NameTest.assertEquals((Object)exp, (Object)n);
    }

    public void test_wild_toobig() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        try {
            sub.wild(4);
            NameTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_wild_toosmall() throws TextParseException {
        Name sub = Name.fromString("a.b.c.");
        try {
            sub.wild(0);
            NameTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_fromDNAME() throws NameTooLongException, TextParseException {
        Name own = new Name("the.owner.");
        Name alias = new Name("the.alias.");
        DNAMERecord dnr = new DNAMERecord(own, 1, 43981L, alias);
        Name sub = new Name("sub.the.owner.");
        Name exp = new Name("sub.the.alias.");
        Name n = sub.fromDNAME(dnr);
        NameTest.assertEquals((Object)exp, (Object)n);
    }

    public void test_fromDNAME_toobig() throws NameTooLongException, TextParseException {
        Name own = new Name("the.owner.");
        Name alias = new Name("the.aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc.");
        DNAMERecord dnr = new DNAMERecord(own, 1, 43981L, alias);
        Name sub = new Name("ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd.the.owner.");
        try {
            sub.fromDNAME(dnr);
            NameTest.fail((String)"NameTooLongException not thrown");
        }
        catch (NameTooLongException e) {
            // empty catch block
        }
    }

    public void test_fromDNAME_disjoint() throws NameTooLongException, TextParseException {
        Name own = new Name("the.owner.");
        Name alias = new Name("the.alias.");
        DNAMERecord dnr = new DNAMERecord(own, 1, 43981L, alias);
        Name sub = new Name("sub.the.other");
        NameTest.assertNull((Object)sub.fromDNAME(dnr));
    }

    public void test_subdomain_abs() throws TextParseException {
        Name dom = new Name("the.domain.");
        Name sub = new Name("sub.of.the.domain.");
        NameTest.assertTrue((boolean)sub.subdomain(dom));
        NameTest.assertFalse((boolean)dom.subdomain(sub));
    }

    public void test_subdomain_rel() throws TextParseException {
        Name dom = new Name("the.domain");
        Name sub = new Name("sub.of.the.domain");
        NameTest.assertTrue((boolean)sub.subdomain(dom));
        NameTest.assertFalse((boolean)dom.subdomain(sub));
    }

    public void test_subdomain_equal() throws TextParseException {
        Name dom = new Name("the.domain");
        Name sub = new Name("the.domain");
        NameTest.assertTrue((boolean)sub.subdomain(dom));
        NameTest.assertTrue((boolean)dom.subdomain(sub));
    }

    public void test_toString_abs() throws TextParseException {
        String in = "This.Is.My.Absolute.Name.";
        Name n = new Name(in);
        NameTest.assertEquals((String)in, (String)n.toString());
    }

    public void test_toString_rel() throws TextParseException {
        String in = "This.Is.My.Relative.Name";
        Name n = new Name(in);
        NameTest.assertEquals((String)in, (String)n.toString());
    }

    public void test_toString_at() throws TextParseException {
        Name n = new Name("@", null);
        NameTest.assertEquals((String)"@", (String)n.toString());
    }

    public void test_toString_root() throws TextParseException {
        NameTest.assertEquals((String)".", (String)Name.root.toString());
    }

    public void test_toString_wild() throws TextParseException {
        String in = "*.A.b.c.e";
        Name n = new Name(in);
        NameTest.assertEquals((String)in, (String)n.toString());
    }

    public void test_toString_escaped() throws TextParseException {
        String in = "my.escaped.junk\\128.label.";
        Name n = new Name(in);
        NameTest.assertEquals((String)in, (String)n.toString());
    }

    public void test_toString_special_char() throws TextParseException, WireParseException {
        byte[] raw = new byte[]{1, 34, 1, 40, 1, 41, 1, 46, 1, 59, 1, 92, 1, 64, 1, 36, 0};
        String exp = "\\\".\\(.\\).\\..\\;.\\\\.\\@.\\$.";
        Name n = new Name(new DNSInput(raw));
        NameTest.assertEquals((String)exp, (String)n.toString());
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_String_init.class);
        s.addTestSuite(Test_DNSInput_init.class);
        s.addTestSuite(NameTest.class);
        s.addTestSuite(Test_toWire.class);
        s.addTestSuite(Test_toWireCanonical.class);
        s.addTestSuite(Test_equals.class);
        s.addTestSuite(Test_compareTo.class);
        return s;
    }

    public static class Test_compareTo
    extends TestCase {
        public void test_notName() throws TextParseException {
            Name n = new Name("A.Name");
            try {
                n.compareTo(new Object());
                Test_compareTo.fail((String)"ClassCastException not thrown");
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void test_same() throws TextParseException {
            Name n = new Name("A.Name");
            Test_compareTo.assertEquals((int)0, (int)n.compareTo(n));
        }

        public void test_equal() throws TextParseException {
            Name n1 = new Name("A.Name.");
            Name n2 = new Name("a.name.");
            Test_compareTo.assertEquals((int)0, (int)n1.compareTo(n2));
            Test_compareTo.assertEquals((int)0, (int)n2.compareTo(n1));
        }

        public void test_close() throws TextParseException {
            Name n1 = new Name("a.name");
            Name n2 = new Name("a.name.");
            Test_compareTo.assertTrue((n1.compareTo(n2) > 0 ? 1 : 0) != 0);
            Test_compareTo.assertTrue((n2.compareTo(n1) < 0 ? 1 : 0) != 0);
        }

        public void test_disjoint() throws TextParseException {
            Name n1 = new Name("b");
            Name n2 = new Name("c");
            Test_compareTo.assertTrue((n1.compareTo(n2) < 0 ? 1 : 0) != 0);
            Test_compareTo.assertTrue((n2.compareTo(n1) > 0 ? 1 : 0) != 0);
        }

        public void test_label_prefix() throws TextParseException {
            Name n1 = new Name("thisIs.a.");
            Name n2 = new Name("thisIsGreater.a.");
            Test_compareTo.assertTrue((n1.compareTo(n2) < 0 ? 1 : 0) != 0);
            Test_compareTo.assertTrue((n2.compareTo(n1) > 0 ? 1 : 0) != 0);
        }

        public void test_more_labels() throws TextParseException {
            Name n1 = new Name("c.b.a.");
            Name n2 = new Name("d.c.b.a.");
            Test_compareTo.assertTrue((n1.compareTo(n2) < 0 ? 1 : 0) != 0);
            Test_compareTo.assertTrue((n2.compareTo(n1) > 0 ? 1 : 0) != 0);
        }
    }

    public static class Test_equals
    extends TestCase {
        public void test_same() throws TextParseException {
            Name n = new Name("A.Name.");
            Test_equals.assertTrue((boolean)n.equals(n));
        }

        public void test_null() throws TextParseException {
            Name n = new Name("A.Name.");
            Test_equals.assertFalse((boolean)n.equals(null));
        }

        public void test_notName() throws TextParseException {
            Name n = new Name("A.Name.");
            Test_equals.assertFalse((boolean)n.equals(new Object()));
        }

        public void test_abs() throws TextParseException {
            Name n = new Name("A.Name.");
            Name n2 = new Name("a.name.");
            Test_equals.assertTrue((boolean)n.equals(n2));
            Test_equals.assertTrue((boolean)n2.equals(n));
        }

        public void test_rel() throws TextParseException {
            Name n1 = new Name("A.Relative.Name");
            Name n2 = new Name("a.relative.name");
            Test_equals.assertTrue((boolean)n1.equals(n2));
            Test_equals.assertTrue((boolean)n2.equals(n1));
        }

        public void test_mixed() throws TextParseException {
            Name n1 = new Name("A.Name");
            Name n2 = new Name("a.name.");
            Test_equals.assertFalse((boolean)n1.equals(n2));
            Test_equals.assertFalse((boolean)n2.equals(n1));
        }

        public void test_weird() throws TextParseException {
            Name n1 = new Name("ab.c");
            Name n2 = new Name("abc.");
            Test_equals.assertFalse((boolean)n1.equals(n2));
            Test_equals.assertFalse((boolean)n2.equals(n1));
        }
    }

    public static class Test_toWireCanonical
    extends TestCase {
        public void test_basic() throws TextParseException {
            byte[] raw = new byte[]{1, 97, 5, 98, 97, 115, 105, 99, 4, 110, 97, 109, 101, 0};
            Name n = new Name("A.Basic.Name.");
            DNSOutput o = new DNSOutput();
            n.toWireCanonical(o);
            Test_toWireCanonical.assertTrue((boolean)Arrays.equals(raw, o.toByteArray()));
        }

        public void test_0arg() throws TextParseException {
            byte[] raw = new byte[]{1, 97, 5, 98, 97, 115, 105, 99, 4, 110, 97, 109, 101, 0};
            Name n = new Name("A.Basic.Name.");
            byte[] out = n.toWireCanonical();
            Test_toWireCanonical.assertTrue((boolean)Arrays.equals(raw, out));
        }

        public void test_root() {
            byte[] out = Name.root.toWireCanonical();
            Test_toWireCanonical.assertTrue((boolean)Arrays.equals(new byte[]{0}, out));
        }

        public void test_empty() throws TextParseException {
            Name n = new Name("@", null);
            byte[] out = n.toWireCanonical();
            Test_toWireCanonical.assertTrue((boolean)Arrays.equals(new byte[0], out));
        }

        public void test_3arg() throws TextParseException {
            Name d = new Name("Basic.Name.");
            Name n = new Name("A.Basic.Name.");
            Compression c = new Compression();
            c.add(257, d);
            byte[] exp = new byte[]{1, 97, 5, 98, 97, 115, 105, 99, 4, 110, 97, 109, 101, 0};
            DNSOutput o = new DNSOutput();
            n.toWire(o, c, true);
            Test_toWireCanonical.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
            Test_toWireCanonical.assertEquals((int)257, (int)c.get(d));
            Test_toWireCanonical.assertEquals((int)-1, (int)c.get(n));
        }
    }

    public static class Test_toWire
    extends TestCase {
        public void test_rel() throws TextParseException {
            Name n = new Name("A.Relative.Name");
            try {
                n.toWire(new DNSOutput(), null);
                Test_toWire.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_null_Compression() throws TextParseException {
            byte[] raw = new byte[]{1, 65, 5, 66, 97, 115, 105, 99, 4, 78, 97, 109, 101, 0};
            Name n = new Name("A.Basic.Name.");
            DNSOutput o = new DNSOutput();
            n.toWire(o, null);
            Test_toWire.assertTrue((boolean)Arrays.equals(raw, o.toByteArray()));
        }

        public void test_empty_Compression() throws TextParseException {
            byte[] raw = new byte[]{1, 65, 5, 66, 97, 115, 105, 99, 4, 78, 97, 109, 101, 0};
            Name n = new Name("A.Basic.Name.");
            Compression c = new Compression();
            DNSOutput o = new DNSOutput();
            n.toWire(o, c);
            Test_toWire.assertTrue((boolean)Arrays.equals(raw, o.toByteArray()));
            Test_toWire.assertEquals((int)0, (int)c.get(n));
        }

        public void test_with_exact_Compression() throws TextParseException {
            Name n = new Name("A.Basic.Name.");
            Compression c = new Compression();
            c.add(256, n);
            byte[] exp = new byte[]{-63, 0};
            DNSOutput o = new DNSOutput();
            n.toWire(o, c);
            Test_toWire.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
            Test_toWire.assertEquals((int)256, (int)c.get(n));
        }

        public void test_with_partial_Compression() throws TextParseException {
            Name d = new Name("Basic.Name.");
            Name n = new Name("A.Basic.Name.");
            Compression c = new Compression();
            c.add(257, d);
            byte[] exp = new byte[]{1, 65, -63, 1};
            DNSOutput o = new DNSOutput();
            n.toWire(o, c);
            Test_toWire.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
            Test_toWire.assertEquals((int)257, (int)c.get(d));
            Test_toWire.assertEquals((int)0, (int)c.get(n));
        }

        public void test_0arg_rel() throws TextParseException {
            Name n = new Name("A.Relative.Name");
            try {
                n.toWire();
                Test_toWire.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_0arg() throws TextParseException {
            byte[] raw = new byte[]{1, 65, 5, 66, 97, 115, 105, 99, 4, 78, 97, 109, 101, 0};
            Name n = new Name("A.Basic.Name.");
            byte[] out = n.toWire();
            Test_toWire.assertTrue((boolean)Arrays.equals(raw, out));
        }

        public void test_root() {
            byte[] out = Name.root.toWire();
            Test_toWire.assertTrue((boolean)Arrays.equals(new byte[]{0}, out));
        }

        public void test_3arg() throws TextParseException {
            Name d = new Name("Basic.Name.");
            Name n = new Name("A.Basic.Name.");
            Compression c = new Compression();
            c.add(257, d);
            byte[] exp = new byte[]{1, 65, -63, 1};
            DNSOutput o = new DNSOutput();
            n.toWire(o, c, false);
            Test_toWire.assertTrue((boolean)Arrays.equals(exp, o.toByteArray()));
            Test_toWire.assertEquals((int)257, (int)c.get(d));
            Test_toWire.assertEquals((int)0, (int)c.get(n));
        }
    }

    public static class Test_DNSInput_init
    extends TestCase {
        public void test_basic() throws IOException, TextParseException, WireParseException {
            byte[] raw = new byte[]{3, 87, 119, 119, 7, 68, 110, 115, 74, 97, 118, 97, 3, 111, 114, 103, 0};
            Name e = Name.fromString("Www.DnsJava.org.");
            Name n = new Name(raw);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_incomplete() throws IOException {
            try {
                new Name(new byte[]{3, 87, 119, 119});
                Test_DNSInput_init.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException wireParseException) {
                // empty catch block
            }
        }

        public void test_root() throws WireParseException {
            byte[] raw = new byte[]{0};
            Name n = new Name(new DNSInput(raw));
            Test_DNSInput_init.assertEquals((Object)Name.root, (Object)n);
        }

        public void test_invalid_length() throws IOException {
            try {
                new Name(new byte[]{4, 87, 119, 119});
                Test_DNSInput_init.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException wireParseException) {
                // empty catch block
            }
        }

        public void test_max_label_length() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{63, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 0};
            Name e = Name.fromString("bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.");
            Name n = new Name(new DNSInput(raw));
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_max_name() throws TextParseException, WireParseException {
            Name e = new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc.ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd.");
            byte[] raw = new byte[]{63, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 63, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 63, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 61, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 0};
            Name n = new Name(new DNSInput(raw));
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_toolong_name() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{63, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 63, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 63, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 62, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 0};
            try {
                new Name(new DNSInput(raw));
                Test_DNSInput_init.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException wireParseException) {
                // empty catch block
            }
        }

        public void test_max_labels() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 0};
            Name e = Name.fromString("a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.a.");
            Name n = new Name(new DNSInput(raw));
            Test_DNSInput_init.assertEquals((int)128, (int)n.labels());
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_toomany_labels() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 1, 97, 0};
            try {
                new Name(new DNSInput(raw));
                Test_DNSInput_init.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException wireParseException) {
                // empty catch block
            }
        }

        public void test_basic_compression() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{10, 3, 97, 98, 99, 0, -64, 1};
            Name e = Name.fromString("abc.");
            DNSInput in = new DNSInput(raw);
            in.jump(6);
            Options.set("verbosecompression");
            Name n = new Name(in);
            Options.unset("verbosecompression");
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_two_pointer_compression() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{10, 3, 97, 98, 99, 0, -64, 1, -64, 6};
            Name e = Name.fromString("abc.");
            DNSInput in = new DNSInput(raw);
            in.jump(8);
            Name n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_two_part_compression() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{10, 3, 97, 98, 99, 0, 1, 66, -64, 1};
            Name e = Name.fromString("B.abc.");
            DNSInput in = new DNSInput(raw);
            in.jump(6);
            Name n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_long_jump_compression() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 3, 97, 98, 99, 0, -63, 0};
            Name e = Name.fromString("abc.");
            DNSInput in = new DNSInput(raw);
            in.jump(261);
            Name n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
        }

        public void test_bad_compression() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{-64, 2, 0};
            try {
                new Name(new DNSInput(raw));
                Test_DNSInput_init.fail((String)"WireParseException not thrown");
            }
            catch (WireParseException wireParseException) {
                // empty catch block
            }
        }

        public void test_basic_compression_state_restore() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{10, 3, 97, 98, 99, 0, -64, 1, 3, 100, 101, 102, 0};
            Name e = Name.fromString("abc.");
            Name e2 = Name.fromString("def.");
            DNSInput in = new DNSInput(raw);
            in.jump(6);
            Name n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
            n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e2, (Object)n);
        }

        public void test_two_part_compression_state_restore() throws TextParseException, WireParseException {
            byte[] raw = new byte[]{10, 3, 97, 98, 99, 0, 1, 66, -64, 1, 3, 100, 101, 102, 0};
            Name e = Name.fromString("B.abc.");
            Name e2 = Name.fromString("def.");
            DNSInput in = new DNSInput(raw);
            in.jump(6);
            Name n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e, (Object)n);
            n = new Name(in);
            Test_DNSInput_init.assertEquals((Object)e2, (Object)n);
        }
    }

    public static class Test_String_init
    extends TestCase {
        private final String m_abs = "WWW.DnsJava.org.";
        private Name m_abs_origin;
        private final String m_rel = "WWW.DnsJava";
        private Name m_rel_origin;

        protected void setUp() throws TextParseException {
            this.m_abs_origin = Name.fromString("Orig.");
            this.m_rel_origin = Name.fromString("Orig");
        }

        public void test_ctor_empty() {
            try {
                new Name("");
                Test_String_init.fail((String)"TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_at_null_origin() throws TextParseException {
            Name n = new Name("@");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)0, (int)n.labels());
            Test_String_init.assertEquals((int)0, (int)n.length());
        }

        public void test_ctor_at_abs_origin() throws TextParseException {
            Name n = new Name("@", this.m_abs_origin);
            Test_String_init.assertEquals((Object)this.m_abs_origin, (Object)n);
        }

        public void test_ctor_at_rel_origin() throws TextParseException {
            Name n = new Name("@", this.m_rel_origin);
            Test_String_init.assertEquals((Object)this.m_rel_origin, (Object)n);
        }

        public void test_ctor_dot() throws TextParseException {
            Name n = new Name(".");
            Test_String_init.assertEquals((Object)Name.root, (Object)n);
            Test_String_init.assertNotSame((Object)Name.root, (Object)n);
            Test_String_init.assertEquals((int)1, (int)n.labels());
            Test_String_init.assertEquals((int)1, (int)n.length());
        }

        public void test_ctor_wildcard() throws TextParseException {
            Name n = new Name("*");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertTrue((boolean)n.isWild());
            Test_String_init.assertEquals((int)1, (int)n.labels());
            Test_String_init.assertEquals((int)2, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 42}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"*", (String)n.getLabelString(0));
        }

        public void test_ctor_abs() throws TextParseException {
            Name n = new Name("WWW.DnsJava.org.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)4, (int)n.labels());
            Test_String_init.assertEquals((int)17, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 87, 87, 87}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"WWW", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{7, 68, 110, 115, 74, 97, 118, 97}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"DnsJava", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 111, 114, 103}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"org", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(3));
        }

        public void test_ctor_rel() throws TextParseException {
            Name n = new Name("WWW.DnsJava");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)2, (int)n.labels());
            Test_String_init.assertEquals((int)12, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 87, 87, 87}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"WWW", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{7, 68, 110, 115, 74, 97, 118, 97}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"DnsJava", (String)n.getLabelString(1));
        }

        public void test_ctor_7label() throws TextParseException {
            Name n = new Name("a.b.c.d.e.f.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)7, (int)n.labels());
            Test_String_init.assertEquals((int)13, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 97}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"a", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 98}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"b", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 99}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"c", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 100}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"d", (String)n.getLabelString(3));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 101}, n.getLabel(4)));
            Test_String_init.assertEquals((String)"e", (String)n.getLabelString(4));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 102}, n.getLabel(5)));
            Test_String_init.assertEquals((String)"f", (String)n.getLabelString(5));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(6)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(6));
        }

        public void test_ctor_8label() throws TextParseException {
            Name n = new Name("a.b.c.d.e.f.g.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)8, (int)n.labels());
            Test_String_init.assertEquals((int)15, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 97}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"a", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 98}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"b", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 99}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"c", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 100}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"d", (String)n.getLabelString(3));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 101}, n.getLabel(4)));
            Test_String_init.assertEquals((String)"e", (String)n.getLabelString(4));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 102}, n.getLabel(5)));
            Test_String_init.assertEquals((String)"f", (String)n.getLabelString(5));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 103}, n.getLabel(6)));
            Test_String_init.assertEquals((String)"g", (String)n.getLabelString(6));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(7)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(7));
        }

        public void test_ctor_abs_abs_origin() throws TextParseException {
            Name n = new Name("WWW.DnsJava.org.", this.m_abs_origin);
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)4, (int)n.labels());
            Test_String_init.assertEquals((int)17, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 87, 87, 87}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"WWW", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{7, 68, 110, 115, 74, 97, 118, 97}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"DnsJava", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 111, 114, 103}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"org", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(3));
        }

        public void test_ctor_abs_rel_origin() throws TextParseException {
            Name n = new Name("WWW.DnsJava.org.", this.m_rel_origin);
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)4, (int)n.labels());
            Test_String_init.assertEquals((int)17, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 87, 87, 87}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"WWW", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{7, 68, 110, 115, 74, 97, 118, 97}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"DnsJava", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 111, 114, 103}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"org", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(3));
        }

        public void test_ctor_rel_abs_origin() throws TextParseException {
            Name n = new Name("WWW.DnsJava", this.m_abs_origin);
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)4, (int)n.labels());
            Test_String_init.assertEquals((int)18, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{3, 87, 87, 87}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"WWW", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{7, 68, 110, 115, 74, 97, 118, 97}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"DnsJava", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{4, 79, 114, 105, 103}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"Orig", (String)n.getLabelString(2));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(3)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(3));
        }

        public void test_ctor_invalid_label() {
            try {
                new Name("junk..junk.");
                Test_String_init.fail((String)"TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_max_label() throws TextParseException {
            Name n = new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.b.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)3, (int)n.labels());
            Test_String_init.assertEquals((int)67, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{63, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97}, n.getLabel(0)));
            Test_String_init.assertEquals((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", (String)n.getLabelString(0));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 98}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"b", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(2));
        }

        public void test_ctor_toobig_label() {
            try {
                new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.b.");
                Test_String_init.fail((String)"TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_max_length_rel() throws TextParseException {
            Name n = new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc.dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)4, (int)n.labels());
            Test_String_init.assertEquals((int)255, (int)n.length());
        }

        public void test_ctor_max_length_abs() throws TextParseException {
            Name n = new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc.ddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)5, (int)n.labels());
            Test_String_init.assertEquals((int)255, (int)n.length());
        }

        public void test_ctor_escaped() throws TextParseException {
            Name n = new Name("ab\\123cd");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)1, (int)n.labels());
            Test_String_init.assertEquals((int)6, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{5, 97, 98, 123, 99, 100}, n.getLabel(0)));
        }

        public void test_ctor_escaped_end() throws TextParseException {
            Name n = new Name("abcd\\123");
            Test_String_init.assertFalse((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)1, (int)n.labels());
            Test_String_init.assertEquals((int)6, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{5, 97, 98, 99, 100, 123}, n.getLabel(0)));
        }

        public void test_ctor_short_escaped() throws TextParseException {
            try {
                new Name("ab\\12cd");
                Test_String_init.fail((String)"TextParseException not throw");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_short_escaped_end() throws TextParseException {
            try {
                new Name("ab\\12");
                Test_String_init.fail((String)"TextParseException not throw");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_empty_escaped_end() throws TextParseException {
            try {
                new Name("ab\\");
                Test_String_init.fail((String)"TextParseException not throw");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_toobig_escaped() throws TextParseException {
            try {
                new Name("ab\\256cd");
                Test_String_init.fail((String)"TextParseException not throw");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_toobig_escaped_end() throws TextParseException {
            try {
                new Name("ab\\256");
                Test_String_init.fail((String)"TextParseException not throw");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_max_label_escaped() throws TextParseException {
            Name n = new Name("aaaa\\100aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.b.");
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)3, (int)n.labels());
            Test_String_init.assertEquals((int)67, (int)n.length());
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{63, 97, 97, 97, 97, 100, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97}, n.getLabel(0)));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 98}, n.getLabel(1)));
            Test_String_init.assertEquals((String)"b", (String)n.getLabelString(1));
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(2)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(2));
        }

        public void test_ctor_max_labels() throws TextParseException {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 127; ++i) {
                sb.append("a.");
            }
            Name n = new Name(sb.toString());
            Test_String_init.assertTrue((boolean)n.isAbsolute());
            Test_String_init.assertFalse((boolean)n.isWild());
            Test_String_init.assertEquals((int)128, (int)n.labels());
            Test_String_init.assertEquals((int)255, (int)n.length());
            for (int i = 0; i < 127; ++i) {
                Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{1, 97}, n.getLabel(i)));
                Test_String_init.assertEquals((String)"a", (String)n.getLabelString(i));
            }
            Test_String_init.assertTrue((boolean)Arrays.equals(new byte[]{0}, n.getLabel(127)));
            Test_String_init.assertEquals((String)"", (String)n.getLabelString(127));
        }

        public void test_ctor_toobig_label_escaped_end() throws TextParseException {
            try {
                new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\\090.b.");
                Test_String_init.fail((String)"TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_ctor_toobig_label_escaped() throws TextParseException {
            try {
                new Name("aaaaaaaaaaaaaaaaaaaaaaaaaaaa\\001aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.b.");
                Test_String_init.fail((String)"TextParseException not thrown");
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }

        public void test_fromString() throws TextParseException {
            Name n = new Name("WWW.DnsJava", this.m_abs_origin);
            Name n2 = Name.fromString("WWW.DnsJava", this.m_abs_origin);
            Test_String_init.assertEquals((Object)n, (Object)n2);
        }

        public void test_fromString_at() throws TextParseException {
            Name n = Name.fromString("@", this.m_rel_origin);
            Test_String_init.assertSame((Object)this.m_rel_origin, (Object)n);
        }

        public void test_fromString_dot() throws TextParseException {
            Name n = Name.fromString(".");
            Test_String_init.assertSame((Object)Name.root, (Object)n);
        }

        public void test_fromConstantString() throws TextParseException {
            Name n = new Name("WWW.DnsJava.org.");
            Name n2 = Name.fromConstantString("WWW.DnsJava.org.");
            Test_String_init.assertEquals((Object)n, (Object)n2);
        }

        public void test_fromConstantString_invalid() {
            try {
                Name.fromConstantString("junk..junk");
                Test_String_init.fail((String)"IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

