/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.HINFORecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class HINFORecordTest
extends TestCase {
    public void test_ctor_0arg() {
        HINFORecord dr = new HINFORecord();
        HINFORecordTest.assertNull((Object)dr.getName());
        HINFORecordTest.assertEquals((int)0, (int)dr.getType());
        HINFORecordTest.assertEquals((int)0, (int)dr.getDClass());
        HINFORecordTest.assertEquals((long)0L, (long)dr.getTTL());
    }

    public void test_getObject() {
        HINFORecord dr = new HINFORecord();
        Record r = dr.getObject();
        HINFORecordTest.assertTrue((boolean)(r instanceof HINFORecord));
    }

    public void test_ctor_5arg() throws TextParseException {
        Name n = Name.fromString("The.Name.");
        long ttl = 43981L;
        String cpu = "i686 Intel(R) Pentium(R) M processor 1.70GHz GenuineIntel GNU/Linux";
        String os = "Linux troy 2.6.10-gentoo-r6 #8 Wed Apr 6 21:25:04 MDT 2005";
        HINFORecord dr = new HINFORecord(n, 1, ttl, cpu, os);
        HINFORecordTest.assertEquals((Object)n, (Object)dr.getName());
        HINFORecordTest.assertEquals((int)1, (int)dr.getDClass());
        HINFORecordTest.assertEquals((int)13, (int)dr.getType());
        HINFORecordTest.assertEquals((long)ttl, (long)dr.getTTL());
        HINFORecordTest.assertEquals((String)cpu, (String)dr.getCPU());
        HINFORecordTest.assertEquals((String)os, (String)dr.getOS());
    }

    public void test_ctor_5arg_invalid_CPU() throws TextParseException {
        Name n = Name.fromString("The.Name.");
        long ttl = 43981L;
        String cpu = "i686 Intel(R) Pentium(R) M \\256 processor 1.70GHz GenuineIntel GNU/Linux";
        String os = "Linux troy 2.6.10-gentoo-r6 #8 Wed Apr 6 21:25:04 MDT 2005";
        try {
            new HINFORecord(n, 1, ttl, cpu, os);
            HINFORecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_ctor_5arg_invalid_OS() throws TextParseException {
        Name n = Name.fromString("The.Name.");
        long ttl = 43981L;
        String cpu = "i686 Intel(R) Pentium(R) M processor 1.70GHz GenuineIntel GNU/Linux";
        String os = "Linux troy 2.6.10-gentoo-r6 \\1 #8 Wed Apr 6 21:25:04 MDT 2005";
        try {
            new HINFORecord(n, 1, ttl, cpu, os);
            HINFORecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_rrFromWire() throws IOException {
        String cpu = "Intel(R) Pentium(R) M processor 1.70GHz";
        String os = "Linux troy 2.6.10-gentoo-r6";
        byte[] raw = new byte[]{39, 73, 110, 116, 101, 108, 40, 82, 41, 32, 80, 101, 110, 116, 105, 117, 109, 40, 82, 41, 32, 77, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 49, 46, 55, 48, 71, 72, 122, 27, 76, 105, 110, 117, 120, 32, 116, 114, 111, 121, 32, 50, 46, 54, 46, 49, 48, 45, 103, 101, 110, 116, 111, 111, 45, 114, 54};
        DNSInput in = new DNSInput(raw);
        HINFORecord dr = new HINFORecord();
        dr.rrFromWire(in);
        HINFORecordTest.assertEquals((String)cpu, (String)dr.getCPU());
        HINFORecordTest.assertEquals((String)os, (String)dr.getOS());
    }

    public void test_rdataFromString() throws IOException {
        String cpu = "Intel(R) Pentium(R) M processor 1.70GHz";
        String os = "Linux troy 2.6.10-gentoo-r6";
        Tokenizer t = new Tokenizer("\"" + cpu + "\" \"" + os + "\"");
        HINFORecord dr = new HINFORecord();
        dr.rdataFromString(t, null);
        HINFORecordTest.assertEquals((String)cpu, (String)dr.getCPU());
        HINFORecordTest.assertEquals((String)os, (String)dr.getOS());
    }

    public void test_rdataFromString_invalid_CPU() throws IOException {
        String cpu = "Intel(R) Pentium(R) \\388 M processor 1.70GHz";
        String os = "Linux troy 2.6.10-gentoo-r6";
        Tokenizer t = new Tokenizer("\"" + cpu + "\" \"" + os + "\"");
        HINFORecord dr = new HINFORecord();
        try {
            dr.rdataFromString(t, null);
            HINFORecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
    }

    public void test_rdataFromString_invalid_OS() throws IOException {
        String cpu = "Intel(R) Pentium(R) M processor 1.70GHz";
        Tokenizer t = new Tokenizer("\"" + cpu + "\"");
        HINFORecord dr = new HINFORecord();
        try {
            dr.rdataFromString(t, null);
            HINFORecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
    }

    public void test_rrToString() throws TextParseException {
        String cpu = "Intel(R) Pentium(R) M processor 1.70GHz";
        String os = "Linux troy 2.6.10-gentoo-r6";
        String exp = "\"" + cpu + "\" \"" + os + "\"";
        HINFORecord dr = new HINFORecord(Name.fromString("The.Name."), 1, 291L, cpu, os);
        HINFORecordTest.assertEquals((String)exp, (String)dr.rrToString());
    }

    public void test_rrToWire() throws TextParseException {
        String cpu = "Intel(R) Pentium(R) M processor 1.70GHz";
        String os = "Linux troy 2.6.10-gentoo-r6";
        byte[] raw = new byte[]{39, 73, 110, 116, 101, 108, 40, 82, 41, 32, 80, 101, 110, 116, 105, 117, 109, 40, 82, 41, 32, 77, 32, 112, 114, 111, 99, 101, 115, 115, 111, 114, 32, 49, 46, 55, 48, 71, 72, 122, 27, 76, 105, 110, 117, 120, 32, 116, 114, 111, 121, 32, 50, 46, 54, 46, 49, 48, 45, 103, 101, 110, 116, 111, 111, 45, 114, 54};
        HINFORecord dr = new HINFORecord(Name.fromString("The.Name."), 1, 291L, cpu, os);
        DNSOutput out = new DNSOutput();
        dr.rrToWire(out, null, true);
        HINFORecordTest.assertTrue((boolean)Arrays.equals(raw, out.toByteArray()));
    }
}

