/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class DNSKEYRecordTest
extends TestCase {
    public void test_ctor_0arg() throws UnknownHostException {
        DNSKEYRecord ar = new DNSKEYRecord();
        DNSKEYRecordTest.assertNull((Object)ar.getName());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getType());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getDClass());
        DNSKEYRecordTest.assertEquals((long)0L, (long)ar.getTTL());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getAlgorithm());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getFlags());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getFootprint());
        DNSKEYRecordTest.assertEquals((int)0, (int)ar.getProtocol());
        DNSKEYRecordTest.assertNull((Object)ar.getKey());
    }

    public void test_getObject() {
        DNSKEYRecord ar = new DNSKEYRecord();
        Record r = ar.getObject();
        DNSKEYRecordTest.assertTrue((boolean)(r instanceof DNSKEYRecord));
    }

    public void test_ctor_7arg() throws TextParseException {
        Name n = Name.fromString("My.Absolute.Name.");
        Name r = Name.fromString("My.Relative.Name");
        byte[] key = new byte[]{0, 1, 3, 5, 7, 9};
        DNSKEYRecord kr = new DNSKEYRecord(n, 1, 9388L, 38962, 18, 103, key);
        DNSKEYRecordTest.assertEquals((Object)n, (Object)kr.getName());
        DNSKEYRecordTest.assertEquals((int)48, (int)kr.getType());
        DNSKEYRecordTest.assertEquals((int)1, (int)kr.getDClass());
        DNSKEYRecordTest.assertEquals((long)9388L, (long)kr.getTTL());
        DNSKEYRecordTest.assertEquals((int)38962, (int)kr.getFlags());
        DNSKEYRecordTest.assertEquals((int)18, (int)kr.getProtocol());
        DNSKEYRecordTest.assertEquals((int)103, (int)kr.getAlgorithm());
        DNSKEYRecordTest.assertTrue((boolean)Arrays.equals(key, kr.getKey()));
        try {
            new DNSKEYRecord(r, 1, 9388L, 38962, 18, 103, key);
            DNSKEYRecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_rdataFromString() throws IOException, TextParseException {
        DNSKEYRecord kr = new DNSKEYRecord();
        Tokenizer st = new Tokenizer("43981 129 RSASHA1 AQIDBAUGBwgJ");
        kr.rdataFromString(st, null);
        DNSKEYRecordTest.assertEquals((int)43981, (int)kr.getFlags());
        DNSKEYRecordTest.assertEquals((int)129, (int)kr.getProtocol());
        DNSKEYRecordTest.assertEquals((int)5, (int)kr.getAlgorithm());
        DNSKEYRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, kr.getKey()));
        kr = new DNSKEYRecord();
        st = new Tokenizer("4626 170 ZONE AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            DNSKEYRecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

