/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.j2se.connectors.socket.Reader;

public class WebSocketReader
implements Reader {
    private static final Logger log = Logger.getLogger(WebSocketReader.class.getCanonicalName());
    private final ByteBuffer buf = ByteBuffer.allocate(2048);
    private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private final InputStream inputStream;
    private long remaining = 0L;

    public WebSocketReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int startBufPos;
        byte[] arr = this.buf.array();
        int read = this.inputStream.read(arr, startBufPos = this.buf.position(), this.buf.remaining());
        if (read == -1) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            read = 0;
        }
        this.buf.position(startBufPos + read);
        this.buf.flip();
        CharBuffer cb = CharBuffer.wrap(cbuf);
        while (this.buf.hasRemaining() && cb.hasRemaining()) {
            if (this.remaining == 0L) {
                boolean reset = false;
                int position = this.buf.position();
                byte type = this.buf.get();
                if (type == 8) break;
                if (this.buf.hasRemaining()) {
                    long len = this.buf.get() & 0x7F;
                    if (len == 126L) {
                        if (this.buf.remaining() >= 2) {
                            this.remaining = this.buf.getShort() & 0xFFFF;
                        } else {
                            reset = true;
                        }
                    } else if (len == 127L) {
                        if (this.buf.remaining() >= 8) {
                            this.remaining = this.buf.getLong();
                        } else {
                            reset = true;
                        }
                    } else {
                        this.remaining = len;
                    }
                } else {
                    reset = true;
                }
                if (reset) {
                    this.buf.position(position);
                    break;
                }
                log.log(Level.FINEST, "got frame of type = " + type + " with length = " + this.remaining);
            }
            if (this.remaining <= 0L) continue;
            long waiting = this.remaining <= (long)this.buf.remaining() ? this.remaining : (long)this.buf.remaining();
            int limit = this.buf.limit();
            int rem = this.buf.remaining();
            this.buf.limit((int)((long)this.buf.position() + waiting));
            this.decoder.decode(this.buf, cb, false);
            this.buf.limit(limit);
            this.remaining -= (long)(rem - this.buf.remaining());
            if (this.remaining >= 0L) continue;
            this.remaining = 0L;
        }
        this.buf.compact();
        cb.flip();
        if (log.isLoggable(Level.FINEST) && cb.hasRemaining()) {
            char[] tmp = new char[cb.remaining()];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = cb.get(cb.position() + i);
            }
            log.log(Level.FINEST, "read data = " + new String(tmp) + ", still remaining = " + this.remaining + " and in buffer " + this.buf.remaining());
        }
        return cb.remaining();
    }
}

