/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.bosh;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.connector.BoshRequest;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.j2se.xml.J2seElement;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public abstract class BoshWorker
implements BoshRequest {
    private final tigase.jaxmpp.core.client.xml.Element body;
    private HttpURLConnection conn;
    private final DomBuilderHandler domHandler;
    private Logger log;
    private final SimpleParser parser;
    private final String rid;
    private final SessionObject sessionObject;
    private boolean terminated = false;

    public BoshWorker(DomBuilderHandler domHandler, SimpleParser parser, SessionObject sessionObject, tigase.jaxmpp.core.client.xml.Element body) throws XMLException, JaxmppException {
        this.domHandler = domHandler;
        this.parser = parser;
        this.sessionObject = sessionObject;
        this.log = Logger.getLogger(this.getClass().getName());
        this.body = body;
        this.rid = body.getAttribute("rid");
        if (this.rid == null) {
            throw new RuntimeException("rid must be defined");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoshWorker)) {
            return false;
        }
        return ((BoshWorker)obj).rid.equals(this.rid);
    }

    public String getRid() {
        return this.rid;
    }

    public int hashCode() {
        return this.rid.hashCode();
    }

    protected abstract void onError(int var1, String var2, tigase.jaxmpp.core.client.xml.Element var3, Throwable var4) throws JaxmppException;

    protected abstract void onSuccess(int var1, String var2, tigase.jaxmpp.core.client.xml.Element var3) throws JaxmppException;

    protected abstract void onTerminate(int var1, String var2, tigase.jaxmpp.core.client.xml.Element var3) throws JaxmppException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.terminated) {
            return;
        }
        try {
            try {
                String responseData;
                Integer responseCode;
                block21: {
                    URL url = (URL)this.sessionObject.getProperty("bosh#url");
                    if (url == null) {
                        throw new JaxmppException("bosh#url is not set!");
                    }
                    this.conn = (HttpURLConnection)url.openConnection();
                    this.conn.setRequestMethod("POST");
                    this.conn.setRequestProperty("User-Agent", "Mozilla/5.0 ( compatible ) ");
                    this.conn.setRequestProperty("Accept", "*/*");
                    String b = this.body.getAsString();
                    if (!this.conn.getDoOutput()) {
                        this.conn.setDoOutput(true);
                    }
                    OutputStreamWriter wr = new OutputStreamWriter(this.conn.getOutputStream());
                    wr.write(b);
                    wr.flush();
                    try {
                        String line;
                        responseCode = this.conn.getResponseCode();
                        StringBuilder sb = new StringBuilder();
                        InputStream is = responseCode >= 400 ? this.conn.getErrorStream() : this.conn.getInputStream();
                        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                        while ((line = rd.readLine()) != null) {
                            sb.append(line);
                        }
                        responseData = sb.toString();
                    }
                    catch (RuntimeException ex) {
                        responseCode = 500;
                        responseData = "Server returned no data";
                        if (!this.log.isLoggable(Level.FINEST)) break block21;
                        this.log.log(Level.FINEST, "got exception while reading data from socket", ex);
                    }
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Received: " + responseData);
                }
                if (responseCode != 200) {
                    this.onError(responseCode, responseData, null, null);
                    return;
                }
                DomBuilderHandler domBuilderHandler = this.domHandler;
                synchronized (domBuilderHandler) {
                    Element elem;
                    this.parser.parse((SimpleHandler)this.domHandler, responseData.toCharArray(), 0, responseData.length());
                    Queue elems = this.domHandler.getParsedElements();
                    while ((elem = (Element)elems.poll()) != null) {
                        String type = elem.getAttribute("type");
                        J2seElement response = new J2seElement(elem);
                        if (type != null && "terminate".equals(type)) {
                            this.onTerminate(responseCode, responseData, response);
                            continue;
                        }
                        if (type != null && "error".equals(type)) {
                            this.onError(responseCode, responseData, response, null);
                            continue;
                        }
                        if (type == null) {
                            this.onSuccess(responseCode, responseData, response);
                            continue;
                        }
                        throw new RuntimeException("Unknown response type '" + type + "'");
                    }
                }
            }
            catch (SocketException e) {
                if (this.terminated) {
                    return;
                }
                this.onError(0, null, null, e);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Connection error ", e);
                this.onError(0, null, null, e);
            }
        }
        catch (JaxmppException e1) {
            this.log.log(Level.SEVERE, "What a Terrible Failure?", e1);
        }
    }

    public void terminate() {
        this.terminated = true;
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public String toString() {
        return "rid=" + this.rid;
    }
}

