/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.auth.scram;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.xmpp.modules.auth.AuthModule;
import tigase.jaxmpp.core.client.xmpp.modules.auth.ClientSaslException;
import tigase.jaxmpp.core.client.xmpp.modules.auth.CredentialsCallback;
import tigase.jaxmpp.core.client.xmpp.modules.auth.saslmechanisms.AbstractSaslMechanism;

public class ScramMechanism
extends AbstractSaslMechanism {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String SCRAM_SASL_DATA_KEY = "SCRAM_SASL_DATA_KEY";
    private static final Pattern SERVER_FIRST_MESSAGE = Pattern.compile("^(m=[^\\000=]+,)?r=([\\x21-\\x2B\\x2D-\\x7E]+),s=([a-zA-Z0-9/+=]+),i=(\\d+)(?:,.*)?$");
    private static final Pattern SERVER_LAST_MESSAGE = Pattern.compile("^(?:e=([^,]+)|v=([a-zA-Z0-9/+=]+)(?:,.*)?)$");
    private final String algorithm;
    private final byte[] clientKeyData;
    private final String mechanismName;
    private final Random random = new SecureRandom();
    private final byte[] serverKeyData;

    public static byte[] hi(String algorithm, byte[] password, byte[] salt, int iterations) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec k = new SecretKeySpec(password, "Hmac" + algorithm);
        byte[] z = new byte[salt.length + 4];
        System.arraycopy(salt, 0, z, 0, salt.length);
        System.arraycopy(new byte[]{0, 0, 0, 1}, 0, z, salt.length, 4);
        byte[] u = ScramMechanism.hmac(k, z);
        byte[] result = new byte[u.length];
        System.arraycopy(u, 0, result, 0, result.length);
        for (int i = 1; i < iterations; ++i) {
            u = ScramMechanism.hmac(k, u);
            for (int j = 0; j < u.length; ++j) {
                int n = j;
                result[n] = (byte)(result[n] ^ u[j]);
            }
        }
        return result;
    }

    protected static byte[] hmac(SecretKey key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        return mac.doFinal(data);
    }

    public static byte[] normalize(String str) {
        return str.getBytes(CHARSET);
    }

    public ScramMechanism() {
        this("SCRAM-SHA-1", "SHA1", "Client Key".getBytes(), "Server Key".getBytes());
    }

    public ScramMechanism(String mechanismName, String algorithm, byte[] clientKey, byte[] serverKey) {
        this.clientKeyData = clientKey;
        this.serverKeyData = serverKey;
        this.algorithm = algorithm;
        this.mechanismName = mechanismName;
    }

    public String evaluateChallenge(String input, SessionObject sessionObject) throws ClientSaslException {
        Data data = this.getData(sessionObject);
        try {
            if (data.stage == 0) {
                BareJID userJID = (BareJID)sessionObject.getProperty("userBareJid");
                data.conce = this.randomString();
                StringBuilder sb = new StringBuilder();
                sb.append("n,");
                sb.append(',');
                data.cb = sb.toString();
                sb = new StringBuilder();
                sb.append("n=").append(userJID.getLocalpart()).append(',');
                sb.append("r=").append(data.conce);
                data.clientFirstMessageBare = sb.toString();
                ++data.stage;
                return Base64.encode((byte[])(data.cb + data.clientFirstMessageBare).getBytes());
            }
            if (data.stage == 1) {
                String serverFirstMessage = new String(Base64.decode((String)input));
                Matcher r = SERVER_FIRST_MESSAGE.matcher(serverFirstMessage);
                if (!r.matches()) {
                    throw new ClientSaslException("Bad challenge syntax");
                }
                String mext = r.group(1);
                String nonce = r.group(2);
                byte[] salt = Base64.decode((String)r.group(3));
                int iterations = Integer.parseInt(r.group(4));
                if (!nonce.startsWith(data.conce)) {
                    throw new ClientSaslException("Wrong nonce");
                }
                CredentialsCallback callback = (CredentialsCallback)sessionObject.getProperty("jaxmpp#credentialsCallback");
                if (callback == null) {
                    callback = new AuthModule.DefaultCredentialsCallback(sessionObject);
                }
                StringBuilder clientFinalMessage = new StringBuilder();
                clientFinalMessage.append("c=").append(Base64.encode((byte[])data.cb.getBytes())).append(',');
                clientFinalMessage.append("r=").append(nonce);
                data.authMessage = data.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessage.toString();
                Data.access$502(data, ScramMechanism.hi(this.algorithm, ScramMechanism.normalize(callback.getCredential()), salt, iterations));
                byte[] clientKey = ScramMechanism.hmac(this.key(data.saltedPassword), this.clientKeyData);
                byte[] storedKey = this.h(clientKey);
                byte[] clientSignature = ScramMechanism.hmac(this.key(storedKey), data.authMessage.getBytes());
                byte[] clientProof = this.xor(clientKey, clientSignature);
                clientFinalMessage.append(',');
                clientFinalMessage.append("p=").append(Base64.encode((byte[])clientProof));
                ++data.stage;
                return Base64.encode((byte[])clientFinalMessage.toString().getBytes());
            }
            if (data.stage == 2) {
                String serverLastMessage = new String(Base64.decode((String)input));
                Matcher r = SERVER_LAST_MESSAGE.matcher(serverLastMessage);
                if (!r.matches()) {
                    throw new ClientSaslException("Bad challenge syntax");
                }
                String e = r.group(1);
                String v = r.group(2);
                if (e != null) {
                    throw new ClientSaslException("Error: " + e);
                }
                byte[] serverKey = ScramMechanism.hmac(this.key(data.saltedPassword), this.serverKeyData);
                byte[] serverSignature = ScramMechanism.hmac(this.key(serverKey), data.authMessage.getBytes());
                if (!Arrays.equals(serverSignature, Base64.decode((String)v))) {
                    throw new ClientSaslException("Invalid Server Signatuer");
                }
                ++data.stage;
                this.setComplete(sessionObject, true);
                return null;
            }
            if (this.isComplete(sessionObject) && input == null) {
                return null;
            }
            throw new ClientSaslException(this.name() + ": Client at illegal state");
        }
        catch (ClientSaslException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new ClientSaslException("Error in SASL", (Throwable)e1);
        }
    }

    protected Data getData(SessionObject sessionObject) {
        Data data = (Data)sessionObject.getProperty(SCRAM_SASL_DATA_KEY);
        if (data == null) {
            data = new Data();
            sessionObject.setProperty(SessionObject.Scope.stream, SCRAM_SASL_DATA_KEY, (Object)data);
        }
        return data;
    }

    protected byte[] h(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        return digest.digest(data);
    }

    public boolean isAllowedToUse(SessionObject sessionObject) {
        return (sessionObject.getProperty("password") != null || sessionObject.getProperty("jaxmpp#credentialsCallback") != null) && sessionObject.getProperty("userBareJid") != null;
    }

    protected SecretKey key(byte[] key) {
        return new SecretKeySpec(key, "Hmac" + this.algorithm);
    }

    public String name() {
        return this.mechanismName;
    }

    private String randomString() {
        int length = 20;
        int x = ALPHABET.length();
        char[] buffer = new char[20];
        for (int i = 0; i < 20; ++i) {
            int r = this.random.nextInt(x);
            buffer[i] = ALPHABET.charAt(r);
        }
        return new String(buffer);
    }

    protected byte[] xor(byte[] a, byte[] b) {
        int l = a.length;
        byte[] r = new byte[l];
        for (int i = 0; i < l; ++i) {
            r[i] = (byte)(a[i] ^ b[i]);
        }
        return r;
    }

    private class Data {
        private String authMessage;
        private String cb = "n,";
        private String clientFirstMessageBare;
        private String conce;
        private byte[] saltedPassword;
        private int stage = 0;

        private Data() {
        }

        static /* synthetic */ byte[] access$502(Data x0, byte[] x1) {
            x0.saltedPassword = x1;
            return x1;
        }
    }
}

