/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.modules.auth.saslmechanism;

import org.junit.Assert;
import org.junit.Test;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Base64;
import tigase.jaxmpp.core.client.MockSessionObject;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.xmpp.modules.auth.saslmechanisms.PlainMechanism;

public class PlainMechanismTest {
    private static final String NULL = String.valueOf('\u0000');

    private String generateMessage(String authzid, String authcid, String password) {
        StringBuilder sb = new StringBuilder();
        if (authzid != null) {
            sb.append(authzid);
        }
        sb.append(NULL);
        if (authcid != null) {
            sb.append(authcid);
        }
        sb.append(NULL);
        if (password != null) {
            sb.append(password);
        }
        return sb.toString();
    }

    @Test
    public void testForcingAuthzid_FALSE() throws Exception {
        MockSessionObject sessionObject = new MockSessionObject(null);
        sessionObject.setProperty("userBareJid", BareJID.bareJIDInstance((String)"user@example.com"));
        sessionObject.setProperty("password", "pencil");
        sessionObject.setUserProperty("SASL#FORCE_AUTHZID", false);
        sessionObject.setUserProperty("LOGIN_USER_NAME", "some-username");
        PlainMechanism scram = new PlainMechanism();
        String firstClientMessage = new String(Base64.decode((String)scram.evaluateChallenge(null, (SessionObject)sessionObject)));
        Assert.assertEquals((Object)this.generateMessage(null, "some-username", "pencil"), (Object)firstClientMessage);
    }

    @Test
    public void testForcingAuthzid_TRUE() throws Exception {
        MockSessionObject sessionObject = new MockSessionObject(null);
        sessionObject.setProperty("userBareJid", BareJID.bareJIDInstance((String)"user@example.com"));
        sessionObject.setProperty("password", "pencil");
        sessionObject.setUserProperty("SASL#FORCE_AUTHZID", true);
        PlainMechanism scram = new PlainMechanism();
        String firstClientMessage = new String(Base64.decode((String)scram.evaluateChallenge(null, (SessionObject)sessionObject)));
        Assert.assertEquals((Object)this.generateMessage("user@example.com", "user", "pencil"), (Object)firstClientMessage);
    }

    @Test
    public void testForcingAuthzid_Unset() throws Exception {
        MockSessionObject sessionObject = new MockSessionObject(null);
        sessionObject.setProperty("userBareJid", BareJID.bareJIDInstance((String)"user@example.com"));
        sessionObject.setProperty("password", "pencil");
        sessionObject.setUserProperty("LOGIN_USER_NAME", "some-username");
        PlainMechanism scram = new PlainMechanism();
        String firstClientMessage = new String(Base64.decode((String)scram.evaluateChallenge(null, (SessionObject)sessionObject)));
        Assert.assertEquals((Object)this.generateMessage("user@example.com", "some-username", "pencil"), (Object)firstClientMessage);
    }
}

