/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xml;

import java.util.List;
import junit.framework.TestCase;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;

public class DefaultElementTest
extends TestCase {
    private static Element createElement() throws XMLException {
        Element message = ElementFactory.create((String)"message", null, null);
        message.setAttribute("to", "romeo@example.net");
        message.setAttribute("from", "juliet@example.com/balcony");
        message.setAttribute("type", "chat");
        message.addChild(ElementFactory.create((String)"subject", (String)"I implore you!", null));
        message.addChild(ElementFactory.create((String)"body", (String)"Wherefore art thou, Romeo?", null));
        message.addChild(ElementFactory.create((String)"thread", (String)"e0ffe42b28561960c6b12b944a092794b9683a38", null));
        message.addChild(ElementFactory.create((String)"x", (String)"tigase:offline", (String)"tigase"));
        return message;
    }

    public void testFindChild() throws XMLException {
        Element element = DefaultElementTest.createElement();
        Element nullElement = element.findChild(new String[]{"message", "missing"});
        DefaultElementTest.assertNull((Object)nullElement);
        Element c = element.findChild(new String[]{"message", "body"});
        DefaultElementTest.assertNotNull((Object)c);
        DefaultElementTest.assertEquals((String)"body", (String)c.getName());
        DefaultElementTest.assertEquals((String)"Wherefore art thou, Romeo?", (String)c.getValue());
    }

    public void testGetAsString() throws XMLException {
        Element auth = ElementFactory.create((String)"auth");
        auth.setAttribute("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl");
        auth.setValue("base64content");
        DefaultElementTest.assertEquals((String)"<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">base64content</auth>", (String)auth.getAsString());
    }

    public void testGetAttribute() throws XMLException {
        Element element = DefaultElementTest.createElement();
        DefaultElementTest.assertEquals((String)"juliet@example.com/balcony", (String)element.getAttribute("from"));
        DefaultElementTest.assertEquals((String)"romeo@example.net", (String)element.getAttribute("to"));
    }

    public void testGetChildren() throws XMLException {
        Element element = DefaultElementTest.createElement();
        DefaultElementTest.assertEquals((String)"message", (String)element.getName());
        List c = element.getChildren("subject");
        DefaultElementTest.assertEquals((int)1, (int)c.size());
        Element e = (Element)c.get(0);
        DefaultElementTest.assertEquals((String)"subject", (String)e.getName());
        c = element.getChildrenNS("tigase");
        DefaultElementTest.assertEquals((int)1, (int)c.size());
        e = (Element)c.get(0);
        DefaultElementTest.assertEquals((String)"x", (String)e.getName());
        Element c1 = element.getChildrenNS("x", "tigase");
        DefaultElementTest.assertNotNull((Object)c1);
        DefaultElementTest.assertEquals((String)"x", (String)c1.getName());
    }

    public void testGetChildrenAfter() throws XMLException {
        Element element = DefaultElementTest.createElement();
        List c = element.getChildren("subject");
        DefaultElementTest.assertEquals((int)1, (int)c.size());
        Element e = (Element)c.get(0);
        Element body = element.getChildAfter(e);
        DefaultElementTest.assertEquals((String)"body", (String)body.getName());
        DefaultElementTest.assertEquals((String)"Wherefore art thou, Romeo?", (String)body.getValue());
    }

    public void testGetFirstChild() throws XMLException {
        Element element = DefaultElementTest.createElement();
        Element fc = element.getFirstChild();
        DefaultElementTest.assertEquals((String)"subject", (String)fc.getName());
    }

    public void testGetNextSibling() throws XMLException {
        Element element = DefaultElementTest.createElement();
        List c = element.getChildren("subject");
        DefaultElementTest.assertEquals((int)1, (int)c.size());
        Element e = (Element)c.get(0);
        Element body = e.getNextSibling();
        DefaultElementTest.assertEquals((String)"body", (String)body.getName());
        DefaultElementTest.assertEquals((String)"Wherefore art thou, Romeo?", (String)body.getValue());
    }

    public void testGetXMLNS() throws XMLException {
        Element element = DefaultElementTest.createElement();
        DefaultElementTest.assertNull((Object)element.getXMLNS());
        Element c = element.getChildrenNS("x", "tigase");
        DefaultElementTest.assertNotNull((Object)c);
        DefaultElementTest.assertEquals((String)"x", (String)c.getName());
        DefaultElementTest.assertEquals((String)"tigase", (String)c.getXMLNS());
    }
}

