/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client;

import tigase.jaxmpp.core.client.AbstractJaxmppTest;
import tigase.jaxmpp.core.client.MockWriter;
import tigase.jaxmpp.core.client.Processor;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.PingModule;

public class ProcessorTest
extends AbstractJaxmppTest {
    private Processor processor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmppModulesManager xmppModulesManages = new XmppModulesManager(this.context);
        xmppModulesManages.register((XmppModule)new PingModule());
        this.processor = new Processor(xmppModulesManages, this.context);
    }

    public void test01() throws XMLException {
        Element e = ElementFactory.create((String)"iq");
        Runnable r = this.processor.process(e);
        r.run();
        Element expected = ElementFactory.create((String)"iq");
        expected.setAttribute("type", "error");
        Element er = expected.addChild(ElementFactory.create((String)"error"));
        er.setAttribute("code", "501");
        er.setAttribute("type", "cancel");
        Element fni = er.addChild(ElementFactory.create((String)"feature-not-implemented"));
        fni.setXMLNS("urn:ietf:params:xml:ns:xmpp-stanzas");
        ProcessorTest.assertEquals((Object)expected, (Object)((MockWriter)this.context.getWriter()).poll());
    }

    public void test02() throws XMLException {
        Element e = ElementFactory.create((String)"iq");
        e.setAttribute("type", "set");
        e.addChild(ElementFactory.create((String)"ping", null, (String)"urn:xmpp:ping"));
        Runnable r = this.processor.process(e);
        r.run();
        Element expected = ElementFactory.create((String)"iq");
        expected.setAttribute("type", "error");
        Element er = expected.addChild(ElementFactory.create((String)"error"));
        er.setAttribute("code", "405");
        er.setAttribute("type", "cancel");
        Element fni = er.addChild(ElementFactory.create((String)"not-allowed"));
        fni.setXMLNS("urn:ietf:params:xml:ns:xmpp-stanzas");
        ProcessorTest.assertEquals((Object)expected, (Object)((MockWriter)this.context.getWriter()).poll());
    }

    public void test03() throws XMLException {
        Element e = ElementFactory.create((String)"iq");
        e.setAttribute("to", "a@b.c");
        e.setAttribute("type", "get");
        e.addChild(ElementFactory.create((String)"ping", null, (String)"urn:xmpp:ping"));
        Runnable r = this.processor.process(e);
        r.run();
        Element expected = ElementFactory.create((String)"iq");
        expected.setAttribute("from", "a@b.c");
        expected.setAttribute("type", "result");
        ProcessorTest.assertEquals((Object)expected, (Object)((MockWriter)this.context.getWriter()).poll());
    }

    public void test04() throws XMLException {
        Element e = ElementFactory.create((String)"iq");
        e.setAttribute("to", "a@b.c");
        e.setAttribute("type", "get");
        e.addChild(ElementFactory.create((String)"ping", null, (String)"urn:xmpp:ping"));
        Runnable r = this.processor.process(e);
        r.run();
        Element expected = ElementFactory.create((String)"iq");
        expected.setAttribute("from", "a@b.c");
        expected.setAttribute("type", "result");
        ProcessorTest.assertEquals((Object)expected, (Object)((MockWriter)this.context.getWriter()).poll());
    }
}

