/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.eventbus;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.jaxmpp.core.client.eventbus.DefaultEventBus;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventBus;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.EventListener;

public class DefaultEventBusTest
extends TestCase {
    private EventBus eventBus;

    @Before
    public void setUp() throws Exception {
        this.eventBus = new DefaultEventBus();
    }

    @Test
    public void test0() {
        final String[] value = new String[1];
        this.eventBus.addHandler(Test01Handler.Test01Event.class, (EventHandler)new Test01Handler(){

            @Override
            public void onTest01Event(String data) {
                value[0] = "h" + data;
            }
        });
        Test01Handler.Test01Event event = new Test01Handler.Test01Event("test0.1");
        this.eventBus.fire((Event)event);
        event = new Test01Handler.Test01Event("test0.2");
        this.eventBus.fire((Event)event);
        Assert.assertEquals((Object)"htest0.2", (Object)value[0]);
        event = new Test01Handler.Test01Event("test0.3");
        this.eventBus.fire((Event)event);
    }

    @Test
    public void test1() {
        final String[] value = new String[5];
        this.eventBus.addHandler(Test01Handler.Test01Event.class, (EventHandler)new Test01Handler(){

            @Override
            public void onTest01Event(String data) {
                value[0] = "h" + data;
            }
        });
        this.eventBus.addHandler(Test02Handler.Test02Event.class, (EventHandler)new Test02Handler(){

            @Override
            public void onTest02Event(String data) {
                value[2] = "x" + data;
            }
        });
        this.eventBus.addListener(new EventListener(){

            public void onEvent(Event<? extends EventHandler> event) {
                if (event instanceof Test01Handler.Test01Event) {
                    value[1] = "l" + ((Test01Handler.Test01Event)event).getData();
                } else if (event instanceof Test02Handler.Test02Event) {
                    value[4] = "l" + ((Test02Handler.Test02Event)event).getData();
                }
            }
        });
        this.eventBus.addListener(Test02Handler.Test02Event.class, new EventListener(){

            public void onEvent(Event<? extends EventHandler> event) {
                value[3] = "fail";
            }
        });
        Test01Handler.Test01Event event = new Test01Handler.Test01Event("test01");
        this.eventBus.fire((Event)event);
        Assert.assertEquals((Object)"htest01", (Object)value[0]);
        Assert.assertEquals((Object)"ltest01", (Object)value[1]);
        Assert.assertNull((Object)value[2]);
        Assert.assertNull((Object)value[3]);
        Assert.assertNull((Object)value[4]);
    }

    @Test
    public void testRemove() {
        final String[] value = new String[2];
        Test01Handler h1 = new Test01Handler(){

            @Override
            public void onTest01Event(String data) {
                value[0] = data;
            }
        };
        EventListener l1 = new EventListener(){

            public void onEvent(Event<? extends EventHandler> event) {
                value[1] = ((Test01Handler.Test01Event)event).getData();
            }
        };
        this.eventBus.addHandler(Test01Handler.Test01Event.class, (EventHandler)h1);
        this.eventBus.addListener(Test01Handler.Test01Event.class, l1);
        Test01Handler.Test01Event event = new Test01Handler.Test01Event("t1");
        this.eventBus.fire((Event)event);
        Assert.assertEquals((Object)"t1", (Object)value[0]);
        Assert.assertEquals((Object)"t1", (Object)value[1]);
        this.eventBus.remove((EventHandler)h1);
        event = new Test01Handler.Test01Event("t2");
        this.eventBus.fire((Event)event);
        Assert.assertEquals((Object)"t1", (Object)value[0]);
        Assert.assertEquals((Object)"t2", (Object)value[1]);
        this.eventBus.remove(Test01Handler.Test01Event.class, (EventHandler)l1);
        event = new Test01Handler.Test01Event("t3");
        this.eventBus.fire((Event)event);
        Assert.assertEquals((Object)"t1", (Object)value[0]);
        Assert.assertEquals((Object)"t2", (Object)value[1]);
    }

    public static interface Test02Handler
    extends EventHandler {
        public void onTest02Event(String var1);

        public static class Test02Event
        extends Event<Test02Handler> {
            private final String data;

            public Test02Event(String data) {
                this.data = data;
            }

            public void dispatch(Test02Handler handler) {
                handler.onTest02Event(this.data);
            }

            public String getData() {
                return this.data;
            }
        }
    }

    public static interface Test01Handler
    extends EventHandler {
        public void onTest01Event(String var1);

        public static class Test01Event
        extends Event<Test01Handler> {
            private final String data;

            public Test01Event(String data) {
                this.data = data;
            }

            public void dispatch(Test01Handler handler) {
                handler.onTest01Event(this.data);
            }

            public String getData() {
                return this.data;
            }
        }
    }
}

