/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client;

import junit.framework.Assert;
import tigase.jaxmpp.core.client.AbstractJaxmppTest;
import tigase.jaxmpp.core.client.AsyncCallback;
import tigase.jaxmpp.core.client.MockWriter;
import tigase.jaxmpp.core.client.ResponseManager;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;

public class ResponseManagerTest
extends AbstractJaxmppTest {
    private final ResponseManager rm = new ResponseManager();

    public void test01() {
        try {
            Element es = ElementFactory.create((String)"iq");
            es.setAttribute("id", "1");
            es.setAttribute("type", "set");
            es.setAttribute("to", "a@b.c");
            Element er = ElementFactory.create((String)"iq");
            er.setAttribute("type", "result");
            er.setAttribute("id", "1");
            er.setAttribute("from", "a@b.c");
            this.rm.registerResponseHandler(es, null, new AsyncCallback(){

                public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) {
                    Assert.fail();
                }

                public void onSuccess(Stanza responseStanza) throws JaxmppException {
                    Assert.assertEquals((String)"1", (String)responseStanza.getAttribute("id"));
                    Assert.assertEquals((String)"a@b.c", (String)responseStanza.getAttribute("from"));
                    Element es = ElementFactory.create((String)"response");
                    ResponseManagerTest.this.context.getWriter().write(es);
                }

                public void onTimeout() {
                    Assert.fail();
                }
            });
            Runnable r = this.rm.getResponseHandler(er, this.context);
            r.run();
            ResponseManagerTest.assertEquals((String)"response", (String)((MockWriter)this.context.getWriter()).poll().getName());
        }
        catch (JaxmppException e1) {
            e1.printStackTrace();
            ResponseManagerTest.fail((String)e1.getMessage());
        }
    }

    public void test02() {
        try {
            Element es = ElementFactory.create((String)"iq");
            es.setAttribute("id", "1");
            es.setAttribute("type", "set");
            es.setAttribute("to", "a@b.c");
            Element er = ElementFactory.create((String)"iq");
            er.setAttribute("type", "error");
            er.setAttribute("id", "1");
            er.setAttribute("from", "a@b.c");
            Element e1 = ElementFactory.create((String)"error");
            e1.setAttribute("type", "wait");
            er.addChild(e1);
            Element e2 = ElementFactory.create((String)"internal-server-error", null, (String)"urn:ietf:params:xml:ns:xmpp-stanzas");
            e1.addChild(e2);
            this.rm.registerResponseHandler(es, null, new AsyncCallback(){

                public void onError(Stanza responseStanza, XMPPException.ErrorCondition error) throws JaxmppException {
                    Assert.assertEquals((Object)XMPPException.ErrorCondition.internal_server_error, (Object)error);
                    Assert.assertEquals((String)"1", (String)responseStanza.getAttribute("id"));
                    Assert.assertEquals((String)"a@b.c", (String)responseStanza.getAttribute("from"));
                    Element es = ElementFactory.create((String)"response");
                    ResponseManagerTest.this.context.getWriter().write(es);
                }

                public void onSuccess(Stanza responseStanza) throws XMLException {
                    Assert.fail();
                }

                public void onTimeout() {
                    Assert.fail();
                }
            });
            Runnable r = this.rm.getResponseHandler(er, this.context);
            r.run();
            ResponseManagerTest.assertEquals((String)"response", (String)((MockWriter)this.context.getWriter()).poll().getName());
        }
        catch (JaxmppException e1) {
            e1.printStackTrace();
            ResponseManagerTest.fail((String)e1.getMessage());
        }
    }
}

