/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import tigase.jaxmpp.core.client.Hex;

public class HexTest {
    @Test
    public void decode() {
        Assert.assertArrayEquals((byte[])new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57}, (byte[])Hex.decode((String)"30313233343536373839"));
    }

    @Test
    public void encode() {
        Assert.assertEquals((Object)"30313233343536373839", (Object)Hex.encode((byte[])new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57}));
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"1", (Object)Hex.format((String)"1", (int)4));
        Assert.assertEquals((Object)"12", (Object)Hex.format((String)"12", (int)4));
        Assert.assertEquals((Object)"123", (Object)Hex.format((String)"123", (int)4));
        Assert.assertEquals((Object)"1234", (Object)Hex.format((String)"1234", (int)4));
        Assert.assertEquals((Object)"1234 5", (Object)Hex.format((String)"12345", (int)4));
        Assert.assertEquals((Object)"1234 56", (Object)Hex.format((String)"123456", (int)4));
        Assert.assertEquals((Object)"1234 567", (Object)Hex.format((String)"1234567", (int)4));
        Assert.assertEquals((Object)"1234 5678", (Object)Hex.format((String)"12345678", (int)4));
        Assert.assertEquals((Object)"1234 5678 9", (Object)Hex.format((String)"123456789", (int)4));
        Assert.assertEquals((Object)"1234 5678 90", (Object)Hex.format((String)"1234567890", (int)4));
        Assert.assertEquals((Object)"123 456 7", (Object)Hex.format((String)"1234567", (int)3));
        Assert.assertEquals((Object)"123 456 78", (Object)Hex.format((String)"12345678", (int)3));
    }

    @Test
    public void encodeAndDecodeString() throws UnsupportedEncodingException {
        String t = "Zb\u0142a\u017a\u0144 m\u017cysto\u015b\u0107 gl\u0119d\u00f3w hiperfunkcj\u0105.";
        String h = Hex.encode((byte[])t.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"5a62c58261c5bac584206dc5bc7973746fc59bc48720676cc49964c3b37720686970657266756e6b636ac4852e", (Object)h);
        String t1 = new String(Hex.decode((String)h));
        Assert.assertEquals((Object)t, (Object)t1);
    }
}

