/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.jaxmpp.core.client.AbstractSessionObject;
import tigase.jaxmpp.core.client.MockSessionObject;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.eventbus.DefaultEventBus;
import tigase.jaxmpp.core.client.eventbus.EventBus;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;

public class SessionObjectTest {
    protected AbstractSessionObject sessionObject;

    @Before
    public void setUp() throws Exception {
        DefaultEventBus eventBus = new DefaultEventBus();
        this.sessionObject = new MockSessionObject((EventBus)eventBus);
    }

    @Test
    public void testReset1() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "u", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "se", (Object)"value2");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "st", (Object)"value3");
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("st"));
        try {
            this.sessionObject.clear();
        }
        catch (JaxmppException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNull((Object)this.sessionObject.getProperty("st"));
    }

    @Test
    public void testReset1_1() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "u", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "se", (Object)"value2");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "st", (Object)"value3");
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("st"));
        try {
            this.sessionObject.clear((SessionObject.Scope[])null);
        }
        catch (JaxmppException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNull((Object)this.sessionObject.getProperty("st"));
    }

    @Test
    public void testReset1_2() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "u", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "se", (Object)"value2");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "st", (Object)"value3");
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("st"));
        try {
            this.sessionObject.clear((Set)null);
        }
        catch (JaxmppException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNull((Object)this.sessionObject.getProperty("st"));
    }

    @Test
    public void testReset2() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "u", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "se", (Object)"value2");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "st", (Object)"value3");
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("st"));
        try {
            this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.stream});
        }
        catch (JaxmppException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNull((Object)this.sessionObject.getProperty("st"));
    }

    @Test
    public void testReset3() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "u", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "se", (Object)"value2");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "st", (Object)"value3");
        Assert.assertNotNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("st"));
        try {
            this.sessionObject.clear(new SessionObject.Scope[]{SessionObject.Scope.stream, SessionObject.Scope.user});
        }
        catch (JaxmppException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNull((Object)this.sessionObject.getProperty("u"));
        Assert.assertNotNull((Object)this.sessionObject.getProperty("se"));
        Assert.assertNull((Object)this.sessionObject.getProperty("st"));
    }

    @Test
    public void testSetPropertyScopeStringObject() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "default-key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.sessionObject.getProperty("default-key1"));
        Assert.assertEquals((Object)"value1", (Object)this.sessionObject.getProperty(SessionObject.Scope.user, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty(SessionObject.Scope.session, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty("default-key2"));
    }

    @Test
    public void testSetPropertyScopeStringObject_1() {
        this.sessionObject.setProperty(SessionObject.Scope.user, "default-key1", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.session, "default-key1", (Object)"value1");
        this.sessionObject.setProperty(SessionObject.Scope.stream, "default-key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.sessionObject.getProperty(SessionObject.Scope.stream, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty(SessionObject.Scope.session, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty(SessionObject.Scope.user, "default-key1"));
    }

    @Test
    public void testSetPropertyStringObject() {
        this.sessionObject.setProperty("default-key1", (Object)"value1");
        this.sessionObject.setProperty("default-key2", (Object)"value2");
        Assert.assertEquals((Object)"value1", (Object)this.sessionObject.getProperty("default-key1"));
        Assert.assertEquals((Object)"value1", (Object)this.sessionObject.getProperty(SessionObject.Scope.session, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty(SessionObject.Scope.user, "default-key1"));
        Assert.assertNull((Object)this.sessionObject.getProperty("default-key3"));
        Assert.assertEquals((Object)"value2", (Object)this.sessionObject.getProperty("default-key2"));
        this.sessionObject.setProperty("default-key1", null);
        Assert.assertNull((Object)this.sessionObject.getProperty("default-key1"));
    }
}

