/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client;

import junit.framework.TestCase;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.JID;

public class JIDTest
extends TestCase {
    public void testGetBareJid() {
        JID jid = JID.jidInstance((String)"a@b/c");
        JIDTest.assertEquals((Object)BareJID.bareJIDInstance((String)"a", (String)"b"), (Object)jid.getBareJid());
    }

    public void testGetDomain() {
        JID jid = JID.jidInstance((String)"a@b/c");
        JIDTest.assertEquals((String)"b", (String)jid.getDomain());
    }

    public void testGetLocalpart() {
        JID jid = JID.jidInstance((String)"a@b/c");
        JIDTest.assertEquals((String)"a", (String)jid.getLocalpart());
    }

    public void testGetResource() {
        JID jid = JID.jidInstance((String)"a@b/c");
        JIDTest.assertEquals((String)"c", (String)jid.getResource());
    }

    public void testJIDInstance() {
        JIDTest.assertEquals((Object)JID.jidInstance((String)"a@b"), (Object)JID.jidInstance((String)"a@b"));
        JIDTest.assertEquals((Object)JID.jidInstance((String)"a@b"), (Object)JID.jidInstance((String)"a", (String)"b"));
        JIDTest.assertEquals((Object)JID.jidInstance((String)"a", (String)"b"), (Object)JID.jidInstance((String)"a", (String)"b"));
        JIDTest.assertEquals((Object)JID.jidInstance((String)"a@b/c"), (Object)JID.jidInstance((String)"a@b/c"));
        JIDTest.assertEquals((Object)JID.jidInstance((String)"a", (String)"b", (String)"c"), (Object)JID.jidInstance((String)"a@b/c"));
        JIDTest.assertFalse((boolean)JID.jidInstance((String)"a@b").equals((Object)JID.jidInstance((String)"a@b/c")));
    }

    public void testPercentJids() {
        JID jid = JID.jidInstance((String)"-101100311719181%chat.facebook.com@domain.com");
        JIDTest.assertEquals((String)"domain.com", (String)jid.getDomain());
        JIDTest.assertEquals((String)"-101100311719181%chat.facebook.com", (String)jid.getLocalpart());
        JIDTest.assertNull((Object)jid.getResource());
        JIDTest.assertEquals((String)"-101100311719181%chat.facebook.com@domain.com", (String)jid.toString());
    }

    public void testToString() {
        JID jid = JID.jidInstance((String)"a@b");
        JIDTest.assertEquals((String)"a@b", (String)jid.toString());
        jid = JID.jidInstance((String)"a@b/c");
        JIDTest.assertEquals((String)"a@b/c", (String)jid.toString());
    }
}

