/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.xmpp.forms;

import org.junit.Assert;
import org.junit.Test;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.ElementBuilder;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.forms.BooleanField;
import tigase.jaxmpp.core.client.xmpp.forms.FixedField;
import tigase.jaxmpp.core.client.xmpp.forms.HiddenField;
import tigase.jaxmpp.core.client.xmpp.forms.JabberDataElement;
import tigase.jaxmpp.core.client.xmpp.forms.JidMultiField;
import tigase.jaxmpp.core.client.xmpp.forms.JidSingleField;
import tigase.jaxmpp.core.client.xmpp.forms.ListMultiField;
import tigase.jaxmpp.core.client.xmpp.forms.ListSingleField;
import tigase.jaxmpp.core.client.xmpp.forms.TextMultiField;
import tigase.jaxmpp.core.client.xmpp.forms.TextPrivateField;
import tigase.jaxmpp.core.client.xmpp.forms.TextSingleField;
import tigase.jaxmpp.core.client.xmpp.forms.XDataType;

public class JabberDataElementTest {
    @Test
    public void testCreate01() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        ElementBuilder expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
        x.addFORM_TYPE("jabber:bot");
        expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form").child("field").setAttribute("var", "FORM_TYPE").setAttribute("type", "hidden").setValue("jabber:bot");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
    }

    @Test
    public void testCreate02() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        ElementBuilder expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
        x.addFORM_TYPE("jabber:bot");
        expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form").child("field").setAttribute("var", "FORM_TYPE").setAttribute("type", "hidden").setValue("jabber:bot");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
        x.setInstructions("in");
        expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form").child("field").setAttribute("var", "FORM_TYPE").setAttribute("type", "hidden").setValue("jabber:bot").up().child("instructions").setValue("in");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
        x.setTitle("tt");
        expected = ElementBuilder.create((String)"x").setXMLNS("jabber:x:data").setAttribute("type", "form").child("field").setAttribute("var", "FORM_TYPE").setAttribute("type", "hidden").setValue("jabber:bot").up().child("instructions").setValue("in").up().child("title").setValue("tt");
        Assert.assertEquals((Object)expected.getElement(), (Object)x);
    }

    @Test
    public void testFieldBoolean01() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        BooleanField field = x.addBooleanField("public", Boolean.valueOf(true));
        Assert.assertEquals((Object)"boolean", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"boolean", (Object)field.getType());
        ElementBuilder expected = ElementBuilder.create((String)"field").setAttribute("type", "boolean").setAttribute("var", "public").child("value").setValue("1");
        Assert.assertEquals((Object)expected.getElement(), (Object)field);
    }

    @Test
    public void testFieldFixed() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        FixedField field = x.addFixedField("tralala");
        Assert.assertEquals((Object)"fixed", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"fixed", (Object)field.getType());
    }

    @Test
    public void testFieldHidden() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        HiddenField field = x.addHiddenField("public", "maybe");
        Assert.assertEquals((Object)"hidden", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"hidden", (Object)field.getType());
    }

    @Test
    public void testFieldJidMulti() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        JidMultiField field = x.addJidMultiField("jids", new JID[]{JID.jidInstance((String)"a@b"), JID.jidInstance((String)"b@c")});
        Assert.assertEquals((Object)"jid-multi", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"jid-multi", (Object)field.getType());
    }

    @Test
    public void testFieldJidSingle() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        JidSingleField field = x.addJidSingleField("jid", JID.jidInstance((String)"a@b"));
        Assert.assertEquals((Object)"jid-single", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"jid-single", (Object)field.getType());
    }

    @Test
    public void testFieldListMulti() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        ListMultiField field = x.addListMultiField("public", new String[]{"1", "2"});
        Assert.assertEquals((Object)"list-multi", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"list-multi", (Object)field.getType());
    }

    @Test
    public void testFieldListSingle() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        ListSingleField field = x.addListSingleField("public", "1");
        Assert.assertEquals((Object)"list-single", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"list-single", (Object)field.getType());
    }

    @Test
    public void testFieldTextMulti() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        TextMultiField field = x.addTextMultiField("public", new String[]{"1", "2", "3"});
        Assert.assertEquals((Object)"text-multi", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"text-multi", (Object)field.getType());
    }

    @Test
    public void testFieldTextPrivate() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        TextPrivateField field = x.addTextPrivateField("public", "test");
        Assert.assertEquals((Object)"text-private", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"text-private", (Object)field.getType());
    }

    @Test
    public void testFieldTextSingle() throws XMLException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        TextSingleField field = x.addTextSingleField("public", "once");
        Assert.assertEquals((Object)"text-single", (Object)field.getAttribute("type"));
        Assert.assertEquals((Object)"text-single", (Object)field.getType());
    }

    @Test
    public void testReplacingField() throws JaxmppException {
        JabberDataElement x = new JabberDataElement(XDataType.form);
        x.addTextSingleField("public", "1");
        x.addTextSingleField("public", "2");
        x.addTextPrivateField("public", "3");
        System.out.println(x.createSubmitableElement(XDataType.submit).getAsString());
        Assert.assertTrue((boolean)(x.getField("public") instanceof TextPrivateField));
        Assert.assertEquals((Object)"3", (Object)((TextPrivateField)x.getField("public")).getFieldValue());
    }
}

