/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.core.client.criteria.tpath;

import org.junit.Assert;
import org.junit.Test;
import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.criteria.tpath.TPath;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xmpp.stanzas.IQ;
import tigase.jaxmpp.core.client.xmpp.stanzas.StanzaType;

public class TPathTest {
    private final IQ iq;
    private final TPath tpath = new TPath();

    public TPathTest() throws JaxmppException {
        this.iq = IQ.create();
        this.iq.setTo(JID.jidInstance((String)"a@b.c"));
        this.iq.setType(StanzaType.set);
        this.iq.setAttribute("from", "wojtas@wp.pl");
        Element pubsub = ElementFactory.create((String)"pubsub", null, (String)"a:b");
        this.iq.addChild(pubsub);
        Element publish = ElementFactory.create((String)"publish");
        publish.setAttribute("node", "123");
        pubsub.addChild(publish);
        Element item = ElementFactory.create((String)"item");
        item.setValue("x");
        item.setAttribute("id", "345");
        publish.addChild(item);
        item = ElementFactory.create((String)"item");
        item.setAttribute("id", "456");
        publish.addChild(item);
        item = ElementFactory.create((String)"item");
        item.setAttribute("id", "567");
        publish.addChild(item);
    }

    @Test
    public void testEvaluate() {
        try {
            Assert.assertEquals((Object)"set", this.tpath.compile("/*/attr('type')").evaluateAsArray((Element)this.iq).get(0));
            Assert.assertEquals((Object)"wojtas@wp.pl", this.tpath.compile("/*/attr('from')").evaluateAsArray((Element)this.iq).get(0));
            Assert.assertTrue((boolean)this.tpath.compile("/x/").evaluateAsArray((Element)this.iq).isEmpty());
            Assert.assertArrayEquals((Object[])new String[]{"345", "456", "567"}, (Object[])this.tpath.compile("/*[@type='set']/pubsub/publish/item/attr('id')").evaluateAsArray((Element)this.iq).toArray(new String[0]));
            Assert.assertArrayEquals((Object[])new String[]{"x"}, (Object[])this.tpath.compile("/*[@type='set']/pubsub/publish/item/value()").evaluateAsArray((Element)this.iq).toArray(new String[0]));
            Assert.assertEquals((Object)"x", (Object)this.tpath.compile("/*[@type='set']/pubsub/publish/item/value()").evaluate((Element)this.iq));
            Assert.assertNull((Object)this.tpath.compile("/*[@type='get']/pubsub/publish/item/value()").evaluate((Element)this.iq));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

