/*
 * Tigase XMPP Client Library
 * Copyright (C) 2004-2013 "Tigase, Inc." <office@tigase.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.jaxmpp.core.client.xmpp.modules.filetransfer;

import java.util.List;

import tigase.jaxmpp.core.client.JID;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.observer.EventType;

public class FileTransferRequestEvent extends FileTransferEvent {

	private final String id;
	private final List<String> streamMethods;

	public FileTransferRequestEvent(EventType type, SessionObject sessionObject, FileTransfer ft, String id, List<String> streamMethods) {
		super(type, sessionObject, ft);

                this.id = id;
		this.streamMethods = streamMethods;
	}

	public String getId() {
		return id;
	}

	public List<String> getStreamMethods() {
		return streamMethods;
	}
	
}
