/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.excutor.Executor;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestsManager;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.StanzaKtKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0013J\u0018\u0010\u001b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0019H\u0002J\u0016\u0010!\u001a\u00020\u00132\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010J\u0010\u0010#\u001a\u00020\u00132\b\b\u0002\u0010$\u001a\u00020%J \u0010&\u001a\u00020\u00172\u000e\u0010'\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\r\u001a.\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000ej\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltigase/halcyon/core/requests/RequestsManager;", "", "()V", "boundJID", "Ltigase/halcyon/core/xmpp/FullJID;", "getBoundJID", "()Ltigase/halcyon/core/xmpp/FullJID;", "setBoundJID", "(Ltigase/halcyon/core/xmpp/FullJID;)V", "executor", "Ltigase/halcyon/core/excutor/Executor;", "log", "Ltigase/halcyon/core/logger/Logger;", "requests", "Ljava/util/HashMap;", "", "Ltigase/halcyon/core/requests/Request;", "Lkotlin/collections/HashMap;", "execute", "", "runnable", "Lkotlin/Function0;", "findAndExecute", "", "response", "Ltigase/halcyon/core/xml/Element;", "findOutdated", "getRequest", "getRequestsIDs", "getWaitingRequestsSize", "", "key", "element", "register", "request", "timeoutAll", "maxCreationTimestamp", "Lkotlinx/datetime/Instant;", "verify", "entry", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nRequestsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n766#2:113\n857#2,2:114\n1855#2,2:116\n766#2:118\n857#2,2:119\n1855#2,2:121\n1549#2:123\n1620#2,3:124\n*S KotlinDebug\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n*L\n86#1:113\n86#1:114,2\n88#1:116,2\n98#1:118\n98#1:119,2\n101#1:121,2\n110#1:123\n110#1:124,3\n*E\n"})
public final class RequestsManager {
    @NotNull
    private final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.requests.RequestsManager", false, 2, null);
    @NotNull
    private final Executor executor = new Executor();
    @NotNull
    private final HashMap<String, Request<?, ?>> requests = new HashMap();
    @Nullable
    private FullJID boundJID;

    public final void register(@NotNull Request<?, ?> request2) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        ((Map)this.requests).put(this.key((Element)request2.getStanza()), request2);
    }

    @Nullable
    public final FullJID getBoundJID() {
        return this.boundJID;
    }

    public final void setBoundJID(@Nullable FullJID fullJID) {
        this.boundJID = fullJID;
    }

    private final String key(Element element2) {
        return element2.getName() + ":" + element2.getAttributes().get("id");
    }

    @Nullable
    public final Request<?, ?> getRequest(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String id = this.key(response);
        Request<?, ?> request2 = this.requests.get(id);
        if (request2 == null) {
            return null;
        }
        Request<?, ?> request3 = request2;
        if (this.verify(request3, response)) {
            this.requests.remove(id);
            return request3;
        }
        return null;
    }

    private final boolean verify(Request<?, ?> entry, Element response) {
        BareJID bareBoundJID;
        FullJID jid = StanzaKtKt.getFromAttr(response);
        FullJID fullJID = this.boundJID;
        BareJID bareJID = bareBoundJID = fullJID != null ? fullJID.getBareJID() : null;
        if (Intrinsics.areEqual((Object)jid, (Object)entry.getJid())) {
            return true;
        }
        if (entry.getJid() == null && bareBoundJID != null) {
            FullJID fullJID2 = jid;
            if (Intrinsics.areEqual((Object)(fullJID2 != null ? fullJID2.getBareJID() : null), (Object)bareBoundJID)) {
                return true;
            }
        }
        return false;
    }

    public final boolean findAndExecute(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Request<?, ?> request2 = this.getRequest(response);
        if (request2 == null) {
            return false;
        }
        Request<?, ?> r = request2;
        this.execute((Function0<Unit>)((Function0)new Function0<Unit>(r, response){
            final /* synthetic */ Request<?, ?> $r;
            final /* synthetic */ Element $response;
            {
                this.$r = $r;
                this.$response = $response;
                super(0);
            }

            public final void invoke() {
                Request.setResponseStanza$default(this.$r, this.$response, false, 2, null);
            }
        }));
        return true;
    }

    private final void execute(Function0<Unit> runnable) {
        this.executor.execute((Function0<Unit>)((Function0)new Function0<Unit>(runnable, this){
            final /* synthetic */ Function0<Unit> $runnable;
            final /* synthetic */ RequestsManager this$0;
            {
                this.$runnable = $runnable;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$runnable.invoke();
                }
                catch (Throwable e) {
                    RequestsManager.access$getLog$p(this.this$0).warning(e, (Function0<? extends Object>)((Function0)execute.1.INSTANCE));
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void timeoutAll(@NotNull Instant maxCreationTimestamp) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)maxCreationTimestamp, (String)"maxCreationTimestamp");
        Logger.DefaultImpls.info$default(this.log, null, timeoutAll.1.INSTANCE, 1, null);
        Set<Map.Entry<String, Request<?, ?>>> set = this.requests.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"requests.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((Request)it.getValue()).getCreationTimestamp().compareTo(maxCreationTimestamp) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.requests.remove(it.getKey());
            if (((Request)it.getValue()).isCompleted()) continue;
            this.execute((Function0<Unit>)((Function0)new Function0<Unit>(it){
                final /* synthetic */ Map.Entry<String, Request<?, ?>> $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Request<?, ?> request2 = this.$it.getValue();
                    Intrinsics.checkNotNullExpressionValue(request2, (String)"it.value");
                    Request.markTimeout$halcyon_core$default(request2, false, 1, null);
                }
            }));
        }
    }

    public static /* synthetic */ void timeoutAll$default(RequestsManager requestsManager, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Instant.Companion.getDISTANT_FUTURE();
        }
        requestsManager.timeoutAll(instant);
    }

    /*
     * WARNING - void declaration
     */
    public final void findOutdated() {
        void $this$filterTo$iv$iv;
        Instant now = Clock.System.INSTANCE.now();
        Set<Map.Entry<String, Request<?, ?>>> set = this.requests.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"requests.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((Request)it.getValue()).isCompleted() || ((Request)it.getValue()).getCreationTimestamp().plus-LRDsOJo(((Request)it.getValue()).getTimeoutDelay-UwyO8pc()).compareTo(now) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, request)");
            String key = (String)entry.getKey();
            Request request2 = (Request)entry.getValue();
            this.requests.remove(key);
            if (request2.getCreationTimestamp().plus-LRDsOJo(request2.getTimeoutDelay-UwyO8pc()).compareTo(now) > 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"request");
            this.execute((Function0<Unit>)((Function0)new Function0<Unit>((Object)request2){

                public final void invoke() {
                    Request request2 = (Request)findOutdated.1.1.access$getReceiver$p(this);
                    Intrinsics.checkNotNullExpressionValue((Object)request2, (String)"request::markTimeout");
                    Request.markTimeout$halcyon_core$default(request2, false, 1, null);
                }

                public static final /* synthetic */ Object access$getReceiver$p(findOutdated.1.1 $this) {
                    return $this.receiver;
                }
            }));
        }
    }

    public final int getWaitingRequestsSize() {
        return this.requests.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRequestsIDs() {
        void $this$mapTo$iv$iv;
        Collection<Request<?, ?>> collection = this.requests.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"requests.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Request request2 = (Request)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getId());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)getRequestsIDs.2.INSTANCE, (int)31, null);
    }

    public static final /* synthetic */ Logger access$getLog$p(RequestsManager $this) {
        return $this.log;
    }
}

