/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.logger.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.LoggerInternal;
import tigase.halcyon.core.logger.internal.LoggerSPIBuffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Ltigase/halcyon/core/logger/internal/LoggerSPIBuffer;", "", "bufferSize", "", "(I)V", "buffer", "", "Ltigase/halcyon/core/logger/internal/LoggerSPIBuffer$Entry;", "getBufferSize", "()I", "callback", "Lkotlin/Function1;", "", "getCallback", "()Lkotlin/jvm/functions/Function1;", "setCallback", "(Lkotlin/jvm/functions/Function1;)V", "spiFactory", "Lkotlin/Function2;", "", "", "Ltigase/halcyon/core/logger/LoggerInternal;", "getSpiFactory", "()Lkotlin/jvm/functions/Function2;", "setSpiFactory", "(Lkotlin/jvm/functions/Function2;)V", "add", "entry", "create", "name", "enabled", "getBuffer", "", "Entry", "halcyon-core"})
public final class LoggerSPIBuffer {
    private final int bufferSize;
    @NotNull
    private Function2<? super String, ? super Boolean, ? extends LoggerInternal> spiFactory;
    @NotNull
    private final List<Entry> buffer;
    @Nullable
    private Function1<? super Entry, Unit> callback;

    public LoggerSPIBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.spiFactory = spiFactory.1.INSTANCE;
        this.buffer = new ArrayList();
    }

    public /* synthetic */ LoggerSPIBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @NotNull
    public final Function2<String, Boolean, LoggerInternal> getSpiFactory() {
        return this.spiFactory;
    }

    public final void setSpiFactory(@NotNull Function2<? super String, ? super Boolean, ? extends LoggerInternal> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.spiFactory = function2;
    }

    @Nullable
    public final Function1<Entry, Unit> getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable Function1<? super Entry, Unit> function1) {
        this.callback = function1;
    }

    private final void add(Entry entry) {
        block1: {
            this.buffer.add(entry);
            if (this.buffer.size() > this.bufferSize) {
                this.buffer.remove(0);
            }
            Function1<? super Entry, Unit> function1 = this.callback;
            if (function1 == null) break block1;
            function1.invoke((Object)entry);
        }
    }

    @NotNull
    public final List<Entry> getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final LoggerInternal create(@NotNull String name2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        LoggerInternal spi = (LoggerInternal)this.spiFactory.invoke((Object)name2, (Object)enabled);
        return new LoggerInternal(spi, this, name2){
            final /* synthetic */ LoggerInternal $spi;
            final /* synthetic */ LoggerSPIBuffer this$0;
            final /* synthetic */ String $name;
            {
                this.$spi = $spi;
                this.this$0 = $receiver;
                this.$name = $name;
            }

            public boolean isLoggable(@NotNull Level level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                return this.$spi.isLoggable(level);
            }

            public void log(@NotNull Level level, @NotNull String msg2, @Nullable Throwable caught) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
                LoggerSPIBuffer.access$add(this.this$0, new Entry(Clock.System.INSTANCE.now(), level, this.$name, msg2, caught));
                this.$spi.log(level, msg2, caught);
            }
        };
    }

    public LoggerSPIBuffer() {
        this(0, 1, null);
    }

    public static final /* synthetic */ void access$add(LoggerSPIBuffer $this, Entry entry) {
        $this.add(entry);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Ltigase/halcyon/core/logger/internal/LoggerSPIBuffer$Entry;", "", "timestamp", "Lkotlinx/datetime/Instant;", "level", "Ltigase/halcyon/core/logger/Level;", "loggerName", "", "msg", "caught", "", "(Lkotlinx/datetime/Instant;Ltigase/halcyon/core/logger/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCaught", "()Ljava/lang/Throwable;", "getLevel", "()Ltigase/halcyon/core/logger/Level;", "getLoggerName", "()Ljava/lang/String;", "getMsg", "getTimestamp", "()Lkotlinx/datetime/Instant;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "halcyon-core"})
    public static final class Entry {
        @NotNull
        private final Instant timestamp;
        @NotNull
        private final Level level;
        @NotNull
        private final String loggerName;
        @NotNull
        private final String msg;
        @Nullable
        private final Throwable caught;

        public Entry(@NotNull Instant timestamp2, @NotNull Level level, @NotNull String loggerName, @NotNull String msg2, @Nullable Throwable caught) {
            Intrinsics.checkNotNullParameter((Object)timestamp2, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.timestamp = timestamp2;
            this.level = level;
            this.loggerName = loggerName;
            this.msg = msg2;
            this.caught = caught;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @NotNull
        public final String getLoggerName() {
            return this.loggerName;
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        @Nullable
        public final Throwable getCaught() {
            return this.caught;
        }

        @NotNull
        public final Instant component1() {
            return this.timestamp;
        }

        @NotNull
        public final Level component2() {
            return this.level;
        }

        @NotNull
        public final String component3() {
            return this.loggerName;
        }

        @NotNull
        public final String component4() {
            return this.msg;
        }

        @Nullable
        public final Throwable component5() {
            return this.caught;
        }

        @NotNull
        public final Entry copy(@NotNull Instant timestamp2, @NotNull Level level, @NotNull String loggerName, @NotNull String msg2, @Nullable Throwable caught) {
            Intrinsics.checkNotNullParameter((Object)timestamp2, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            return new Entry(timestamp2, level, loggerName, msg2, caught);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Instant instant, Level level, String string, String string2, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                instant = entry.timestamp;
            }
            if ((n & 2) != 0) {
                level = entry.level;
            }
            if ((n & 4) != 0) {
                string = entry.loggerName;
            }
            if ((n & 8) != 0) {
                string2 = entry.msg;
            }
            if ((n & 0x10) != 0) {
                throwable = entry.caught;
            }
            return entry.copy(instant, level, string, string2, throwable);
        }

        @NotNull
        public String toString() {
            return "Entry(timestamp=" + this.timestamp + ", level=" + this.level + ", loggerName=" + this.loggerName + ", msg=" + this.msg + ", caught=" + this.caught + ")";
        }

        public int hashCode() {
            int result = this.timestamp.hashCode();
            result = result * 31 + this.level.hashCode();
            result = result * 31 + this.loggerName.hashCode();
            result = result * 31 + this.msg.hashCode();
            result = result * 31 + (this.caught == null ? 0 : this.caught.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.timestamp, (Object)entry.timestamp)) {
                return false;
            }
            if (this.level != entry.level) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.loggerName, (Object)entry.loggerName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.msg, (Object)entry.msg)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.caught, (Object)entry.caught);
        }
    }
}

