/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.ChannelBindingDataProvider;
import tigase.halcyon.core.connector.socket.DefaultTLSProcessor;
import tigase.halcyon.core.connector.socket.DefaultTLSProcessorKt;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessor;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.connector.socket.XMPPHostnameVerifier;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J&\u0010\u001b\u001a\u00020\u00132\u001c\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00130\u001dj\u0002` H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltigase/halcyon/core/connector/socket/DefaultTLSProcessor;", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "Ltigase/halcyon/core/connector/ChannelBindingDataProvider;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "(Ljava/net/Socket;Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;)V", "lock", "Ljava/lang/Object;", "log", "Ltigase/halcyon/core/logger/Logger;", "peerCertificates", "", "Ljava/security/cert/Certificate;", "[Ljava/security/cert/Certificate;", "secured", "", "clear", "", "getSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getTlsExporter", "", "getTlsServerEndpoint", "getTlsUnique", "isConnectionSecure", "proceedTLS", "callback", "Lkotlin/Function2;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "Ltigase/halcyon/core/connector/socket/TLSCallback;", "Companion", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nDefaultTLSProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTLSProcessor.kt\ntigase/halcyon/core/connector/socket/DefaultTLSProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,120:1\n1#2:121\n26#3:122\n*S KotlinDebug\n*F\n+ 1 DefaultTLSProcessor.kt\ntigase/halcyon/core/connector/socket/DefaultTLSProcessor\n*L\n63#1:122\n*E\n"})
public final class DefaultTLSProcessor
implements TLSProcessor,
ChannelBindingDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Socket socket;
    @NotNull
    private final SocketConnectorConfig config;
    @NotNull
    private final Logger log;
    private boolean secured;
    @Nullable
    private Certificate[] peerCertificates;
    @NotNull
    private final Object lock;
    @NotNull
    private static final String NAME = "DefaultTLSProcessor";

    public DefaultTLSProcessor(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.socket = socket;
        this.config = config;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.JavaXTLSProcessor", false, 2, null);
        this.lock = new Object();
    }

    @Override
    public boolean isConnectionSecure() {
        return this.secured;
    }

    @Override
    @Nullable
    public byte[] getTlsUnique() {
        return null;
    }

    @Override
    @Nullable
    public byte[] getTlsServerEndpoint() {
        byte[] byArray;
        Object object = this.peerCertificates;
        if (this.peerCertificates != null && (object = (Certificate)ArraysKt.first((Object[])object)) != null) {
            Object it = object;
            boolean bl = false;
            byArray = DefaultTLSProcessorKt.calculateCertificateHash((X509Certificate)it);
        } else {
            byArray = null;
        }
        return byArray;
    }

    @Override
    @Nullable
    public byte[] getTlsExporter() {
        return null;
    }

    @Override
    public void clear() {
        this.secured = false;
        this.peerCertificates = null;
    }

    private final SSLSocketFactory getSocketFactory() {
        SSLContext ctx = SSLContext.getInstance("TLS");
        boolean $i$f$emptyArray = false;
        TrustManager[] trustManagerArray = new TrustManager[]{this.config.getTrustManager()};
        ctx.init(new KeyManager[0], trustManagerArray, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = ctx.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"ctx.socketFactory");
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proceedTLS(@NotNull Function2<? super InputStream, ? super OutputStream, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        SSLSocketFactory factory = this.getSocketFactory();
        Socket socket = factory.createSocket(this.socket, this.config.getHostname(), this.socket.getPort(), true);
        Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket s1 = (SSLSocket)socket;
        s1.setSoTimeout(0);
        s1.setKeepAlive(false);
        s1.setTcpNoDelay(true);
        s1.setUseClientMode(true);
        s1.addHandshakeCompletedListener(arg_0 -> DefaultTLSProcessor.proceedTLS$lambda$2(this, arg_0));
        s1.startHandshake();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.secured) {
                this.lock.wait(100L);
            }
            Unit unit = Unit.INSTANCE;
        }
        Logger.DefaultImpls.info$default(this.log, null, proceedTLS.3.INSTANCE, 1, null);
        XMPPHostnameVerifier xMPPHostnameVerifier = this.config.getHostnameVerifier();
        String string = this.config.getDomain();
        Intrinsics.checkNotNull((Object)this.peerCertificates);
        if (!xMPPHostnameVerifier.verify(string, (Certificate)ArraysKt.first((Object[])this.peerCertificates))) {
            throw new SSLHandshakeException("Certificate hostname doesn't match domain name you want to connect.");
        }
        InputStream inputStream = s1.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"s1.inputStream");
        OutputStream outputStream = s1.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"s1.outputStream");
        callback.invoke((Object)inputStream, (Object)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void proceedTLS$lambda$2(DefaultTLSProcessor this$0, HandshakeCompletedEvent handshakeCompletedEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.DefaultImpls.info$default(this$0.log, null, (Function0)new Function0<Object>(handshakeCompletedEvent){
            final /* synthetic */ HandshakeCompletedEvent $handshakeCompletedEvent;
            {
                this.$handshakeCompletedEvent = $handshakeCompletedEvent;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Handshake completed " + this.$handshakeCompletedEvent;
            }
        }, 1, null);
        this$0.peerCertificates = handshakeCompletedEvent.getSession().getPeerCertificates();
        this$0.secured = true;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.lock.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Ltigase/halcyon/core/connector/socket/DefaultTLSProcessor$Companion;", "Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "create", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "halcyon-core"})
    public static final class Companion
    implements TLSProcessorFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public String getNAME() {
            return NAME;
        }

        @Override
        @NotNull
        public TLSProcessor create(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new DefaultTLSProcessor(socket, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

