/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.muc;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.TimestampKt;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.modules.Criteria;
import tigase.halcyon.core.modules.Criterion;
import tigase.halcyon.core.modules.HalcyonModule;
import tigase.halcyon.core.modules.HalcyonModuleProvider;
import tigase.halcyon.core.modules.ModulesManager;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.modules.XmppModuleProvider;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestBuilder;
import tigase.halcyon.core.requests.RequestBuilderFactory;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.ErrorConditionKt;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.JID;
import tigase.halcyon.core.xmpp.JIDKt;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.forms.JabberDataForm;
import tigase.halcyon.core.xmpp.modules.PingModule;
import tigase.halcyon.core.xmpp.modules.mix.MIXModuleKt;
import tigase.halcyon.core.xmpp.modules.muc.Affiliation;
import tigase.halcyon.core.xmpp.modules.muc.DefaultMUCStore;
import tigase.halcyon.core.xmpp.modules.muc.Invitation;
import tigase.halcyon.core.xmpp.modules.muc.MUCModule;
import tigase.halcyon.core.xmpp.modules.muc.MUCModuleConfig;
import tigase.halcyon.core.xmpp.modules.muc.MUCStore;
import tigase.halcyon.core.xmpp.modules.muc.MucEvents;
import tigase.halcyon.core.xmpp.modules.muc.MucRoomEvents;
import tigase.halcyon.core.xmpp.modules.muc.MucUserExt;
import tigase.halcyon.core.xmpp.modules.muc.Occupant;
import tigase.halcyon.core.xmpp.modules.muc.Role;
import tigase.halcyon.core.xmpp.modules.muc.Room;
import tigase.halcyon.core.xmpp.modules.muc.RoomAffiliation;
import tigase.halcyon.core.xmpp.modules.muc.State;
import tigase.halcyon.core.xmpp.stanzas.IQ;
import tigase.halcyon.core.xmpp.stanzas.IQNode;
import tigase.halcyon.core.xmpp.stanzas.IQType;
import tigase.halcyon.core.xmpp.stanzas.Message;
import tigase.halcyon.core.xmpp.stanzas.MessageNode;
import tigase.halcyon.core.xmpp.stanzas.MessageType;
import tigase.halcyon.core.xmpp.stanzas.Presence;
import tigase.halcyon.core.xmpp.stanzas.PresenceNode;
import tigase.halcyon.core.xmpp.stanzas.PresenceType;
import tigase.halcyon.core.xmpp.stanzas.Stanza_buildersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0002QRB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000eJ\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'H\u0002J&\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.J.\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u0002012\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000eJ.\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u00100\u001a\u0002012\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000eJ\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000201H\u0002J.\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u00106\u001a\u0002012\u0006\u0010!\u001a\u00020\u000e2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000eJ\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010-\u001a\u00020.J\"\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010:\u001a\u00020\u000eJ\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.J\u0010\u0010=\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020)H\u0002J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020)H\u0002J\u0010\u0010A\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020)H\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020)H\u0002J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u001eH\u0002J,\u0010D\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020F0E\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HJ\u001a\u0010I\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.J(\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020F0EJ\"\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020,0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010N\u001a\u00020JJ$\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020)0\u001c2\u0006\u0010-\u001a\u00020.2\b\u0010P\u001a\u0004\u0018\u00010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006S"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule;", "Ltigase/halcyon/core/modules/XmppModule;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModuleConfig;", "context", "Ltigase/halcyon/core/Context;", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "criteria", "Ltigase/halcyon/core/modules/Criteria;", "getCriteria", "()Ltigase/halcyon/core/modules/Criteria;", "features", "", "", "getFeatures", "()[Ljava/lang/String;", "[Ljava/lang/String;", "store", "Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;", "getStore", "()Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;", "setStore", "(Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;)V", "type", "getType", "()Ljava/lang/String;", "accept", "Ltigase/halcyon/core/requests/RequestBuilder;", "", "Ltigase/halcyon/core/xmpp/stanzas/Presence;", "invitation", "Ltigase/halcyon/core/xmpp/modules/muc/Invitation;", "nickname", "calculateAction", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Action;", "element", "Ltigase/halcyon/core/xml/Element;", "checkRoomStore", "", "decline", "Ltigase/halcyon/core/xmpp/stanzas/Message;", "reason", "destroy", "Ltigase/halcyon/core/xmpp/stanzas/IQ;", "room", "Ltigase/halcyon/core/xmpp/modules/muc/Room;", "invite", "invitedJid", "Ltigase/halcyon/core/xmpp/BareJID;", "inviteDirectly", "isFromKnownMUCRoom", "jid", "join", "roomJID", "password", "leave", "message", "messageBody", "ping", "Ltigase/halcyon/core/xmpp/modules/PingModule$Pong;", "process", "processDirectInvitationMessage", "stanza", "processInvitationDeclinedMessage", "processMediatedInvitationMessage", "processMessage", "processPresence", "retrieveAffiliations", "", "Ltigase/halcyon/core/xmpp/modules/muc/RoomAffiliation;", "filter", "Ltigase/halcyon/core/xmpp/modules/muc/Affiliation;", "retrieveRoomConfig", "Ltigase/halcyon/core/xmpp/forms/JabberDataForm;", "updateAffiliations", "affiliations", "updateRoomConfig", "form", "updateRoomSubject", "subject", "Action", "Companion", "halcyon-core"})
public final class MUCModule
implements XmppModule,
MUCModuleConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String type;
    @NotNull
    private final Criteria criteria;
    @Nullable
    private final String[] features;
    @NotNull
    private MUCStore store;
    @NotNull
    public static final String XMLNS = "http://jabber.org/protocol/muc";
    @NotNull
    private static final String TYPE = "MUCModule";

    public MUCModule(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.type = TYPE;
        this.criteria = Criterion.Companion.element((Function1<? super Element, Boolean>)((Function1)new Function1<Element, Boolean>(this){
            final /* synthetic */ MUCModule this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                return MUCModule.calculateAction$default(this.this$0, element2, false, 2, null) != Action.Skip;
            }
        }));
        this.store = new DefaultMUCStore();
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        return this.features;
    }

    @NotNull
    public final MUCStore getStore() {
        return this.store;
    }

    public final void setStore(@NotNull MUCStore mUCStore) {
        Intrinsics.checkNotNullParameter((Object)mUCStore, (String)"<set-?>");
        this.store = mUCStore;
    }

    private final boolean isFromKnownMUCRoom(BareJID jid) {
        return this.store.findRoom(jid) != null;
    }

    private final Action calculateAction(Element element2, boolean checkRoomStore) {
        if (MIXModuleKt.isMixMessage(element2)) {
            return Action.Skip;
        }
        Object object = element2.getAttributes().get("from");
        if (object == null || (object = JIDKt.toBareJID((String)object)) == null) {
            return Action.Skip;
        }
        Object from = object;
        if (Intrinsics.areEqual((Object)element2.getName(), (Object)"message")) {
            String type = element2.getAttributes().get("type");
            if (Intrinsics.areEqual((Object)type, (Object)MessageType.Error.getValue())) {
                return !checkRoomStore || this.isFromKnownMUCRoom((BareJID)from) ? Action.Message : Action.Skip;
            }
            if (Intrinsics.areEqual((Object)type, (Object)MessageType.Groupchat.getValue())) {
                return Action.Message;
            }
            for (Element x2 : element2.getChildren("x")) {
                if (Intrinsics.areEqual((Object)x2.getXmlns(), (Object)"jabber:x:conference")) {
                    return Action.DirectInvitation;
                }
                if (Intrinsics.areEqual((Object)x2.getXmlns(), (Object)"http://jabber.org/protocol/muc#user") && x2.getFirstChild("invite") != null) {
                    return Action.MediatedInvitation;
                }
                if (!Intrinsics.areEqual((Object)x2.getXmlns(), (Object)"http://jabber.org/protocol/muc#user") || x2.getFirstChild("decline") == null) continue;
                return Action.MediatedInvitationDecline;
            }
        }
        if (Intrinsics.areEqual((Object)element2.getName(), (Object)"presence")) {
            if (!checkRoomStore) {
                return Action.Presence;
            }
            if (this.isFromKnownMUCRoom((BareJID)from)) {
                return Action.Presence;
            }
        }
        return Action.Skip;
    }

    static /* synthetic */ Action calculateAction$default(MUCModule mUCModule, Element element2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return mUCModule.calculateAction(element2, bl);
    }

    @Override
    public void process(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        switch (WhenMappings.$EnumSwitchMapping$0[this.calculateAction(element2, false).ordinal()]) {
            case 1: {
                this.processMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 2: {
                this.processPresence((Presence)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 3: {
                this.processInvitationDeclinedMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 4: {
                this.processMediatedInvitationMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 5: {
                this.processDirectInvitationMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 6: {
                throw new XMPPException(ErrorCondition.FeatureNotImplemented);
            }
        }
    }

    private final void processMessage(Message stanza2) {
        JID jID = stanza2.getFrom();
        Intrinsics.checkNotNull((Object)jID);
        Room room = this.store.findRoom(JIDKt.getBareJID(jID));
        if (room == null) {
            throw new XMPPException(ErrorCondition.ServiceUnavailable);
        }
        Room room2 = room;
        Object object = stanza2.getFrom();
        if (object == null || (object = JIDKt.getResource((JID)object)) == null) {
            return;
        }
        Object nickname2 = object;
        if (stanza2.getType() != MessageType.Error) {
            this.getContext().getEventBus().fire(new MucRoomEvents.ReceivedMessage(room2, (String)nickname2, stanza2));
        }
    }

    private final void processPresence(Presence stanza2) {
        boolean selfPresence;
        Pair pair;
        JID jID = stanza2.getFrom();
        Intrinsics.checkNotNull((Object)jID);
        Room room = this.store.findRoom(JIDKt.getBareJID(jID));
        if (room == null) {
            throw new XMPPException(ErrorCondition.ServiceUnavailable);
        }
        Room room2 = room;
        JID jID2 = stanza2.getFrom();
        Intrinsics.checkNotNull((Object)jID2);
        String nickname2 = JIDKt.getResource(jID2);
        if (stanza2.getType() == PresenceType.Error && room2.getState() != State.Joined && nickname2 == null) {
            room2.setState(State.NotJoined);
            EventBus eventBus = this.getContext().getEventBus();
            ErrorCondition errorCondition = ErrorConditionKt.getErrorConditionOrNull(stanza2);
            if (errorCondition == null) {
                errorCondition = ErrorCondition.UndefinedCondition;
            }
            eventBus.fire(new MucRoomEvents.JoinError(room2, stanza2, errorCondition));
        }
        if (nickname2 == null) {
            return;
        }
        MucUserExt mucExt = MucUserExt.Companion.createUserExt(stanza2);
        if (room2.getOccupants$halcyon_core().containsKey(nickname2)) {
            Occupant occupant = room2.getOccupants$halcyon_core().get(nickname2);
            Intrinsics.checkNotNull((Object)occupant);
            Occupant p = occupant;
            pair = new Pair((Object)p, (Object)p.getPresence());
        } else {
            pair = new Pair((Object)new Occupant(stanza2), null);
        }
        Pair pair2 = pair;
        Occupant occupant = (Occupant)pair2.component1();
        Presence presenceOld = (Presence)pair2.component2();
        boolean bl = selfPresence = mucExt != null && mucExt.getStatuses().contains(110) || Intrinsics.areEqual((Object)nickname2, (Object)room2.getNickname());
        if (room2.getState() == State.Joined && selfPresence) {
            room2.setState(State.NotJoined);
            room2.getOccupants$halcyon_core().clear();
            this.getContext().getEventBus().fire(new MucRoomEvents.YouLeaved(room2, stanza2));
        } else if (room2.getState() != State.Joined && selfPresence) {
            room2.setState(State.Joined);
            room2.getOccupants$halcyon_core().put(nickname2, occupant);
            this.getContext().getEventBus().fire(new MucRoomEvents.YouJoined(room2, stanza2, nickname2));
        } else if ((presenceOld == null || presenceOld.getType() == PresenceType.Unavailable) && stanza2.getType() == null) {
            room2.getOccupants$halcyon_core().put(nickname2, occupant);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantCame(room2, stanza2, nickname2));
        } else if (stanza2.getType() == PresenceType.Unavailable) {
            room2.getOccupants$halcyon_core().remove(nickname2);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantLeave(room2, stanza2, nickname2));
        } else {
            occupant.setPresence$halcyon_core(stanza2);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantChangedPresence(room2, stanza2, nickname2));
        }
        if (mucExt != null && mucExt.getStatuses().contains(201)) {
            this.getContext().getEventBus().fire(new MucRoomEvents.Created(room2));
        }
    }

    private final void processInvitationDeclinedMessage(Message stanza2) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void processMediatedInvitationMessage(Message stanza2) {
        JID jID = stanza2.getFrom();
        if (jID == null || (jID = JIDKt.getBareJID(jID)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        JID roomJid = jID;
        Element element2 = stanza2.getChildrenNS("x", "http://jabber.org/protocol/muc#user");
        if (element2 == null || (element2 = element2.getFirstChild("invite")) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Element invite2 = element2;
        Object object = invite2.getAttributes().get("from");
        if (object == null || (object = JIDKt.toJID((String)object)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Object sender = object;
        Element element3 = invite2.getFirstChild("reason");
        String reason = element3 != null ? element3.getValue() : null;
        Element element4 = stanza2.getChildrenNS("x", "http://jabber.org/protocol/muc#user");
        String password = element4 != null && (element4 = element4.getFirstChild("password")) != null ? element4.getValue() : null;
        this.getContext().getEventBus().fire(new MucEvents.InvitationReceived(new Invitation((BareJID)roomJid, (JID)sender, password, reason, false)));
    }

    private final void processDirectInvitationMessage(Message stanza2) {
        Element element2 = stanza2.getChildrenNS("x", "jabber:x:conference");
        if (element2 == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Element invite2 = element2;
        JID jID = stanza2.getFrom();
        if (jID == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        JID sender = jID;
        Object object = invite2.getAttributes().get("jid");
        if (object == null || (object = JIDKt.toBareJID((String)object)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Object roomJid = object;
        String password = invite2.getAttributes().get("password");
        String reason = invite2.getAttributes().get("reason");
        this.getContext().getEventBus().fire(new MucEvents.InvitationReceived(new Invitation((BareJID)roomJid, sender, password, reason, true)));
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> join(@NotNull BareJID roomJID, @NotNull String nickname2, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)roomJID, (String)"roomJID");
        Intrinsics.checkNotNullParameter((Object)nickname2, (String)"nickname");
        Room room = this.store.findRoom(roomJID);
        if (room == null) {
            room = this.store.createRoom(roomJID, nickname2);
        }
        Room room2 = room;
        room2.setPassword(password);
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)new Function1<PresenceNode, Unit>(room2, nickname2){
            final /* synthetic */ Room $room;
            final /* synthetic */ String $nickname;
            {
                this.$room = $room;
                this.$nickname = $nickname;
                super(1);
            }

            public final void invoke(@NotNull PresenceNode $this$presence) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
                    $this$presence.setTo(JIDKt.copy(this.$room.getRoomJID(), this.$nickname));
                    ElementNode.invoke$default($this$presence, "x", null, (Function1)new Function1<ElementNode, Unit>(this.$room){
                        final /* synthetic */ Room $room;
                        {
                            this.$room = $room;
                            super(1);
                        }

                        public final void invoke(@NotNull ElementNode $this$invoke) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                $this$invoke.setXmlns("http://jabber.org/protocol/muc");
                                String string = this.$room.getPassword();
                                if (string == null) break block0;
                                String pwd = string;
                                boolean bl = false;
                                ElementNode.invoke$default($this$invoke, "password", null, (Function1)new Function1<ElementNode, Unit>(pwd){
                                    final /* synthetic */ String $pwd;
                                    {
                                        this.$pwd = $pwd;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ElementNode $this$invoke) {
                                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                        $this$invoke.unaryPlus(this.$pwd);
                                    }
                                }, 1, null);
                            }
                        }
                    }, 1, null);
                    Instant instant = this.$room.getLastMessageTimestamp();
                    if (instant == null) break block0;
                    Instant lmt = instant;
                    boolean bl = false;
                    ElementNode.invoke$default($this$presence, "history", null, (Function1)new Function1<ElementNode, Unit>(lmt){
                        final /* synthetic */ Instant $lmt;
                        {
                            this.$lmt = $lmt;
                            super(1);
                        }

                        public final void invoke(@NotNull ElementNode $this$invoke) {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.getAttributes().set("since", TimestampKt.timestampToISO8601(this.$lmt));
                        }
                    }, 1, null);
                }
            }
        })).onSend((Function1)new Function1<Request<?, Presence>, Unit>(room2){
            final /* synthetic */ Room $room;
            {
                this.$room = $room;
                super(1);
            }

            public final void invoke(@NotNull Request<?, Presence> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$room.setState(State.RequestSent);
            }
        });
    }

    public static /* synthetic */ RequestBuilder join$default(MUCModule mUCModule, BareJID bareJID, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return mUCModule.join(bareJID, string, string2);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> leave(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)new Function1<PresenceNode, Unit>(room){
            final /* synthetic */ Room $room;
            {
                this.$room = $room;
                super(1);
            }

            public final void invoke(@NotNull PresenceNode $this$presence) {
                Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
                $this$presence.setTo(JIDKt.copy(this.$room.getRoomJID(), this.$room.getNickname()));
                $this$presence.setType(PresenceType.Unavailable);
            }
        }));
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> destroy(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)new Function1<IQNode, Unit>(room){
            final /* synthetic */ Room $room;
            {
                this.$room = $room;
                super(1);
            }

            public final void invoke(@NotNull IQNode $this$iq) {
                Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
                $this$iq.setType(IQType.Set);
                $this$iq.setTo(this.$room.getRoomJID());
                ElementNode.invoke$default($this$iq, "query", null, destroy.1.INSTANCE, 1, null);
            }
        })).map(destroy.2.INSTANCE);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> invite(@NotNull Room room, @NotNull BareJID invitedJid, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)invitedJid, (String)"invitedJid");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, (Function1)new Function1<MessageNode, Unit>(room, invitedJid, reason){
            final /* synthetic */ Room $room;
            final /* synthetic */ BareJID $invitedJid;
            final /* synthetic */ String $reason;
            {
                this.$room = $room;
                this.$invitedJid = $invitedJid;
                this.$reason = $reason;
                super(1);
            }

            public final void invoke(@NotNull MessageNode $this$message) {
                Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                $this$message.setTo(this.$room.getRoomJID());
                ElementNode.invoke$default($this$message, "x", null, (Function1)new Function1<ElementNode, Unit>(this.$invitedJid, this.$reason){
                    final /* synthetic */ BareJID $invitedJid;
                    final /* synthetic */ String $reason;
                    {
                        this.$invitedJid = $invitedJid;
                        this.$reason = $reason;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        $this$invoke.setXmlns("http://jabber.org/protocol/muc#user");
                        ElementNode.invoke$default($this$invoke, "invite", null, (Function1)new Function1<ElementNode, Unit>(this.$invitedJid, this.$reason){
                            final /* synthetic */ BareJID $invitedJid;
                            final /* synthetic */ String $reason;
                            {
                                this.$invitedJid = $invitedJid;
                                this.$reason = $reason;
                                super(1);
                            }

                            public final void invoke(@NotNull ElementNode $this$invoke) {
                                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                $this$invoke.getAttributes().set("to", this.$invitedJid.toString());
                                if (this.$reason != null) {
                                    ElementNode.invoke$default($this$invoke, "reason", null, (Function1)new Function1<ElementNode, Unit>(this.$reason){
                                        final /* synthetic */ String $reason;
                                        {
                                            this.$reason = $reason;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ElementNode $this$invoke) {
                                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                            $this$invoke.unaryPlus(this.$reason);
                                        }
                                    }, 1, null);
                                }
                            }
                        }, 1, null);
                    }
                }, 1, null);
            }
        }, 1, null);
    }

    public static /* synthetic */ RequestBuilder invite$default(MUCModule mUCModule, Room room, BareJID bareJID, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return mUCModule.invite(room, bareJID, string);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> inviteDirectly(@NotNull Room room, @NotNull BareJID invitedJid, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)invitedJid, (String)"invitedJid");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, (Function1)new Function1<MessageNode, Unit>(invitedJid, room, reason){
            final /* synthetic */ BareJID $invitedJid;
            final /* synthetic */ Room $room;
            final /* synthetic */ String $reason;
            {
                this.$invitedJid = $invitedJid;
                this.$room = $room;
                this.$reason = $reason;
                super(1);
            }

            public final void invoke(@NotNull MessageNode $this$message) {
                Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                $this$message.setTo(this.$invitedJid);
                ElementNode.invoke$default($this$message, "x", null, (Function1)new Function1<ElementNode, Unit>(this.$room, this.$reason){
                    final /* synthetic */ Room $room;
                    final /* synthetic */ String $reason;
                    {
                        this.$room = $room;
                        this.$reason = $reason;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.setXmlns("jabber:x:conference");
                            $this$invoke.getAttributes().set("jid", this.$room.getRoomJID().toString());
                            String string = this.$reason;
                            if (string != null) {
                                String string2 = string;
                                String string3 = this.$reason;
                                String it = string2;
                                boolean bl = false;
                                $this$invoke.getAttributes().set("reason", string3);
                            }
                            String string4 = this.$room.getPassword();
                            if (string4 == null) break block1;
                            String it = string4;
                            boolean bl = false;
                            $this$invoke.getAttributes().set("password", it);
                        }
                    }
                }, 1, null);
            }
        }, 1, null);
    }

    public static /* synthetic */ RequestBuilder inviteDirectly$default(MUCModule mUCModule, Room room, BareJID bareJID, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return mUCModule.inviteDirectly(room, bareJID, string);
    }

    @NotNull
    public final RequestBuilder<JabberDataForm, IQ> retrieveRoomConfig(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)new Function1<IQNode, Unit>(room){
            final /* synthetic */ Room $room;
            {
                this.$room = $room;
                super(1);
            }

            public final void invoke(@NotNull IQNode $this$iq) {
                Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
                $this$iq.setTo(this.$room.getRoomJID());
                $this$iq.setType(IQType.Get);
                ElementNode.invoke$default($this$iq, "query", null, retrieveRoomConfig.1.INSTANCE, 1, null);
            }
        })).map(retrieveRoomConfig.2.INSTANCE);
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> updateRoomConfig(@NotNull Room room, @NotNull JabberDataForm form) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)new Function1<IQNode, Unit>(room, form){
            final /* synthetic */ Room $room;
            final /* synthetic */ JabberDataForm $form;
            {
                this.$room = $room;
                this.$form = $form;
                super(1);
            }

            public final void invoke(@NotNull IQNode $this$iq) {
                Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
                $this$iq.setTo(this.$room.getRoomJID());
                $this$iq.setType(IQType.Set);
                ElementNode.invoke$default($this$iq, "query", null, (Function1)new Function1<ElementNode, Unit>(this.$form){
                    final /* synthetic */ JabberDataForm $form;
                    {
                        this.$form = $form;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        $this$invoke.setXmlns("http://jabber.org/protocol/muc#owner");
                        $this$invoke.addChild(this.$form.createSubmitForm());
                    }
                }, 1, null);
            }
        })).map(updateRoomConfig.2.INSTANCE);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> message(@NotNull Room room, @NotNull String messageBody) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)messageBody, (String)"messageBody");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, (Function1)new Function1<MessageNode, Unit>(room, messageBody){
            final /* synthetic */ Room $room;
            final /* synthetic */ String $messageBody;
            {
                this.$room = $room;
                this.$messageBody = $messageBody;
                super(1);
            }

            public final void invoke(@NotNull MessageNode $this$message) {
                Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                $this$message.setTo(this.$room.getRoomJID());
                $this$message.setType(MessageType.Groupchat);
                $this$message.setBody(this.$messageBody);
            }
        }, 1, null);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> decline(@NotNull Invitation invitation, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)invitation, (String)"invitation");
        if (invitation.getDirect()) {
            throw new HalcyonException("Direct invitation should be silently ignored.");
        }
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, (Function1)new Function1<MessageNode, Unit>(invitation, reason){
            final /* synthetic */ Invitation $invitation;
            final /* synthetic */ String $reason;
            {
                this.$invitation = $invitation;
                this.$reason = $reason;
                super(1);
            }

            public final void invoke(@NotNull MessageNode $this$message) {
                Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                $this$message.setTo(this.$invitation.getRoomjid());
                ElementNode.invoke$default($this$message, "x", null, (Function1)new Function1<ElementNode, Unit>(this.$invitation, this.$reason){
                    final /* synthetic */ Invitation $invitation;
                    final /* synthetic */ String $reason;
                    {
                        this.$invitation = $invitation;
                        this.$reason = $reason;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        $this$invoke.setXmlns("http://jabber.org/protocol/muc#user");
                        ElementNode.invoke$default($this$invoke, "decline", null, (Function1)new Function1<ElementNode, Unit>(this.$invitation, this.$reason){
                            final /* synthetic */ Invitation $invitation;
                            final /* synthetic */ String $reason;
                            {
                                this.$invitation = $invitation;
                                this.$reason = $reason;
                                super(1);
                            }

                            public final void invoke(@NotNull ElementNode $this$invoke) {
                                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                $this$invoke.getAttributes().set("to", JIDKt.getBareJID(this.$invitation.getSender()).toString());
                                if (this.$reason != null) {
                                    ElementNode.invoke$default($this$invoke, "reason", null, (Function1)new Function1<ElementNode, Unit>(this.$reason){
                                        final /* synthetic */ String $reason;
                                        {
                                            this.$reason = $reason;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ElementNode $this$invoke) {
                                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                            $this$invoke.unaryPlus(this.$reason);
                                        }
                                    }, 1, null);
                                }
                            }
                        }, 1, null);
                    }
                }, 1, null);
            }
        }, 1, null);
    }

    public static /* synthetic */ RequestBuilder decline$default(MUCModule mUCModule, Invitation invitation, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return mUCModule.decline(invitation, string);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> accept(@NotNull Invitation invitation, @NotNull String nickname2) {
        Intrinsics.checkNotNullParameter((Object)invitation, (String)"invitation");
        Intrinsics.checkNotNullParameter((Object)nickname2, (String)"nickname");
        return this.join(invitation.getRoomjid(), nickname2, invitation.getPassword());
    }

    @NotNull
    public final RequestBuilder<Collection<RoomAffiliation>, IQ> retrieveAffiliations(@NotNull Room room, @Nullable Affiliation filter) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)new Function1<IQNode, Unit>(room, filter){
            final /* synthetic */ Room $room;
            final /* synthetic */ Affiliation $filter;
            {
                this.$room = $room;
                this.$filter = $filter;
                super(1);
            }

            public final void invoke(@NotNull IQNode $this$iq) {
                Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
                $this$iq.setTo(this.$room.getRoomJID());
                $this$iq.setType(IQType.Get);
                ElementNode.invoke$default($this$iq, "query", null, (Function1)new Function1<ElementNode, Unit>(this.$filter){
                    final /* synthetic */ Affiliation $filter;
                    {
                        this.$filter = $filter;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.setXmlns("http://jabber.org/protocol/muc#admin");
                            Affiliation affiliation = this.$filter;
                            if (affiliation == null) break block0;
                            Affiliation affiliation2 = affiliation;
                            Affiliation affiliation3 = this.$filter;
                            Affiliation it = affiliation2;
                            boolean bl = false;
                            ElementNode.invoke$default($this$invoke, "item", null, (Function1)new Function1<ElementNode, Unit>(affiliation3){
                                final /* synthetic */ Affiliation $filter;
                                {
                                    this.$filter = $filter;
                                    super(1);
                                }

                                public final void invoke(@NotNull ElementNode $this$invoke) {
                                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                    $this$invoke.getAttributes().set("affiliation", this.$filter.getXmppValue());
                                }
                            }, 1, null);
                        }
                    }
                }, 1, null);
            }
        })).map(retrieveAffiliations.2.INSTANCE);
    }

    public static /* synthetic */ RequestBuilder retrieveAffiliations$default(MUCModule mUCModule, Room room, Affiliation affiliation, int n, Object object) {
        if ((n & 2) != 0) {
            affiliation = null;
        }
        return mUCModule.retrieveAffiliations(room, affiliation);
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> updateAffiliations(@NotNull Room room, @NotNull Collection<RoomAffiliation> affiliations) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter(affiliations, (String)"affiliations");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)new Function1<IQNode, Unit>(room, affiliations){
            final /* synthetic */ Room $room;
            final /* synthetic */ Collection<RoomAffiliation> $affiliations;
            {
                this.$room = $room;
                this.$affiliations = $affiliations;
                super(1);
            }

            public final void invoke(@NotNull IQNode $this$iq) {
                Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
                $this$iq.setTo(this.$room.getRoomJID());
                $this$iq.setType(IQType.Set);
                ElementNode.invoke$default($this$iq, "query", null, (Function1)new Function1<ElementNode, Unit>(this.$affiliations){
                    final /* synthetic */ Collection<RoomAffiliation> $affiliations;
                    {
                        this.$affiliations = $affiliations;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        $this$invoke.setXmlns("http://jabber.org/protocol/muc#admin");
                        Iterable $this$forEach$iv = this.$affiliations;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            RoomAffiliation a = (RoomAffiliation)element$iv;
                            boolean bl = false;
                            ElementNode.invoke$default($this$invoke, "item", null, (Function1)new Function1<ElementNode, Unit>(a){
                                final /* synthetic */ RoomAffiliation $a;
                                {
                                    this.$a = $a;
                                    super(1);
                                }

                                public final void invoke(@NotNull ElementNode $this$invoke) {
                                    block1: {
                                        Object it;
                                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                        $this$invoke.getAttributes().set("affiliation", this.$a.getAffiliation().getXmppValue());
                                        JID jID = this.$a.getJid();
                                        if (jID != null) {
                                            it = jID;
                                            boolean bl = false;
                                            $this$invoke.getAttributes().set("jid", it.toString());
                                        }
                                        Role role2 = this.$a.getRole();
                                        if (role2 == null) break block1;
                                        it = role2;
                                        boolean bl = false;
                                        $this$invoke.getAttributes().set("role", ((Role)((Object)it)).getXmppValue());
                                    }
                                }
                            }, 1, null);
                        }
                    }
                }, 1, null);
            }
        })).map(updateAffiliations.2.INSTANCE);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> updateRoomSubject(@NotNull Room room, @Nullable String subject) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, (Function1)new Function1<MessageNode, Unit>(room, subject){
            final /* synthetic */ Room $room;
            final /* synthetic */ String $subject;
            {
                this.$room = $room;
                this.$subject = $subject;
                super(1);
            }

            public final void invoke(@NotNull MessageNode $this$message) {
                Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
                $this$message.setTo(this.$room.getRoomJID());
                $this$message.setType(MessageType.Groupchat);
                ElementNode.invoke$default($this$message, "subject", null, (Function1)new Function1<ElementNode, Unit>(this.$subject){
                    final /* synthetic */ String $subject;
                    {
                        this.$subject = $subject;
                        super(1);
                    }

                    public final void invoke(@NotNull ElementNode $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        if (this.$subject != null) {
                            $this$invoke.unaryPlus(this.$subject);
                        }
                    }
                }, 1, null);
            }
        }, 1, null);
    }

    @NotNull
    public final RequestBuilder<PingModule.Pong, IQ> ping(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return ((PingModule)this.getContext().getModules().get(PingModule.Companion.getTYPE())).ping(new FullJID(room.getRoomJID(), room.getNickname()));
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> propertySimple(@NotNull Scope scope, T initialValue) {
        return XmppModule.DefaultImpls.propertySimple(this, scope, initialValue);
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> property(@NotNull Scope scope, @NotNull Function0<? extends T> initialValueFactory) {
        return XmppModule.DefaultImpls.property(this, scope, initialValueFactory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Action;", "", "(Ljava/lang/String;I)V", "Skip", "MediatedInvitationDecline", "MediatedInvitation", "DirectInvitation", "Message", "Presence", "halcyon-core"})
    private static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action Skip = new Action();
        public static final /* enum */ Action MediatedInvitationDecline = new Action();
        public static final /* enum */ Action MediatedInvitation = new Action();
        public static final /* enum */ Action DirectInvitation = new Action();
        public static final /* enum */ Action Message = new Action();
        public static final /* enum */ Action Presence = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.Skip, Action.MediatedInvitationDecline, Action.MediatedInvitation, Action.DirectInvitation, Action.Message, Action.Presence};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Companion;", "Ltigase/halcyon/core/modules/XmppModuleProvider;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModule;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModuleConfig;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "XMLNS", "configure", "", "module", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "instance", "context", "Ltigase/halcyon/core/Context;", "halcyon-core"})
    public static final class Companion
    implements XmppModuleProvider<MUCModule, MUCModuleConfig> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public MUCModule instance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new MUCModule(context);
        }

        @Override
        public void configure(@NotNull MUCModule module, @NotNull Function1<? super MUCModuleConfig, Unit> cfg) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            cfg.invoke((Object)module);
        }

        @Override
        @NotNull
        public List<HalcyonModuleProvider<HalcyonModule, ? extends Object>> requiredModules() {
            return XmppModuleProvider.DefaultImpls.requiredModules(this);
        }

        @Override
        public void doAfterRegistration(@NotNull MUCModule module, @NotNull ModulesManager moduleManager) {
            XmppModuleProvider.DefaultImpls.doAfterRegistration(this, (XmppModule)module, moduleManager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.Message.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.Presence.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.MediatedInvitationDecline.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.MediatedInvitation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.DirectInvitation.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.Skip.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

