/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.modules.Criteria;
import tigase.halcyon.core.modules.Criterion;
import tigase.halcyon.core.modules.HalcyonModule;
import tigase.halcyon.core.modules.HalcyonModuleProvider;
import tigase.halcyon.core.modules.ModulesManager;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.modules.XmppModuleProvider;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.modules.auth.AuthData;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLEngine;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModuleConfig;
import tigase.halcyon.core.xmpp.modules.auth.SASLPlain;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA1;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA1Plus;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA256;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA256Plus;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA512;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA512Plus;
import tigase.halcyon.core.xmpp.modules.auth.State;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0002/0B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020&2\u0006\u0010+\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020&2\u0006\u0010+\u001a\u00020)H\u0002J\u000e\u0010.\u001a\u00020&2\u0006\u0010(\u001a\u00020)R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b \u0010!*\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00061"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLModule;", "Ltigase/halcyon/core/modules/XmppModule;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModuleConfig;", "context", "Ltigase/halcyon/core/Context;", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "criteria", "Ltigase/halcyon/core/modules/Criteria;", "getCriteria", "()Ltigase/halcyon/core/modules/Criteria;", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "engine", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;", "features", "", "", "getFeatures", "()[Ljava/lang/String;", "[Ljava/lang/String;", "log", "Ltigase/halcyon/core/logger/Logger;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "getSaslContext$delegate", "(Ltigase/halcyon/core/xmpp/modules/auth/SASLModule;)Ljava/lang/Object;", "getSaslContext", "()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "type", "getType", "()Ljava/lang/String;", "initialize", "", "isAllowed", "streamFeatures", "Ltigase/halcyon/core/xml/Element;", "process", "element", "processChallenge", "processFailure", "startAuth", "Companion", "SASLError", "halcyon-core"})
public final class SASLModule
implements XmppModule,
SASLModuleConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Logger log;
    @NotNull
    private final String type;
    @NotNull
    private final Criteria criteria;
    @Nullable
    private final String[] features;
    @NotNull
    private final SASLEngine engine;
    private boolean enabled;
    @NotNull
    public static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    @NotNull
    private static final String TYPE = "tigase.halcyon.core.xmpp.modules.auth.SASLModule";

    public SASLModule(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.SASLModule", false, 2, null);
        this.type = TYPE;
        Criteria[] criteriaArray = new Criteria[]{Criterion.Companion.nameAndXmlns("success", XMLNS), Criterion.Companion.nameAndXmlns("failure", XMLNS), Criterion.Companion.nameAndXmlns("challenge", XMLNS)};
        this.criteria = Criterion.Companion.or(criteriaArray);
        this.engine = new SASLEngine(this.getContext());
        this.enabled = true;
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        return this.features;
    }

    @NotNull
    public final SASLContext getSaslContext() {
        return this.engine.getSaslContext();
    }

    private static Object getSaslContext$delegate(SASLModule sASLModule) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)sASLModule.engine, SASLEngine.class, "saslContext", "getSaslContext()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", 0)));
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private final void initialize() {
        this.engine.add(new SASLScramSHA512Plus(null, 1, null));
        this.engine.add(new SASLScramSHA256Plus(null, 1, null));
        this.engine.add(new SASLScramSHA1Plus(null, 1, null));
        this.engine.add(new SASLScramSHA512(null, 1, null));
        this.engine.add(new SASLScramSHA256(null, 1, null));
        this.engine.add(new SASLScramSHA1(null, 1, null));
        this.engine.add(new SASLPlain());
    }

    public final void startAuth(@NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        AuthData authData = this.engine.start(streamFeatures);
        Element authElement2 = BuilderKt.element("auth", (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(authData){
            final /* synthetic */ AuthData $authData;
            {
                this.$authData = $authData;
                super(1);
            }

            public final void invoke(@NotNull ElementNode $this$element) {
                Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
                $this$element.setXmlns("urn:ietf:params:xml:ns:xmpp-sasl");
                $this$element.attribute("mechanism", this.$authData.getMechanismName());
                if (this.$authData.getData() != null) {
                    $this$element.unaryPlus(this.$authData.getData());
                }
            }
        }));
        this.getContext().getWriter().writeDirectly(authElement2);
    }

    @Override
    public void process(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        try {
            switch (element2.getName()) {
                case "success": {
                    this.engine.evaluateSuccess(element2.getValue());
                    break;
                }
                case "failure": {
                    this.processFailure(element2);
                    break;
                }
                case "challenge": {
                    this.processChallenge(element2);
                    break;
                }
                default: {
                    throw new XMPPException(ErrorCondition.BadRequest, "Unsupported element");
                }
            }
        }
        catch (ClientSaslException e) {
            this.engine.getSaslContext().setState$halcyon_core(State.Failed);
            this.getContext().getEventBus().fire(new SASLEvent.SASLError(SASLError.Unknown, e.getMessage()));
        }
    }

    private final void processChallenge(Element element2) {
        String v = element2.getValue();
        String r = this.engine.evaluateChallenge(v);
        Element authElement2 = BuilderKt.element("response", (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(r){
            final /* synthetic */ String $r;
            {
                this.$r = $r;
                super(1);
            }

            public final void invoke(@NotNull ElementNode $this$element) {
                Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
                $this$element.setXmlns("urn:ietf:params:xml:ns:xmpp-sasl");
                if (this.$r != null) {
                    $this$element.unaryPlus(this.$r);
                }
            }
        }));
        this.getContext().getWriter().writeDirectly(authElement2);
    }

    private final void processFailure(Element element2) {
        Element element3 = element2.getFirstChild();
        Intrinsics.checkNotNull((Object)element3);
        Element errElement = element3;
        SASLError sASLError = SASLError.Companion.valueByElementName(errElement.getName());
        Intrinsics.checkNotNull((Object)((Object)sASLError));
        SASLError saslError = sASLError;
        String errorText = null;
        Element element4 = element2.getFirstChild("text");
        if (element4 != null) {
            Element element5;
            Element $this$processFailure_u24lambda_u240 = element5 = element4;
            boolean bl = false;
            errorText = $this$processFailure_u24lambda_u240.getValue();
        }
        this.engine.evaluateFailure(saslError, errorText);
    }

    public final boolean isAllowed(@NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        return this.getContext().getConfig().getSasl() != null && this.getEnabled() && streamFeatures.getChildrenNS("mechanisms", XMLNS) != null;
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> propertySimple(@NotNull Scope scope, T initialValue) {
        return XmppModule.DefaultImpls.propertySimple(this, scope, initialValue);
    }

    @Override
    @NotNull
    public <T> ReadWriteProperty<Object, T> property(@NotNull Scope scope, @NotNull Function0<? extends T> initialValueFactory) {
        return XmppModule.DefaultImpls.property(this, scope, initialValueFactory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$Companion;", "Ltigase/halcyon/core/modules/XmppModuleProvider;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModule;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModuleConfig;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "XMLNS", "configure", "", "module", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "doAfterRegistration", "moduleManager", "Ltigase/halcyon/core/modules/ModulesManager;", "instance", "context", "Ltigase/halcyon/core/Context;", "halcyon-core"})
    public static final class Companion
    implements XmppModuleProvider<SASLModule, SASLModuleConfig> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        public void configure(@NotNull SASLModule module, @NotNull Function1<? super SASLModuleConfig, Unit> cfg) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            cfg.invoke((Object)module);
        }

        @Override
        @NotNull
        public SASLModule instance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new SASLModule(context);
        }

        @Override
        public void doAfterRegistration(@NotNull SASLModule module, @NotNull ModulesManager moduleManager) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
            module.initialize();
        }

        @Override
        @NotNull
        public List<HalcyonModuleProvider<HalcyonModule, ? extends Object>> requiredModules() {
            return XmppModuleProvider.DefaultImpls.requiredModules(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError;", "", "elementName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getElementName", "()Ljava/lang/String;", "Aborted", "IncorrectEncoding", "InvalidAuthzid", "InvalidMechanism", "MechanismTooWeak", "NotAuthorized", "ServerNotTrusted", "TemporaryAuthFailure", "Unknown", "Companion", "halcyon-core"})
    public static final class SASLError
    extends Enum<SASLError> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String elementName;
        public static final /* enum */ SASLError Aborted;
        public static final /* enum */ SASLError IncorrectEncoding;
        public static final /* enum */ SASLError InvalidAuthzid;
        public static final /* enum */ SASLError InvalidMechanism;
        public static final /* enum */ SASLError MechanismTooWeak;
        public static final /* enum */ SASLError NotAuthorized;
        public static final /* enum */ SASLError ServerNotTrusted;
        public static final /* enum */ SASLError TemporaryAuthFailure;
        public static final /* enum */ SASLError Unknown;
        private static final /* synthetic */ SASLError[] $VALUES;

        private SASLError(String elementName) {
            this.elementName = elementName;
        }

        @NotNull
        public final String getElementName() {
            return this.elementName;
        }

        public static SASLError[] values() {
            return (SASLError[])$VALUES.clone();
        }

        public static SASLError valueOf(String value) {
            return Enum.valueOf(SASLError.class, value);
        }

        static {
            Aborted = new SASLError("aborted");
            IncorrectEncoding = new SASLError("incorrect-encoding");
            InvalidAuthzid = new SASLError("invalid-authzid");
            InvalidMechanism = new SASLError("invalid-mechanism");
            MechanismTooWeak = new SASLError("mechanism-too-weak");
            NotAuthorized = new SASLError("not-authorized");
            ServerNotTrusted = new SASLError("server-not-trusted");
            TemporaryAuthFailure = new SASLError("temporary-auth-failure");
            Unknown = new SASLError("-");
            $VALUES = sASLErrorArray = new SASLError[]{SASLError.Aborted, SASLError.IncorrectEncoding, SASLError.InvalidAuthzid, SASLError.InvalidMechanism, SASLError.MechanismTooWeak, SASLError.NotAuthorized, SASLError.ServerNotTrusted, SASLError.TemporaryAuthFailure, SASLError.Unknown};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError$Companion;", "", "()V", "valueByElementName", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError;", "elementName", "", "halcyon-core"})
        @SourceDebugExtension(value={"SMAP\nSASLModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SASLModule.kt\ntigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,201:1\n1282#2,2:202\n*S KotlinDebug\n*F\n+ 1 SASLModule.kt\ntigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError$Companion\n*L\n111#1:202,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SASLError valueByElementName(@NotNull String elementName) {
                SASLError sASLError;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
                    SASLError[] $this$firstOrNull$iv = SASLError.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        SASLError element$iv;
                        SASLError saslError = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)saslError.getElementName(), (Object)elementName)) continue;
                        sASLError = element$iv;
                        break block1;
                    }
                    sASLError = null;
                }
                return sASLError;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

