/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.Arrays;
import korlibs.crypto.HMAC;
import korlibs.crypto.Hash;
import korlibs.crypto.PBKDF2;
import korlibs.crypto.SHA1Kt;
import korlibs.crypto.SHA256Kt;
import korlibs.crypto.SHA512Kt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Base64Kt;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.configuration.Configuration;
import tigase.halcyon.core.configuration.JIDPasswordSaslConfig;
import tigase.halcyon.core.configuration.SaslConfig;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.modules.auth.BindType;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.MechanismData;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanism;
import tigase.halcyon.core.xmpp.modules.auth.SCRAMData;
import tigase.halcyon.core.xmpp.modules.auth.ScramHashAlgorithm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ,\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J,\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/AbstractSASLScram;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanism;", "name", "", "hashAlgorithm", "Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "randomGenerator", "Lkotlin/Function0;", "clientKeyData", "", "serverKeyData", "(Ljava/lang/String;Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;Lkotlin/jvm/functions/Function0;[B[B)V", "getHashAlgorithm", "()Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "log", "Ltigase/halcyon/core/logger/Logger;", "getName", "()Ljava/lang/String;", "serverFirstMessageRegex", "Lkotlin/text/Regex;", "serverLastMessageRegex", "evaluateChallenge", "input", "context", "Ltigase/halcyon/core/Context;", "config", "Ltigase/halcyon/core/configuration/Configuration;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "isAllowedToUse", "", "streamFeatures", "Ltigase/halcyon/core/xml/Element;", "prepareChannelBindingData", "Lkotlin/Pair;", "Ltigase/halcyon/core/xmpp/modules/auth/BindType;", "scramData", "Ltigase/halcyon/core/xmpp/modules/auth/SCRAMData;", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nAbstractSASLScram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSASLScram.kt\ntigase/halcyon/core/xmpp/modules/auth/AbstractSASLScram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public abstract class AbstractSASLScram
implements SASLMechanism {
    @NotNull
    private final String name;
    @NotNull
    private final ScramHashAlgorithm hashAlgorithm;
    @NotNull
    private final Function0<String> randomGenerator;
    @NotNull
    private final byte[] clientKeyData;
    @NotNull
    private final byte[] serverKeyData;
    @NotNull
    private final Logger log;
    @NotNull
    private final Regex serverFirstMessageRegex;
    @NotNull
    private final Regex serverLastMessageRegex;

    public AbstractSASLScram(@NotNull String name2, @NotNull ScramHashAlgorithm hashAlgorithm, @NotNull Function0<String> randomGenerator, @NotNull byte[] clientKeyData, @NotNull byte[] serverKeyData) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter(randomGenerator, (String)"randomGenerator");
        Intrinsics.checkNotNullParameter((Object)clientKeyData, (String)"clientKeyData");
        Intrinsics.checkNotNullParameter((Object)serverKeyData, (String)"serverKeyData");
        this.name = name2;
        this.hashAlgorithm = hashAlgorithm;
        this.randomGenerator = randomGenerator;
        this.clientKeyData = clientKeyData;
        this.serverKeyData = serverKeyData;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.AbstractSASLScram", false, 2, null);
        this.serverFirstMessageRegex = new Regex("^(m=[^,]+,)?r=([^,]+),s=([^,]+),i=([0-9]+)(?:,.*)?$", RegexOption.IGNORE_CASE);
        this.serverLastMessageRegex = new Regex("^(?:e=([^,]+)|v=([^,]+)(?:,.*)?)$", RegexOption.IGNORE_CASE);
    }

    public /* synthetic */ AbstractSASLScram(String string, ScramHashAlgorithm scramHashAlgorithm, Function0 function0, byte[] byArray, byte[] byArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            byArray = StringsKt.encodeToByteArray((String)"Client Key");
        }
        if ((n & 0x10) != 0) {
            byArray2 = StringsKt.encodeToByteArray((String)"Server Key");
        }
        this(string, scramHashAlgorithm, (Function0<String>)function0, byArray, byArray2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final ScramHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public boolean isAllowedToUse(@NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext, @NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        return config.getSasl() instanceof JIDPasswordSaslConfig;
    }

    @NotNull
    protected final SCRAMData scramData(@NotNull SASLContext saslContext) {
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        if (saslContext.getMechanismData() == null) {
            saslContext.setMechanismData(new SCRAMData(null, null, null, null, null, null, null, null, null, null, null, 0, 4095, null));
        }
        MechanismData mechanismData = saslContext.getMechanismData();
        Intrinsics.checkNotNull((Object)mechanismData, (String)"null cannot be cast to non-null type tigase.halcyon.core.xmpp.modules.auth.SCRAMData");
        return (SCRAMData)mechanismData;
    }

    @NotNull
    protected Pair<BindType, byte[]> prepareChannelBindingData(@NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        return new Pair((Object)BindType.N, (Object)new byte[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String evaluateChallenge(@Nullable String input, @NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext) {
        SCRAMData data;
        block57: {
            StringBuilder stringBuilder;
            byte[] byArray;
            Hash hash;
            Hash hash2;
            Hash hash3;
            byte[] byArray2;
            StringBuilder stringBuilder2;
            Object object;
            Object nonce;
            MatchResult r2;
            String serverFirstMessage;
            block59: {
                block58: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
                    data = this.scramData(saslContext);
                    SaslConfig saslConfig = config.getSasl();
                    Intrinsics.checkNotNull((Object)saslConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.configuration.JIDPasswordSaslConfig");
                    JIDPasswordSaslConfig credentials = (JIDPasswordSaslConfig)saslConfig;
                    if (data.getStage() == 0) {
                        void $this$evaluateChallenge_u24lambda_u243;
                        StringBuilder $this$evaluateChallenge_u24lambda_u242;
                        String string;
                        data.setConce((String)this.randomGenerator.invoke());
                        Object object2 = this.prepareChannelBindingData(context, config, saslContext);
                        boolean bl = false;
                        BindType bindType = (BindType)((Object)object2.component1());
                        byte[] bindData = (byte[])object2.component2();
                        data.setBindType(bindType);
                        data.setBindData(bindData);
                        this.log.fine("Selected channel binding: " + data.getBindType());
                        String string2 = credentials.getAuthcId();
                        if (string2 == null) {
                            String string3 = credentials.getUserJID().getLocalpart();
                            string2 = string3;
                            Intrinsics.checkNotNull((Object)string3);
                        }
                        data.setAuthcId(string2);
                        data.setAuthzId(credentials.getAuthcId() != null ? credentials.getUserJID().toString() : null);
                        BindType bindType2 = data.getBindType();
                        Intrinsics.checkNotNull((Object)((Object)bindType2));
                        switch (WhenMappings.$EnumSwitchMapping$0[bindType2.ordinal()]) {
                            case 1: {
                                string = "n";
                                break;
                            }
                            case 2: {
                                string = "y";
                                break;
                            }
                            case 3: {
                                string = "p=tls-unique";
                                break;
                            }
                            case 4: {
                                string = "p=tls-server-end-point";
                                break;
                            }
                            case 5: {
                                string = "p=tls-exporter";
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        data.setGs2CBindFlag(string);
                        StringBuilder stringBuilder3 = new StringBuilder();
                        object2 = stringBuilder3;
                        SCRAMData sCRAMData = data;
                        boolean bl2 = false;
                        $this$evaluateChallenge_u24lambda_u242.append(data.getGs2CBindFlag());
                        $this$evaluateChallenge_u24lambda_u242.append(",");
                        String string4 = data.getAuthzId();
                        if (string4 != null) {
                            String it = string4;
                            boolean bl3 = false;
                            $this$evaluateChallenge_u24lambda_u242.append("a=").append(it);
                        }
                        $this$evaluateChallenge_u24lambda_u242.append(",");
                        String string5 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                        sCRAMData.setGs2Header(string5);
                        $this$evaluateChallenge_u24lambda_u242 = stringBuilder3 = new StringBuilder();
                        sCRAMData = data;
                        boolean bl4 = false;
                        $this$evaluateChallenge_u24lambda_u243.append("n=" + data.getAuthcId() + ",");
                        $this$evaluateChallenge_u24lambda_u243.append("r=" + data.getConce());
                        String string6 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply(builderAction).toString()");
                        sCRAMData.setClientFirstMessageBare(string6);
                        data.setStage(data.getStage() + 1);
                        data.getStage();
                        return Base64Kt.toBase64(data.getGs2Header() + data.getClientFirstMessageBare());
                    }
                    if (data.getStage() != 1) break block57;
                    if (input == null) {
                        throw new ClientSaslException("Unexpected empty input!");
                    }
                    serverFirstMessage = StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input));
                    MatchResult matchResult = this.serverFirstMessageRegex.matchEntire((CharSequence)serverFirstMessage);
                    if (matchResult == null) {
                        throw new ClientSaslException("Bad challenge syntax");
                    }
                    r2 = matchResult;
                    Object object3 = r2.getGroups().get(2);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        throw new ClientSaslException("Bad challenge syntax: missing nonce");
                    }
                    nonce = object3;
                    object = r2.getGroups().get(3);
                    if (object == null || (object = object.getValue()) == null) break block58;
                    byte[] byArray3 = Base64Kt.fromBase64((CharSequence)object);
                    object = byArray3;
                    if (byArray3 != null) break block59;
                }
                throw new ClientSaslException("Bad challenge syntax: missing salt");
            }
            Object salt = object;
            Object object4 = r2.getGroups().get(4);
            if (object4 == null || (object4 = object4.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax: missing iterations");
            }
            int iterations = Integer.parseInt((String)object4);
            String string = data.getConce();
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.startsWith$default((String)nonce, (String)string, (boolean)false, (int)2, null)) {
                throw new ClientSaslException("Wrong nonce");
            }
            byte[] cBindInput = ArraysKt.plus((byte[])StringsKt.encodeToByteArray((String)String.valueOf(data.getGs2Header())), (byte[])data.getBindData());
            StringBuilder $this$evaluateChallenge_u24lambda_u244 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$evaluateChallenge_u24lambda_u244.append("c=");
            $this$evaluateChallenge_u24lambda_u244.append(Base64Kt.toBase64(cBindInput));
            $this$evaluateChallenge_u24lambda_u244.append(",");
            $this$evaluateChallenge_u24lambda_u244.append("r=");
            $this$evaluateChallenge_u24lambda_u244.append((String)nonce);
            String string7 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
            String clientFinalMessageBare = string7;
            data.setAuthMessage(data.getClientFirstMessageBare() + "," + serverFirstMessage + "," + clientFinalMessageBare);
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byArray2 = PBKDF2.Companion.pbkdf2WithHmacSHA1(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 160).getBytes();
                    break;
                }
                case 2: {
                    byArray2 = PBKDF2.Companion.pbkdf2WithHmacSHA256(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 256).getBytes();
                    break;
                }
                case 3: {
                    byArray2 = PBKDF2.Companion.pbkdf2WithHmacSHA512(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 512).getBytes();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            data.setSaltedPassword(byArray2);
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byte[] byArray4 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray4);
                    hash3 = HMAC.Companion.hmacSHA1(byArray4, this.clientKeyData);
                    break;
                }
                case 2: {
                    byte[] byArray5 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray5);
                    hash3 = HMAC.Companion.hmacSHA256(byArray5, this.clientKeyData);
                    break;
                }
                case 3: {
                    byte[] byArray6 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray6);
                    hash3 = HMAC.Companion.hmacSHA512(byArray6, this.clientKeyData);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] clientKey = hash3.getBytes();
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    hash2 = SHA1Kt.sha1((byte[])clientKey);
                    break;
                }
                case 2: {
                    hash2 = SHA256Kt.sha256((byte[])clientKey);
                    break;
                }
                case 3: {
                    hash2 = SHA512Kt.sha512((byte[])clientKey);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] storedKey = hash2.getBytes();
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    String string8 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string8);
                    hash = HMAC.Companion.hmacSHA1(storedKey, StringsKt.encodeToByteArray((String)string8));
                    break;
                }
                case 2: {
                    String string9 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string9);
                    hash = HMAC.Companion.hmacSHA256(storedKey, StringsKt.encodeToByteArray((String)string9));
                    break;
                }
                case 3: {
                    String string10 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string10);
                    hash = HMAC.Companion.hmacSHA512(storedKey, StringsKt.encodeToByteArray((String)string10));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] clientSignature = hash.getBytes();
            byte[] byArray7 = Arrays.copyOf(clientKey, clientKey.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray7, (String)"copyOf(this, size)");
            byte[] it = byArray = byArray7;
            boolean bl5 = false;
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                it[i] = (byte)(it[i] ^ clientSignature[i]);
            }
            byte[] clientProof = byArray;
            StringBuilder $this$evaluateChallenge_u24lambda_u246 = stringBuilder = new StringBuilder();
            boolean bl6 = false;
            $this$evaluateChallenge_u24lambda_u246.append(clientFinalMessageBare);
            $this$evaluateChallenge_u24lambda_u246.append(",");
            $this$evaluateChallenge_u24lambda_u246.append("p=");
            $this$evaluateChallenge_u24lambda_u246.append(Base64Kt.toBase64(clientProof));
            String string11 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"StringBuilder().apply(builderAction).toString()");
            String clientFinalMessageStep2 = string11;
            data.setStage(data.getStage() + 1);
            data.getStage();
            return Base64Kt.toBase64(clientFinalMessageStep2);
        }
        if (data.getStage() == 2) {
            Hash hash;
            Hash hash4;
            if (input == null) {
                throw new ClientSaslException("Unexpected empty input!");
            }
            MatchResult matchResult = this.serverLastMessageRegex.matchEntire((CharSequence)StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input)));
            if (matchResult == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            MatchResult r = matchResult;
            MatchGroup r2 = r.getGroups().get(1);
            if (r2 != null) {
                MatchGroup it = r2;
                boolean bl = false;
                throw new ClientSaslException("Error: " + it);
            }
            Object object = r.getGroups().get(2);
            if (object == null || (object = object.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            Object v = object;
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byte[] byArray = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray);
                    hash4 = HMAC.Companion.hmacSHA1(byArray, this.serverKeyData);
                    break;
                }
                case 2: {
                    byte[] byArray = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray);
                    hash4 = HMAC.Companion.hmacSHA256(byArray, this.serverKeyData);
                    break;
                }
                case 3: {
                    byte[] byArray = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray);
                    hash4 = HMAC.Companion.hmacSHA512(byArray, this.serverKeyData);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] serverKey = hash4.getBytes();
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    String string = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string);
                    hash = HMAC.Companion.hmacSHA1(serverKey, StringsKt.encodeToByteArray((String)string));
                    break;
                }
                case 2: {
                    String string = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string);
                    hash = HMAC.Companion.hmacSHA256(serverKey, StringsKt.encodeToByteArray((String)string));
                    break;
                }
                case 3: {
                    String string = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string);
                    hash = HMAC.Companion.hmacSHA512(serverKey, StringsKt.encodeToByteArray((String)string));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] serverSignature = hash.getBytes();
            if (!Arrays.equals(serverSignature, Base64Kt.fromBase64((CharSequence)v))) {
                throw new ClientSaslException("Invalid Server Signature");
            }
            data.setStage(data.getStage() + 1);
            data.getStage();
            saslContext.setComplete$halcyon_core(true);
            return null;
        }
        if (saslContext.getComplete() && input == null) {
            return null;
        }
        throw new IllegalStateException("SASL Client in illegal state. stage=" + data.getStage() + " complete=" + saslContext.getComplete());
    }

    @Override
    public boolean isComplete(@NotNull SASLContext saslContext) {
        return SASLMechanism.DefaultImpls.isComplete(this, saslContext);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BindType.values().length];
            try {
                nArray[BindType.N.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsUnique.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsServerEndPoint.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsExporter.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScramHashAlgorithm.values().length];
            try {
                nArray[ScramHashAlgorithm.SHA1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScramHashAlgorithm.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScramHashAlgorithm.SHA512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

