/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.connector.AbstractSocketSessionController;
import tigase.halcyon.core.connector.ConnectionErrorEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.socket.SocketConnectionErrorEvent;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketSessionController;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.StreamError;
import tigase.halcyon.core.xmpp.modules.StreamErrorEvent;
import tigase.halcyon.core.xmpp.modules.StreamFeaturesEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001aH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ltigase/halcyon/core/connector/socket/SocketSessionController;", "Ltigase/halcyon/core/connector/AbstractSocketSessionController;", "halcyon", "Ltigase/halcyon/core/AbstractHalcyon;", "connector", "Ltigase/halcyon/core/connector/socket/SocketConnector;", "(Ltigase/halcyon/core/AbstractHalcyon;Ltigase/halcyon/core/connector/socket/SocketConnector;)V", "<set-?>", "", "seeOtherHostUrl", "getSeeOtherHostUrl", "()Ljava/lang/String;", "isTLSAvailable", "", "features", "Ltigase/halcyon/core/xml/Element;", "processAuthSuccessfull", "", "event", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEvent$SASLSuccess;", "processConnectionError", "Ltigase/halcyon/core/connector/ConnectionErrorEvent;", "processSeeOtherHost", "Ltigase/halcyon/core/xmpp/modules/StreamErrorEvent;", "processStreamError", "processStreamFeaturesEvent", "Ltigase/halcyon/core/xmpp/modules/StreamFeaturesEvent;", "halcyon-core"})
public final class SocketSessionController
extends AbstractSocketSessionController {
    @NotNull
    private final SocketConnector connector;
    @Nullable
    private String seeOtherHostUrl;

    public SocketSessionController(@NotNull AbstractHalcyon halcyon, @NotNull SocketConnector connector) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        super(halcyon, "tigase.halcyon.core.connector.socket.SocketSessionController");
        this.connector = connector;
    }

    @Nullable
    public final String getSeeOtherHostUrl() {
        return this.seeOtherHostUrl;
    }

    @Override
    protected void processAuthSuccessfull(@NotNull SASLEvent.SASLSuccess event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.connector.restartStream();
    }

    private final boolean isTLSAvailable(Element features) {
        return features.getChildrenNS("starttls", "urn:ietf:params:xml:ns:xmpp-tls") != null;
    }

    @Override
    protected void processConnectionError(@NotNull ConnectionErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger.DefaultImpls.fine$default(this.getLog(), null, (Function0)new Function0<Object>(event){
            final /* synthetic */ ConnectionErrorEvent $event;
            {
                this.$event = $event;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Received connector exception: " + this.$event;
            }
        }, 1, null);
        this.getHalcyon().clear$halcyon_core(Scope.Connection);
        if (event instanceof SocketConnectionErrorEvent.HostNotFount) {
            Logger.DefaultImpls.info$default(this.getLog(), null, processConnectionError.2.INSTANCE, 1, null);
            this.getHalcyon().getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Cannot find server in DNS"));
        } else {
            this.getHalcyon().getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Connection error", false, false, 6, null));
        }
    }

    @Override
    protected void processStreamFeaturesEvent(@NotNull StreamFeaturesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean connectionSecured = this.connector.getSecured();
        boolean tlsAvailable = this.isTLSAvailable(event.getFeatures());
        if (!connectionSecured && tlsAvailable) {
            this.connector.startTLS();
        } else {
            super.processStreamFeaturesEvent(event);
        }
    }

    @Override
    protected void processStreamError(@NotNull StreamErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (WhenMappings.$EnumSwitchMapping$0[event.getCondition().ordinal()] == 1) {
            this.processSeeOtherHost(event);
        } else {
            super.processStreamError(event);
        }
    }

    private final void processSeeOtherHost(StreamErrorEvent event) {
        String url = event.getErrorElement().getValue();
        this.getHalcyon().getInternalDataStore().setData(Scope.Session, "tigase.halcyon.core.connector.socket.SocketConnector#seeOtherHost", url);
        this.getHalcyon().getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("see-other-host: " + url, true, true));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StreamError.values().length];
            try {
                nArray[StreamError.SEE_OTHER_HOST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

