/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ServerOnlyTlsAuthentication;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.socket.DefaultTLSProcessorKt;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessor;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.connector.socket.XMPPHostnameVerifier;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0004J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010 \u001a\u00020\u000eH\u0016J&\u0010!\u001a\u00020\u00142\u001c\u0010\"\u001a\u0018\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00140#j\u0002`&H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor;", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "(Ljava/net/Socket;Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;)V", "log", "Ltigase/halcyon/core/logger/Logger;", "peerCertificates", "", "Ljava/security/cert/X509Certificate;", "[Ljava/security/cert/X509Certificate;", "secured", "", "tlsExporter", "", "tlsServerEndpoint", "tlsUnique", "clear", "", "convertChain", "certificates", "Lorg/bouncycastle/tls/Certificate;", "(Lorg/bouncycastle/tls/Certificate;)[Ljava/security/cert/X509Certificate;", "getAuthType", "", "tlsKeyExchange", "Lorg/bouncycastle/tls/TlsKeyExchange;", "getTlsExporter", "getTlsServerEndpoint", "getTlsUnique", "isConnectionSecure", "proceedTLS", "callback", "Lkotlin/Function2;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "Ltigase/halcyon/core/connector/socket/TLSCallback;", "Companion", "XMPPServerAuthentication", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nBouncyCastleTLSProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,162:1\n1#2:163\n37#3,2:164\n*S KotlinDebug\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor\n*L\n101#1:164,2\n*E\n"})
public final class BouncyCastleTLSProcessor
implements TLSProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Socket socket;
    @NotNull
    private final SocketConnectorConfig config;
    @NotNull
    private final Logger log;
    @Nullable
    private X509Certificate[] peerCertificates;
    private boolean secured;
    @Nullable
    private byte[] tlsUnique;
    @Nullable
    private byte[] tlsServerEndpoint;
    @Nullable
    private byte[] tlsExporter;
    @NotNull
    private static final String NAME = "BouncyCastleTLSProcessor";

    public BouncyCastleTLSProcessor(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.socket = socket;
        this.config = config;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.BouncyCastleTLSProcessor", false, 2, null);
    }

    @Override
    @Nullable
    public byte[] getTlsUnique() {
        return this.tlsUnique;
    }

    @Override
    @Nullable
    public byte[] getTlsServerEndpoint() {
        byte[] byArray;
        if (this.tlsServerEndpoint != null) {
            return this.tlsServerEndpoint;
        }
        BouncyCastleTLSProcessor bouncyCastleTLSProcessor = this;
        Object object = this.peerCertificates;
        if (this.peerCertificates != null && (object = (X509Certificate)ArraysKt.first((Object[])object)) != null) {
            Object it = object;
            BouncyCastleTLSProcessor bouncyCastleTLSProcessor2 = bouncyCastleTLSProcessor;
            boolean bl = false;
            byArray = DefaultTLSProcessorKt.calculateCertificateHash((X509Certificate)it);
            bouncyCastleTLSProcessor = bouncyCastleTLSProcessor2;
        } else {
            byArray = null;
        }
        bouncyCastleTLSProcessor.tlsServerEndpoint = byArray;
        return this.tlsServerEndpoint;
    }

    @Override
    @Nullable
    public byte[] getTlsExporter() {
        return this.tlsExporter;
    }

    @Override
    public boolean isConnectionSecure() {
        return this.secured;
    }

    @Override
    public void clear() {
        this.secured = false;
    }

    @Override
    public void proceedTLS(@NotNull Function2<? super InputStream, ? super OutputStream, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.log.info("Proceeding TLS with Bouncycastle");
        BcTlsCrypto tlsCrypto = new BcTlsCrypto(new SecureRandom());
        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(this.socket.getInputStream(), this.socket.getOutputStream());
        DefaultTlsClient tlsClient2 = new DefaultTlsClient(tlsCrypto, this){
            final /* synthetic */ BouncyCastleTLSProcessor this$0;
            {
                this.this$0 = $receiver;
                super((TlsCrypto)$tlsCrypto);
            }

            @NotNull
            public TlsAuthentication getAuthentication() {
                return (TlsAuthentication)this.this$0.new XMPPServerAuthentication();
            }

            public void notifyHandshakeComplete() {
                block0: {
                    super.notifyHandshakeComplete();
                    BouncyCastleTLSProcessor.access$setSecured$p(this.this$0, true);
                    BouncyCastleTLSProcessor.access$setTlsExporter$p(this.this$0, this.context.exportChannelBinding(3));
                    BouncyCastleTLSProcessor.access$setTlsUnique$p(this.this$0, this.context.exportChannelBinding(1));
                    byte[] byArray = this.context.exportChannelBinding(0);
                    if (byArray == null) break block0;
                    byte[] byArray2 = byArray;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor = this.this$0;
                    byte[] it = byArray2;
                    boolean bl = false;
                    BouncyCastleTLSProcessor.access$setTlsServerEndpoint$p(bouncyCastleTLSProcessor, it);
                }
            }
        };
        tlsClientProtocol.connect((TlsClient)tlsClient2);
        InputStream inputStream = tlsClientProtocol.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"tlsClientProtocol.inputStream");
        OutputStream outputStream = tlsClientProtocol.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"tlsClientProtocol.outputStream");
        callback.invoke((Object)inputStream, (Object)outputStream);
    }

    private final X509Certificate[] convertChain(Certificate certificates) throws CertificateException, IOException {
        List result = new ArrayList();
        int n = certificates.getLength();
        for (int i = 0; i < n; ++i) {
            TlsCertificate cert = certificates.getCertificateAt(i);
            java.security.cert.Certificate jsCert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            Collection collection = result;
            Intrinsics.checkNotNull((Object)jsCert, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)jsCert);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new X509Certificate[0]);
    }

    @Nullable
    protected final String getAuthType(@Nullable TlsKeyExchange tlsKeyExchange) {
        Object object;
        try {
            Object object2;
            Field keyExchangeField = AbstractTlsKeyExchange.class.getDeclaredField("keyExchange");
            keyExchangeField.setAccessible(true);
            Object v = keyExchangeField.get(tlsKeyExchange);
            int i = Integer.parseInt(v.toString());
            switch (i) {
                case 0: {
                    object2 = "NULL";
                    break;
                }
                case 1: {
                    object2 = "RSA";
                    break;
                }
                case 2: {
                    object2 = "RSA_EXPORT";
                    break;
                }
                case 3: {
                    object2 = "DHE_DSS";
                    break;
                }
                case 4: {
                    object2 = "DHE_DSS_EXPORT";
                    break;
                }
                case 5: {
                    object2 = "DHE_RSA";
                    break;
                }
                case 6: {
                    object2 = "DHE_RSA_EXPORT";
                    break;
                }
                case 7: {
                    object2 = "DH_DSS";
                    break;
                }
                case 8: {
                    object2 = "DH_DSS_EXPORT";
                    break;
                }
                case 9: {
                    object2 = "DH_RSA";
                    break;
                }
                case 10: {
                    object2 = "DH_RSA_EXPORT";
                    break;
                }
                case 11: {
                    object2 = "DH_anon";
                    break;
                }
                case 12: {
                    object2 = "DH_anon_EXPORT";
                    break;
                }
                case 13: {
                    object2 = "PSK";
                    break;
                }
                case 14: {
                    object2 = "DHE_PSK";
                    break;
                }
                case 15: {
                    object2 = "RSA_PSK";
                    break;
                }
                case 16: {
                    object2 = "ECDH_ECDSA";
                    break;
                }
                case 17: {
                    object2 = "ECDHE_ECDSA";
                    break;
                }
                case 18: {
                    object2 = "ECDH_RSA";
                    break;
                }
                case 19: {
                    object2 = "ECDHE_RSA";
                    break;
                }
                case 20: {
                    object2 = "ECDH_anon";
                    break;
                }
                case 21: {
                    object2 = "SRP";
                    break;
                }
                case 22: {
                    object2 = "SRP_DSS";
                    break;
                }
                case 23: {
                    object2 = "SRP_RSA";
                    break;
                }
                case 24: {
                    object2 = "ECDHE_PSK";
                    break;
                }
                default: {
                    object2 = "UNKNOWN " + i;
                }
            }
            object = object2;
        }
        catch (Throwable e) {
            e.printStackTrace();
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ void access$setSecured$p(BouncyCastleTLSProcessor $this, boolean bl) {
        $this.secured = bl;
    }

    public static final /* synthetic */ void access$setTlsExporter$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsExporter = byArray;
    }

    public static final /* synthetic */ void access$setTlsUnique$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsUnique = byArray;
    }

    public static final /* synthetic */ void access$setTlsServerEndpoint$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsServerEndpoint = byArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$Companion;", "Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "create", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "halcyon-core"})
    public static final class Companion
    implements TLSProcessorFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public String getNAME() {
            return NAME;
        }

        @Override
        @NotNull
        public TLSProcessor create(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new BouncyCastleTLSProcessor(socket, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$XMPPServerAuthentication;", "Lorg/bouncycastle/tls/ServerOnlyTlsAuthentication;", "(Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor;)V", "notifyServerCertificate", "", "serverCertificate", "Lorg/bouncycastle/tls/TlsServerCertificate;", "halcyon-core"})
    @SourceDebugExtension(value={"SMAP\nBouncyCastleTLSProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$XMPPServerAuthentication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
    public final class XMPPServerAuthentication
    extends ServerOnlyTlsAuthentication {
        /*
         * WARNING - void declaration
         */
        public void notifyServerCertificate(@Nullable TlsServerCertificate serverCertificate) {
            X509Certificate[] x509CertificateArray;
            BouncyCastleTLSProcessor bouncyCastleTLSProcessor;
            block6: {
                block5: {
                    void it;
                    bouncyCastleTLSProcessor = BouncyCastleTLSProcessor.this;
                    x509CertificateArray = serverCertificate;
                    if (serverCertificate == null || (x509CertificateArray = x509CertificateArray.getCertificate()) == null) break block5;
                    X509Certificate[] x509CertificateArray2 = x509CertificateArray;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor2 = BouncyCastleTLSProcessor.this;
                    X509Certificate[] x509CertificateArray3 = x509CertificateArray2;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor3 = bouncyCastleTLSProcessor;
                    boolean bl = false;
                    X509Certificate[] x509CertificateArray4 = bouncyCastleTLSProcessor2.convertChain((Certificate)it);
                    bouncyCastleTLSProcessor = bouncyCastleTLSProcessor3;
                    x509CertificateArray = x509CertificateArray4;
                    if (x509CertificateArray4 != null) break block6;
                }
                throw new SSLHandshakeException("Unrecognized server certificates list.");
            }
            bouncyCastleTLSProcessor.peerCertificates = x509CertificateArray;
            if (BouncyCastleTLSProcessor.this.config.getTrustManager() instanceof X509TrustManager) {
                X509TrustManager x509TrustManager = (X509TrustManager)BouncyCastleTLSProcessor.this.config.getTrustManager();
                X509Certificate[] x509CertificateArray5 = BouncyCastleTLSProcessor.this.peerCertificates;
                Intrinsics.checkNotNull((Object)x509CertificateArray5);
                x509TrustManager.checkServerTrusted(x509CertificateArray5, "");
            }
            XMPPHostnameVerifier xMPPHostnameVerifier = BouncyCastleTLSProcessor.this.config.getHostnameVerifier();
            String string = BouncyCastleTLSProcessor.this.config.getDomain();
            Object[] objectArray = BouncyCastleTLSProcessor.this.peerCertificates;
            Intrinsics.checkNotNull((Object)objectArray);
            if (!xMPPHostnameVerifier.verify(string, (java.security.cert.Certificate)ArraysKt.first((Object[])objectArray))) {
                throw new SSLHandshakeException("Certificate hostname doesn't match domain name you want to connect.");
            }
        }
    }
}

