/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core;

import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.HalcyonStateChangeEvent;
import tigase.halcyon.core.builder.ConfigurationBuilder;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.exceptions.AuthenticationException;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\b\u0010\u0014\u001a\u00020\u0010H\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Ltigase/halcyon/core/Halcyon;", "Ltigase/halcyon/core/AbstractHalcyon;", "configuration", "Ltigase/halcyon/core/builder/ConfigurationBuilder;", "(Ltigase/halcyon/core/builder/ConfigurationBuilder;)V", "lock", "Ljava/lang/Object;", "log", "Ltigase/halcyon/core/logger/Logger;", "tickTask", "Ljava/util/TimerTask;", "timer", "Ljava/util/Timer;", "getTimer", "()Ljava/util/Timer;", "connectAndWait", "", "createConnector", "Ltigase/halcyon/core/connector/AbstractConnector;", "onConnecting", "onDisconnecting", "reconnect", "immediately", "", "waitForAllResponses", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nHalcyon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Halcyon.kt\ntigase/halcyon/core/Halcyon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class Halcyon
extends AbstractHalcyon {
    @NotNull
    private final Logger log;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Object lock;
    private TimerTask tickTask;

    public Halcyon(@NotNull ConfigurationBuilder configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration);
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.Halcyon", false, 2, null);
        this.timer = new Timer("timer", true);
        this.lock = new Object();
        this.getEventBus().setMode(EventBus.Mode.ThreadPerHandler);
    }

    @Override
    @NotNull
    protected AbstractConnector createConnector() {
        ConnectionConfig connectionConfig = this.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        TLSProcessorFactory tlsProcessorFactory = ((SocketConnectorConfig)connectionConfig).getTlsProcessorFactory();
        this.log.fine("Selected TLS Processor: " + tlsProcessorFactory.getNAME());
        return new SocketConnector(this, tlsProcessorFactory);
    }

    @Override
    public void reconnect(boolean immediately) {
        Logger.DefaultImpls.finer$default(this.log, null, (Function0)new Function0<Object>(immediately){
            final /* synthetic */ boolean $immediately;
            {
                this.$immediately = $immediately;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Called reconnect. immediately=" + this.$immediately;
            }
        }, 1, null);
        if (!immediately) {
            Thread.sleep(3000L);
        }
        this.setState$halcyon_core(AbstractHalcyon.State.Connecting);
        this.startConnector();
    }

    @NotNull
    public final Timer getTimer() {
        return this.timer;
    }

    @Override
    protected void onConnecting() {
        super.onConnecting();
        this.tickTask = new TimerTask(this){
            final /* synthetic */ Halcyon this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                this.this$0.tick();
            }
        };
        TimerTask timerTask = this.tickTask;
        if (timerTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tickTask");
            timerTask = null;
        }
        this.timer.scheduleAtFixedRate(timerTask, 2000L, 2000L);
    }

    @Override
    protected void onDisconnecting() {
        TimerTask timerTask = this.tickTask;
        if (timerTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tickTask");
            timerTask = null;
        }
        timerTask.cancel();
        super.onDisconnecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllResponses() {
        while (this.getRequestsManager().getWaitingRequestsSize() > 0) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.lock.wait(100L);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectAndWait() {
        Ref.ObjectRef exceptionToThrow = new Ref.ObjectRef();
        EventHandler<Event> handler2 = new EventHandler<Event>((Ref.ObjectRef<Throwable>)exceptionToThrow, this){
            final /* synthetic */ Ref.ObjectRef<Throwable> $exceptionToThrow;
            final /* synthetic */ Halcyon this$0;
            {
                this.$exceptionToThrow = $exceptionToThrow;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof SASLEvent.SASLError) {
                    SASLModule.SASLError sASLError = ((SASLEvent.SASLError)event).getError();
                    String string = ((SASLEvent.SASLError)event).getDescription();
                    if (string == null) {
                        string = "Authentication error";
                    }
                    this.$exceptionToThrow.element = new AuthenticationException(sASLError, string);
                } else if (event instanceof HalcyonStateChangeEvent && (((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Connected || ((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Stopped)) {
                    Object object = Halcyon.access$getLock$p(this.this$0);
                    Halcyon halcyon = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        Halcyon.access$getLock$p(halcyon).notify();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        };
        try {
            EventBusInterface.DefaultImpls.register$default((EventBusInterface)this.getEventBus(), null, handler2, 1, null);
            super.connect();
            Object object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-Halcyon$connectAndWait$22 = false;
                this.lock.wait(30000L);
                Unit $i$a$-synchronized-Halcyon$connectAndWait$22 = Unit.INSTANCE;
            }
            Throwable throwable = (Throwable)exceptionToThrow.element;
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
            if (this.getState() != AbstractHalcyon.State.Connected && this.getState() != AbstractHalcyon.State.Stopped) {
                throw new HalcyonException("Cannot connect to XMPP server.");
            }
        }
        finally {
            this.getEventBus().unregister(handler2);
        }
    }

    public static final /* synthetic */ Object access$getLock$p(Halcyon $this) {
        return $this.lock;
    }
}

