/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.Reader;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.ConnectorException;
import tigase.halcyon.core.connector.socket.SocketWorker;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.parser.StreamParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020\u000fH\u0016J\b\u0010#\u001a\u00020\u000fH\u0016J\u001d\u0010$\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b%R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R,\u0010\u0014\u001a\u0014\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Ltigase/halcyon/core/connector/socket/SocketWorker;", "Ljava/lang/Thread;", "parser", "Ltigase/halcyon/core/xml/parser/StreamParser;", "(Ltigase/halcyon/core/xml/parser/StreamParser;)V", "value", "", "isActive", "()Z", "setActive", "(Z)V", "log", "Ltigase/halcyon/core/logger/Logger;", "onActiveChange", "Lkotlin/Function1;", "", "getOnActiveChange", "()Lkotlin/jvm/functions/Function1;", "setOnActiveChange", "(Lkotlin/jvm/functions/Function1;)V", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getOnError", "setOnError", "<set-?>", "Ljava/io/Reader;", "reader", "getReader", "()Ljava/io/Reader;", "Ljava/io/Writer;", "writer", "getWriter", "()Ljava/io/Writer;", "interrupt", "run", "setReaderAndWriter", "setReaderAndWriter$halcyon_core", "halcyon-core"})
public final class SocketWorker
extends Thread {
    @NotNull
    private final StreamParser parser;
    @NotNull
    private final Logger log;
    @Nullable
    private Function1<? super Boolean, Unit> onActiveChange;
    private boolean isActive;
    private Reader reader;
    private Writer writer;
    @Nullable
    private Function1<? super Exception, Unit> onError;

    public SocketWorker(@NotNull StreamParser parser2) {
        Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
        this.parser = parser2;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.SocketWorker", false, 2, null);
        this.setName("Socket-Worker-Thread");
        this.setDaemon(true);
    }

    @Nullable
    public final Function1<Boolean, Unit> getOnActiveChange() {
        return this.onActiveChange;
    }

    public final void setOnActiveChange(@Nullable Function1<? super Boolean, Unit> function1) {
        this.onActiveChange = function1;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final void setActive(boolean value) {
        block1: {
            boolean tmp2 = this.isActive;
            this.isActive = value;
            if (tmp2 == this.isActive) break block1;
            Function1<? super Boolean, Unit> function1 = this.onActiveChange;
            if (function1 != null) {
                function1.invoke((Object)this.isActive);
            }
        }
    }

    @NotNull
    public final Reader getReader() {
        Reader reader = this.reader;
        if (reader != null) {
            return reader;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
        return null;
    }

    @NotNull
    public final Writer getWriter() {
        Writer writer = this.writer;
        if (writer != null) {
            return writer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
        return null;
    }

    @Nullable
    public final Function1<Exception, Unit> getOnError() {
        return this.onError;
    }

    public final void setOnError(@Nullable Function1<? super Exception, Unit> function1) {
        this.onError = function1;
    }

    public final void setReaderAndWriter$halcyon_core(@NotNull Reader reader, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.reader = reader;
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.DefaultImpls.fine$default(this.log, null, run.1.INSTANCE, 1, null);
        char[] buffer = new char[10240];
        try {
            this.setActive(true);
            block8: while (this.isActive && !Thread.interrupted() && this.isAlive()) {
                int len = this.getReader().read(buffer);
                switch (len) {
                    case -1: {
                        Logger.DefaultImpls.finest$default(this.log, null, run.2.INSTANCE, 1, null);
                        break block8;
                    }
                    default: {
                        if (!this.isActive || Thread.interrupted() || !this.isAlive()) continue block8;
                        this.parser.parse(buffer, 0, len - 1);
                        continue block8;
                    }
                }
            }
            if (this.isActive) {
                Logger.DefaultImpls.warning$default(this.log, null, run.3.INSTANCE, 1, null);
                Function1<? super Exception, Unit> function1 = this.onError;
                if (function1 != null) {
                    function1.invoke((Object)new ConnectorException("Unexpected stop!"));
                }
            }
        }
        catch (Exception e) {
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ SocketWorker this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Exception in worker: isActive=" + this.this$0.isActive() + " interrupted=" + !Thread.interrupted();
                }
            }, 1, null);
            if (this.isActive) {
                this.log.fine(e, (Function0<? extends Object>)((Function0)run.5.INSTANCE));
                Function1<? super Exception, Unit> function1 = this.onError;
                if (function1 != null) {
                    function1.invoke((Object)e);
                }
            }
        }
        finally {
            this.setActive(false);
            Logger.DefaultImpls.fine$default(this.log, null, run.6.INSTANCE, 1, null);
        }
    }

    @Override
    public void interrupt() {
        this.setActive(false);
        super.interrupt();
    }
}

