/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minidns.dnssec.DnssecValidationFailedException;
import tigase.halcyon.core.Halcyon;
import tigase.halcyon.core.configuration.ConfigurationKt;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.ChannelBindingDataProvider;
import tigase.halcyon.core.connector.ParseErrorEvent;
import tigase.halcyon.core.connector.ReceivedXMLElementEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.SrvRecord;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.connector.StreamStartedEvent;
import tigase.halcyon.core.connector.StreamTerminatedEvent;
import tigase.halcyon.core.connector.socket.HostNotFound;
import tigase.halcyon.core.connector.socket.SocketConnectionErrorEvent;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.SocketSessionController;
import tigase.halcyon.core.connector.socket.SocketWorker;
import tigase.halcyon.core.connector.socket.TLSProcessor;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.excutor.TickExecutor;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xml.parser.StreamParser;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00af\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005*\u0001\r\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020 2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020 0%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010+H\u0016J\n\u0010-\u001a\u0004\u0018\u00010+H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016J\b\u0010/\u001a\u00020 H\u0002J\u0014\u00100\u001a\u00020 2\n\u0010(\u001a\u000601j\u0002`2H\u0002J\b\u00103\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0002J2\u00108\u001a\u00020 2(\u0010$\u001a$\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:j\u0002`=09\u0012\u0004\u0012\u00020 0%H\u0002J\u0006\u0010>\u001a\u00020 J\u0010\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020 H\u0016J\u0006\u0010C\u001a\u00020 J\b\u0010D\u001a\u00020 H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector;", "Ltigase/halcyon/core/connector/AbstractConnector;", "Ltigase/halcyon/core/connector/ChannelBindingDataProvider;", "halcyon", "Ltigase/halcyon/core/Halcyon;", "tlsProcesorFactory", "Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "(Ltigase/halcyon/core/Halcyon;Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;)V", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "log", "Ltigase/halcyon/core/logger/Logger;", "parser", "tigase/halcyon/core/connector/socket/SocketConnector$parser$1", "Ltigase/halcyon/core/connector/socket/SocketConnector$parser$1;", "secured", "", "getSecured", "()Z", "socket", "Ljava/net/Socket;", "started", "tlsProcesor", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "getTlsProcesorFactory", "()Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "whiteSpaceEnabled", "whitespacePingExecutor", "Ltigase/halcyon/core/excutor/TickExecutor;", "worker", "Ltigase/halcyon/core/connector/socket/SocketWorker;", "closeStream", "", "createSessionController", "Ltigase/halcyon/core/connector/SessionController;", "createSocket", "completionHandler", "Lkotlin/Function1;", "createSocketConnectionErrorEvent", "Ltigase/halcyon/core/connector/socket/SocketConnectionErrorEvent;", "cause", "", "getTlsExporter", "", "getTlsServerEndpoint", "getTlsUnique", "isConnectionSecure", "onTick", "onWorkerException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "proceedTLS", "processReceivedElement", "element", "Ltigase/halcyon/core/xml/Element;", "processTLSStanza", "resolveTarget", "", "Lkotlin/Pair;", "", "", "Ltigase/halcyon/core/connector/socket/HostPort;", "restartStream", "send", "data", "", "start", "startTLS", "stop", "Companion", "halcyon-core"})
public final class SocketConnector
extends AbstractConnector
implements ChannelBindingDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TLSProcessorFactory tlsProcesorFactory;
    @Nullable
    private TLSProcessor tlsProcesor;
    private boolean started;
    @NotNull
    private final Logger log;
    @Nullable
    private Socket socket;
    @Nullable
    private SocketWorker worker;
    @NotNull
    private final TickExecutor whitespacePingExecutor;
    private boolean whiteSpaceEnabled;
    @NotNull
    private SocketConnectorConfig config;
    @NotNull
    private final parser.1 parser;
    @NotNull
    public static final String SEE_OTHER_HOST_KEY = "tigase.halcyon.core.connector.socket.SocketConnector#seeOtherHost";
    @NotNull
    public static final String XMLNS_START_TLS = "urn:ietf:params:xml:ns:xmpp-tls";

    public SocketConnector(@NotNull Halcyon halcyon, @NotNull TLSProcessorFactory tlsProcesorFactory) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)tlsProcesorFactory, (String)"tlsProcesorFactory");
        super(halcyon);
        this.tlsProcesorFactory = tlsProcesorFactory;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.SocketConnector", false, 2, null);
        this.whitespacePingExecutor = new TickExecutor(halcyon.getEventBus(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Function0)new Function0<Unit>(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SocketConnector.access$onTick(this.this$0);
            }
        }, null);
        this.whiteSpaceEnabled = true;
        ConnectionConfig connectionConfig = halcyon.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        this.config = (SocketConnectorConfig)connectionConfig;
        this.parser = new StreamParser(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
            }

            private final void logReceivedStanza(Element element2) {
                if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINEST)) {
                    SocketConnector.access$getLog$p(this.this$0).finest("Received element " + Element.DefaultImpls.getAsString$default(element2, 0, false, 3, null));
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINER)) {
                    SocketConnector.access$getLog$p(this.this$0).finer("Received element " + element2.getAsString(3, false));
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINE)) {
                    SocketConnector.access$getLog$p(this.this$0).fine("Received element " + element2.getAsString(2, false));
                }
            }

            public void onNextElement(@NotNull Element element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                this.logReceivedStanza(element2);
                SocketConnector.access$processReceivedElement(this.this$0, element2);
            }

            public void onStreamClosed() {
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, parser.onStreamClosed.1.INSTANCE, 1, null);
                SocketConnector.access$fire(this.this$0, new StreamTerminatedEvent());
            }

            public void onStreamStarted(@NotNull Map<String, String> attrs) {
                Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(attrs){
                    final /* synthetic */ Map<String, String> $attrs;
                    {
                        this.$attrs = $attrs;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stream started: " + this.$attrs;
                    }
                }, 1, null);
                SocketConnector.access$fire(this.this$0, new StreamStartedEvent(attrs));
            }

            public void onParseError(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                Logger.DefaultImpls.finest$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(errorMessage){
                    final /* synthetic */ String $errorMessage;
                    {
                        this.$errorMessage = $errorMessage;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Parse error: " + this.$errorMessage;
                    }
                }, 1, null);
                SocketConnector.access$fire(this.this$0, new ParseErrorEvent(errorMessage));
            }
        };
    }

    @NotNull
    public final TLSProcessorFactory getTlsProcesorFactory() {
        return this.tlsProcesorFactory;
    }

    public final boolean getSecured() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return tLSProcessor != null ? tLSProcessor.isConnectionSecure() : false;
    }

    private final void processReceivedElement(Element element2) {
        if (Intrinsics.areEqual((Object)element2.getXmlns(), (Object)XMLNS_START_TLS)) {
            this.processTLSStanza(element2);
        } else {
            this.fire(new ReceivedXMLElementEvent(element2));
        }
    }

    private final void processTLSStanza(Element element2) {
        String string = element2.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"proceed")) {
            this.proceedTLS();
        } else if (Intrinsics.areEqual((Object)string, (Object)"failure")) {
            Logger.DefaultImpls.warning$default(this.log, null, processTLSStanza.1.INSTANCE, 1, null);
            this.fire(new SocketConnectionErrorEvent.TLSFailureEvent());
        } else {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void proceedTLS() {
        Logger.DefaultImpls.info$default(this.log, null, proceedTLS.1.INSTANCE, 1, null);
        try {
            Unit unit;
            Logger.DefaultImpls.finest$default(this.log, null, proceedTLS.2.INSTANCE, 1, null);
            this.whiteSpaceEnabled = false;
            TLSProcessor tLSProcessor = this.tlsProcesor;
            if (tLSProcessor != null) {
                tLSProcessor.proceedTLS((Function2<? super InputStream, ? super OutputStream, Unit>)((Function2)new Function2<InputStream, OutputStream, Unit>(this){
                    final /* synthetic */ SocketConnector this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
                        Unit unit;
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        SocketWorker socketWorker = SocketConnector.access$getWorker$p(this.this$0);
                        if (socketWorker != null) {
                            socketWorker.setReaderAndWriter$halcyon_core(new InputStreamReader(inputStream), new OutputStreamWriter(outputStream));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit == null) {
                            throw new HalcyonException("Socket worker not initialized");
                        }
                    }
                }));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new HalcyonException("TLS Processor not initialized");
            }
            this.restartStream();
        }
        catch (Throwable e) {
            this.setState(State.Disconnecting);
            this.fire(this.createSocketConnectionErrorEvent(e));
        }
        finally {
            Logger.DefaultImpls.finest$default(this.log, null, proceedTLS.4.INSTANCE, 1, null);
            this.whiteSpaceEnabled = true;
        }
    }

    @Override
    @NotNull
    public SessionController createSessionController() {
        return new SocketSessionController(this.getHalcyon(), this);
    }

    private final void resolveTarget(Function1<? super List<Pair<String, Integer>>, Unit> completionHandler) {
        String location;
        List hosts = new ArrayList();
        Object object = (StreamManagementModule)this.getHalcyon().getModuleOrNull(StreamManagementModule.Companion);
        String string = object != null && (object = ((StreamManagementModule)object).getResumptionContext()) != null ? ((StreamManagementModule.ResumptionContext)object).getLocation() : (location = null);
        if (location != null) {
            ((Collection)hosts).add(new Pair((Object)location, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(location, this){
                final /* synthetic */ String $location;
                final /* synthetic */ SocketConnector this$0;
                {
                    this.$location = $location;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + this.$location + ":" + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        String seeOther = (String)this.getHalcyon().getInternalDataStore().getData(SEE_OTHER_HOST_KEY);
        if (seeOther != null) {
            ((Collection)hosts).add(new Pair((Object)seeOther, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(seeOther, this){
                final /* synthetic */ String $seeOther;
                final /* synthetic */ SocketConnector this$0;
                {
                    this.$seeOther = $seeOther;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + this.$seeOther + ":" + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        if (this.config.getHostname() != null) {
            Collection collection = hosts;
            String string2 = this.config.getHostname();
            Intrinsics.checkNotNull((Object)string2);
            collection.add(new Pair((Object)string2, (Object)this.config.getPort()));
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ SocketConnector this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Using host " + SocketConnector.access$getConfig$p(this.this$0).getHostname() + ":" + SocketConnector.access$getConfig$p(this.this$0).getPort();
                }
            }, 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Resolving DNS of " + SocketConnector.access$getConfig$p(this.this$0).getDomain();
            }
        }, 1, null);
        this.config.getDnsResolver().resolve(this.config.getDomain(), (Function1<? super Result<? extends List<SrvRecord>>, Unit>)((Function1)new Function1<Result<? extends List<? extends SrvRecord>>, Unit>(completionHandler, (List<Pair<String, Integer>>)hosts, this){
            final /* synthetic */ Function1<List<Pair<String, Integer>>, Unit> $completionHandler;
            final /* synthetic */ List<Pair<String, Integer>> $hosts;
            final /* synthetic */ SocketConnector this$0;
            {
                this.$completionHandler = $completionHandler;
                this.$hosts = $hosts;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Object result) {
                Object it;
                Object object = result;
                List<Pair<String, Integer>> list = this.$hosts;
                SocketConnector socketConnector = this.this$0;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    it = throwable2;
                    boolean bl = false;
                    ((Collection)list).add(new Pair((Object)SocketConnector.access$getConfig$p(socketConnector).getDomain(), (Object)SocketConnector.access$getConfig$p(socketConnector).getPort()));
                }
                object = result;
                list = this.$hosts;
                if (Result.isSuccess-impl((Object)object)) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List it2 = (List)object;
                    boolean bl = false;
                    it = CollectionsKt.shuffled((Iterable)it2);
                    List<Pair<String, Integer>> list2 = list;
                    boolean $i$f$map = false;
                    void var9_11 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        SrvRecord srvRecord = (SrvRecord)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(new Pair((Object)it3.getTarget(), (Object)it3.getPort-pVg5ArA()));
                    }
                    list2.addAll((List)destination$iv$iv);
                }
                this.$completionHandler.invoke(this.$hosts);
            }
        }));
    }

    private final void createSocket(Function1<? super Socket, Unit> completionHandler) {
        this.resolveTarget((Function1<? super List<Pair<String, Integer>>, Unit>)((Function1)new Function1<List<? extends Pair<? extends String, ? extends Integer>>, Unit>(this, completionHandler){
            final /* synthetic */ SocketConnector this$0;
            final /* synthetic */ Function1<Socket, Unit> $completionHandler;
            {
                this.this$0 = $receiver;
                this.$completionHandler = $completionHandler;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<Pair<String, Integer>> hosts) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
                Iterable iterable = hosts;
                SocketConnector socketConnector = this.this$0;
                Function1<Socket, Unit> function1 = this.$completionHandler;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair hp = (Pair)element$iv;
                    boolean bl = false;
                    try {
                        Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(socketConnector), null, (Function0)new Function0<Object>((Pair<String, Integer>)hp){
                            final /* synthetic */ Pair<String, Integer> $hp;
                            {
                                this.$hp = $hp;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Opening connection to " + this.$hp.getFirst() + ":" + this.$hp.getSecond();
                            }
                        }, 1, null);
                        Socket s = new Socket((String)hp.getFirst(), ((Number)hp.getSecond()).intValue());
                        function1.invoke((Object)s);
                        return;
                    }
                    catch (Throwable e) {
                        Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(socketConnector), null, (Function0)new Function0<Object>((Pair<String, Integer>)hp){
                            final /* synthetic */ Pair<String, Integer> $hp;
                            {
                                this.$hp = $hp;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Host " + this.$hp.getFirst() + ":" + this.$hp.getSecond() + " is unreachable.";
                            }
                        }, 1, null);
                    }
                }
                throw new HostNotFound();
            }
        }));
    }

    @Override
    public void start() {
        this.started = true;
        this.setState(State.Connecting);
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        try {
            this.createSocket((Function1<? super Socket, Unit>)((Function1)new Function1<Socket, Unit>(this, userJid, domain){
                final /* synthetic */ SocketConnector this$0;
                final /* synthetic */ BareJID $userJid;
                final /* synthetic */ String $domain;
                {
                    this.this$0 = $receiver;
                    this.$userJid = $userJid;
                    this.$domain = $domain;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Socket sckt) {
                    StringBuilder stringBuilder;
                    Unit unit;
                    void $this$invoke_u24lambda_u241;
                    void $this$invoke_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)sckt, (String)"sckt");
                    SocketConnector.access$setSocket$p(this.this$0, sckt);
                    sckt.setSoTimeout(20000);
                    sckt.setKeepAlive(false);
                    sckt.setTcpNoDelay(true);
                    Logger.DefaultImpls.fine$default(SocketConnector.access$getLog$p(this.this$0), null, (Function0)new Function0<Object>(sckt){
                        final /* synthetic */ Socket $sckt;
                        {
                            this.$sckt = $sckt;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Opening socket connection to " + this.$sckt.getInetAddress();
                        }
                    }, 1, null);
                    SocketWorker socketWorker = new SocketWorker(SocketConnector.access$getParser$p(this.this$0));
                    Object object = socketWorker;
                    SocketConnector socketConnector = this.this$0;
                    boolean $i$a$-apply-SocketConnector$start$1$42 = false;
                    $this$invoke_u24lambda_u240.setReaderAndWriter$halcyon_core(new InputStreamReader(sckt.getInputStream()), new OutputStreamWriter(sckt.getOutputStream()));
                    object = this.this$0;
                    SocketWorker $i$a$-apply-SocketConnector$start$1$42 = socketWorker;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setOnError((Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((SocketConnector)object){
                        final /* synthetic */ SocketConnector this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Exception exception) {
                            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                            SocketConnector.access$onWorkerException(this.this$0, exception);
                        }
                    }));
                    SocketConnector.access$setWorker$p(socketConnector, socketWorker);
                    SocketConnector.access$setTlsProcesor$p(this.this$0, this.this$0.getTlsProcesorFactory().create(sckt, SocketConnector.access$getConfig$p(this.this$0)));
                    SocketWorker socketWorker2 = SocketConnector.access$getWorker$p(this.this$0);
                    if (socketWorker2 != null) {
                        socketWorker2.start();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        throw new HalcyonException("Socket Worker not created properly.");
                    }
                    object = this.$userJid;
                    String string = this.$domain;
                    StringBuilder $this$invoke_u24lambda_u242 = stringBuilder = new StringBuilder();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u242.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
                    $this$invoke_u24lambda_u242.append("version='1.0' ");
                    if (object != null) {
                        $this$invoke_u24lambda_u242.append("from='" + (BareJID)object + "' ");
                    }
                    $this$invoke_u24lambda_u242.append("to='" + string + "'");
                    $this$invoke_u24lambda_u242.append(">");
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                    String sb = string2;
                    this.this$0.send(sb);
                    SocketConnector.access$setState(this.this$0, State.Connected);
                    SocketConnector.access$getWhitespacePingExecutor$p(this.this$0).start();
                }
            }));
        }
        catch (HostNotFound e) {
            this.setState(State.Disconnected);
            this.fire(new SocketConnectionErrorEvent.HostNotFount());
        }
        catch (Exception e) {
            this.setState(State.Disconnected);
            this.fire(this.createSocketConnectionErrorEvent(e));
            this.setEventsEnabled(false);
        }
    }

    private final void onWorkerException(Exception cause) {
        State state;
        cause.printStackTrace();
        this.fire(this.createSocketConnectionErrorEvent(cause));
        switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1: {
                state = State.Disconnected;
                break;
            }
            case 2: {
                state = State.Disconnecting;
                break;
            }
            case 3: {
                state = State.Disconnected;
                break;
            }
            case 4: {
                state = State.Disconnected;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.setState(state);
        if (this.getState() == State.Disconnected) {
            this.setEventsEnabled(false);
        }
    }

    private final SocketConnectionErrorEvent createSocketConnectionErrorEvent(Throwable cause) {
        Throwable throwable = cause;
        return (throwable instanceof UnknownHostException ? true : throwable instanceof DnssecValidationFailedException) ? (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.HostNotFount() : (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.Unknown(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.started = false;
        if (this.getState() != State.Disconnected) {
            Logger.DefaultImpls.fine$default(this.log, null, stop.1.INSTANCE, 1, null);
            try {
                if (this.getState() == State.Connected) {
                    this.closeStream();
                }
                this.setState(State.Disconnecting);
                this.whitespacePingExecutor.stop();
                Thread.sleep(175L);
                Socket socket = this.socket;
                boolean bl = socket != null ? !socket.isClosed() : false;
                if (bl) {
                    Object object = this.worker;
                    if (object != null && (object = ((SocketWorker)object).getWriter()) != null) {
                        ((Writer)object).close();
                    }
                    Socket socket2 = this.socket;
                    if (socket2 != null) {
                        socket2.close();
                    }
                }
                SocketWorker socketWorker = this.worker;
                if (socketWorker != null) {
                    socketWorker.interrupt();
                }
                TLSProcessor tLSProcessor = this.tlsProcesor;
                if (tLSProcessor != null) {
                    tLSProcessor.clear();
                }
                while (true) {
                    SocketWorker socketWorker2 = this.worker;
                    boolean bl2 = socketWorker2 != null ? socketWorker2.isActive() : false;
                    if (bl2) {
                        Thread.sleep(32L);
                        continue;
                    }
                    break;
                }
            }
            finally {
                Logger.DefaultImpls.fine$default(this.log, null, stop.2.INSTANCE, 1, null);
                this.setState(State.Disconnected);
                this.worker = null;
                this.socket = null;
                this.setEventsEnabled(false);
            }
        }
    }

    private final void closeStream() {
        if (this.getState() == State.Connected) {
            this.send("</stream:stream>");
        }
    }

    @Override
    public void send(@NotNull CharSequence data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Unit unit;
            Logger.DefaultImpls.finest$default(this.log, null, (Function0)new Function0<Object>(this, data){
                final /* synthetic */ SocketConnector this$0;
                final /* synthetic */ CharSequence $data;
                {
                    this.this$0 = $receiver;
                    this.$data = $data;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    Socket socket = SocketConnector.access$getSocket$p(this.this$0);
                    Socket socket2 = SocketConnector.access$getSocket$p(this.this$0);
                    return "Sending (" + (socket != null ? Boolean.valueOf(socket.isConnected()) : null) + ", " + !(socket2 != null ? socket2.isOutputShutdown() : true) + "): " + this.$data;
                }
            }, 1, null);
            SocketWorker socketWorker = this.worker;
            if (socketWorker != null) {
                SocketWorker it = socketWorker;
                boolean bl = false;
                it.getWriter().write(((Object)data).toString());
                it.getWriter().flush();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new HalcyonException("Socket Worker not initialized.");
            }
        }
        catch (Exception e) {
            this.log.warning(e, (Function0<? extends Object>)((Function0)send.3.INSTANCE));
            this.setState(State.Disconnecting);
            this.fire(this.createSocketConnectionErrorEvent(e));
            throw e;
        }
    }

    public final void restartStream() {
        StringBuilder stringBuilder;
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        StringBuilder $this$restartStream_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$restartStream_u24lambda_u241.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
        $this$restartStream_u24lambda_u241.append("version='1.0' ");
        if (userJid != null) {
            $this$restartStream_u24lambda_u241.append("from='" + userJid + "' ");
        }
        $this$restartStream_u24lambda_u241.append("to='" + domain + "'");
        $this$restartStream_u24lambda_u241.append(">");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String sb = string;
        this.send(sb);
    }

    private final void onTick() {
        block2: {
            Object object;
            if (this.getState() != State.Connected || !this.whiteSpaceEnabled) break block2;
            Logger.DefaultImpls.finer$default(this.log, null, onTick.1.INSTANCE, 1, null);
            Object object2 = this.worker;
            if (object2 != null && (object2 = ((SocketWorker)object2).getWriter()) != null) {
                ((Writer)object2).write(32);
            }
            if ((object = this.worker) != null && (object = ((SocketWorker)object).getWriter()) != null) {
                ((Writer)object).flush();
            }
        }
    }

    public final void startTLS() {
        Logger.DefaultImpls.info$default(this.log, null, startTLS.1.INSTANCE, 1, null);
        this.whiteSpaceEnabled = false;
        Element element2 = BuilderKt.element("starttls", (Function1<? super ElementNode, Unit>)((Function1)startTLS.element.1.INSTANCE));
        this.getHalcyon().getWriter().writeDirectly(element2);
    }

    @Override
    public boolean isConnectionSecure() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return tLSProcessor != null ? tLSProcessor.isConnectionSecure() : false;
    }

    @Override
    @Nullable
    public byte[] getTlsUnique() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsUnique() : null);
    }

    @Override
    @Nullable
    public byte[] getTlsServerEndpoint() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsServerEndpoint() : null);
    }

    @Override
    @Nullable
    public byte[] getTlsExporter() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsServerEndpoint() : null);
    }

    public static final /* synthetic */ SocketWorker access$getWorker$p(SocketConnector $this) {
        return $this.worker;
    }

    public static final /* synthetic */ SocketConnectorConfig access$getConfig$p(SocketConnector $this) {
        return $this.config;
    }

    public static final /* synthetic */ Logger access$getLog$p(SocketConnector $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$setSocket$p(SocketConnector $this, Socket socket) {
        $this.socket = socket;
    }

    public static final /* synthetic */ void access$setWorker$p(SocketConnector $this, SocketWorker socketWorker) {
        $this.worker = socketWorker;
    }

    public static final /* synthetic */ parser.1 access$getParser$p(SocketConnector $this) {
        return $this.parser;
    }

    public static final /* synthetic */ void access$setTlsProcesor$p(SocketConnector $this, TLSProcessor tLSProcessor) {
        $this.tlsProcesor = tLSProcessor;
    }

    public static final /* synthetic */ void access$setState(SocketConnector $this, State value) {
        $this.setState(value);
    }

    public static final /* synthetic */ TickExecutor access$getWhitespacePingExecutor$p(SocketConnector $this) {
        return $this.whitespacePingExecutor;
    }

    public static final /* synthetic */ void access$onWorkerException(SocketConnector $this, Exception cause) {
        $this.onWorkerException(cause);
    }

    public static final /* synthetic */ Socket access$getSocket$p(SocketConnector $this) {
        return $this.socket;
    }

    public static final /* synthetic */ void access$onTick(SocketConnector $this) {
        $this.onTick();
    }

    public static final /* synthetic */ void access$processReceivedElement(SocketConnector $this, Element element2) {
        $this.processReceivedElement(element2);
    }

    public static final /* synthetic */ void access$fire(SocketConnector $this, Event e) {
        $this.fire(e);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector$Companion;", "", "()V", "SEE_OTHER_HOST_KEY", "", "XMLNS_START_TLS", "halcyon-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.Connecting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Connected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Disconnecting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Disconnected.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

