/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.socket.JavaXTLSProcessorKt;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"calculateCertificateHash", "", "certificate", "Ljava/security/cert/X509Certificate;", "halcyon-core"})
public final class JavaXTLSProcessorKt {
    @Nullable
    public static final byte[] calculateCertificateHash(@NotNull X509Certificate certificate) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.calculateCertificateHash", false, 2, null);
        try {
            String string;
            String sigAlgName;
            String string2 = certificate.getSigAlgName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"certificate.sigAlgName");
            String string3 = StringsKt.substringBefore$default((String)string2, (String)"with", null, (int)2, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string4 = string3.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(locale)");
            switch (sigAlgName = string4) {
                case "SHA1": 
                case "MD5": {
                    string = "SHA-256";
                    break;
                }
                case "SHA224": {
                    string = "SHA-224";
                    break;
                }
                case "SHA256": {
                    string = "SHA-256";
                    break;
                }
                case "SHA384": {
                    string = "SHA-384";
                    break;
                }
                case "SHA512": {
                    string = "SHA-512";
                    break;
                }
                default: {
                    string = sigAlgName;
                }
            }
            String useAlgo = string;
            Logger.DefaultImpls.finer$default(log, null, (Function0)new Function0<Object>(useAlgo){
                final /* synthetic */ String $useAlgo;
                {
                    this.$useAlgo = $useAlgo;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Calculating hash of certificate with " + this.$useAlgo + " algorithm.";
                }
            }, 1, null);
            byArray = MessageDigest.getInstance(useAlgo).digest(certificate.getEncoded());
        }
        catch (Exception e) {
            log.severe(e, (Function0<? extends Object>)((Function0)calculateCertificateHash.2.INSTANCE));
            e.printStackTrace();
            byArray = null;
        }
        return byArray;
    }
}

