/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core;

import java.time.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.exceptions.HalcyonException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0007"}, d2={"parseISO8601", "Lkotlinx/datetime/Instant;", "date", "", "timestampToISO8601", "timestamp", "fromISO8601", "halcyon-core"})
public final class TimestampKt {
    @NotNull
    public static final String timestampToISO8601(@NotNull Instant timestamp2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)timestamp2, (String)"timestamp");
        StringBuilder $this$timestampToISO8601_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        LocalDateTime it = TimeZoneKt.toLocalDateTime((Instant)timestamp2, (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        boolean bl2 = false;
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getYear()), (int)4, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append("-");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getMonthNumber()), (int)2, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append("-");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getDayOfMonth()), (int)2, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append("T");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getHour()), (int)2, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append(":");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getMinute()), (int)2, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append(":");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getSecond()), (int)2, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append(".");
        $this$timestampToISO8601_u24lambda_u241.append(StringsKt.padStart((String)String.valueOf(it.getNanosecond() / 1000000), (int)3, (char)'0'));
        $this$timestampToISO8601_u24lambda_u241.append("Z");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final Instant parseISO8601(@NotNull String date) {
        int n;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Regex rx = new Regex("^(\\d{4})-(\\d\\d)-(\\d\\d)([T ](\\d\\d):(\\d\\d):(\\d\\d)(\\.\\d+)?(Z|([+-])(\\d\\d)(:(\\d\\d))?)?)?$");
        MatchResult matchResult = Regex.find$default((Regex)rx, (CharSequence)date, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new HalcyonException("Invalid ISO-8601 date.");
        }
        MatchResult x2 = matchResult;
        int year = Integer.parseInt((String)x2.getGroupValues().get(1));
        int month = Integer.parseInt((String)x2.getGroupValues().get(2)) - 1;
        int day = Integer.parseInt((String)x2.getGroupValues().get(3));
        if (StringsKt.isBlank((CharSequence)((CharSequence)x2.getGroupValues().get(4)))) {
            return TimeZoneKt.atStartOfDayIn((LocalDate)new LocalDate(year, Month.values()[month], day), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        }
        int hour = Integer.parseInt((String)x2.getGroupValues().get(5));
        int minute = Integer.parseInt((String)x2.getGroupValues().get(6));
        int second = Integer.parseInt((String)x2.getGroupValues().get(7));
        String it = (String)x2.getGroupValues().get(8);
        boolean bl = false;
        if (((CharSequence)it).length() > 0) {
            String string = (it + "000").substring(1, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            n = Integer.parseInt(string);
        } else {
            n = 0;
        }
        int ms = n;
        if (StringsKt.isBlank((CharSequence)((CharSequence)x2.getGroupValues().get(9)))) {
            return TimeZoneKt.toInstant((LocalDateTime)new LocalDateTime(year, Month.values()[month], day, hour, minute, second, ms), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        }
        return Instant.Companion.parse(date);
    }

    @NotNull
    public static final Instant fromISO8601(@NotNull String $this$fromISO8601) {
        Intrinsics.checkNotNullParameter((Object)$this$fromISO8601, (String)"<this>");
        return TimestampKt.parseISO8601($this$fromISO8601);
    }
}

