/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.eventbus;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.TickEvent;
import tigase.halcyon.core.eventbus.AbstractEventBus;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.logger.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\u0011H\u0014J\u0012\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0014J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001bH\u0014J\"\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001bH\u0002J\"\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001bH\u0002J\"\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001bH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltigase/halcyon/core/eventbus/EventBus;", "Ltigase/halcyon/core/eventbus/AbstractEventBus;", "context", "Ltigase/halcyon/core/AbstractHalcyon;", "(Ltigase/halcyon/core/AbstractHalcyon;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "mode", "Ltigase/halcyon/core/eventbus/EventBus$Mode;", "getMode", "()Ltigase/halcyon/core/eventbus/EventBus$Mode;", "setMode", "(Ltigase/halcyon/core/eventbus/EventBus$Mode;)V", "threadCounter", "", "createHandlersMap", "", "", "", "Ltigase/halcyon/core/eventbus/EventHandler;", "createHandlersSet", "fire", "", "event", "Ltigase/halcyon/core/eventbus/Event;", "handlers", "", "fireNoThread", "fireThreadPerEvent", "fireThreadPerHandler", "Mode", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\ntigase/halcyon/core/eventbus/EventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1855#2,2:98\n1855#2,2:100\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\ntigase/halcyon/core/eventbus/EventBus\n*L\n49#1:98,2\n73#1:100,2\n61#1:102,2\n*E\n"})
public final class EventBus
extends AbstractEventBus {
    private int threadCounter;
    @NotNull
    private Mode mode;
    private final ExecutorService executor;

    public EventBus(@NotNull AbstractHalcyon context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mode = Mode.NoThread;
        this.executor = Executors.newSingleThreadExecutor(arg_0 -> EventBus.executor$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    protected Map<String, Set<EventHandler<?>>> createHandlersMap() {
        return new ConcurrentHashMap();
    }

    @Override
    @NotNull
    protected Set<EventHandler<?>> createHandlersSet() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        return keySetView;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    private final void fireNoThread(Event event, Collection<? extends EventHandler<?>> handlers) {
        Iterable $this$forEach$iv = handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
                eventHandler.onEvent(event);
            }
            catch (Exception e) {
                this.getLog().warning(e, (Function0<? extends Object>)((Function0)new Function0<Object>(event){
                    final /* synthetic */ Event $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Problem on handling event " + this.$event.getEventType();
                    }
                }));
            }
        }
    }

    private final void fireThreadPerEvent(Event event, Collection<? extends EventHandler<?>> handlers) {
        this.executor.execute(() -> EventBus.fireThreadPerEvent$lambda$3(handlers, event, this));
    }

    private final void fireThreadPerHandler(Event event, Collection<? extends EventHandler<?>> handlers) {
        Iterable $this$forEach$iv = handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            this.executor.execute(() -> EventBus.fireThreadPerHandler$lambda$5$lambda$4(eventHandler, event, this));
        }
    }

    @Override
    protected void fire(@NotNull Event event, @NotNull Collection<? extends EventHandler<?>> handlers) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        if (!(event instanceof TickEvent)) {
            Logger.DefaultImpls.finest$default(this.getLog(), null, (Function0)new Function0<Object>(event, handlers){
                final /* synthetic */ Event $event;
                final /* synthetic */ Collection<EventHandler<?>> $handlers;
                {
                    this.$event = $event;
                    this.$handlers = $handlers;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Firing event " + this.$event + " with " + this.$handlers.size() + " handlers";
                }
            }, 1, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.fireNoThread(event, handlers);
                break;
            }
            case 2: {
                this.fireThreadPerEvent(event, handlers);
                break;
            }
            case 3: {
                this.fireThreadPerHandler(event, handlers);
            }
        }
    }

    private static final Thread executor$lambda$0(EventBus this$0, Runnable r) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread t = new Thread(r);
        ++this$0.threadCounter;
        t.setName("EventBus-Thread-" + this$0.threadCounter);
        t.setDaemon(true);
        return t;
    }

    private static final void fireThreadPerEvent$lambda$3(Collection $handlers, Event $event, EventBus this$0) {
        Intrinsics.checkNotNullParameter((Object)$handlers, (String)"$handlers");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
                eventHandler.onEvent($event);
            }
            catch (Exception e) {
                this$0.getLog().warning(e, (Function0<? extends Object>)((Function0)new Function0<Object>($event){
                    final /* synthetic */ Event $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Problem on handling event " + this.$event.getEventType();
                    }
                }));
            }
        }
    }

    private static final void fireThreadPerHandler$lambda$5$lambda$4(EventHandler $eventHandler, Event $event, EventBus this$0) {
        Intrinsics.checkNotNullParameter((Object)$eventHandler, (String)"$eventHandler");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            $eventHandler.onEvent($event);
        }
        catch (Exception e) {
            this$0.getLog().warning(e, (Function0<? extends Object>)((Function0)new Function0<Object>($event){
                final /* synthetic */ Event $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Problem on handling event " + this.$event.getEventType();
                }
            }));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ltigase/halcyon/core/eventbus/EventBus$Mode;", "", "(Ljava/lang/String;I)V", "NoThread", "ThreadPerEvent", "ThreadPerHandler", "halcyon-core"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NoThread = new Mode();
        public static final /* enum */ Mode ThreadPerEvent = new Mode();
        public static final /* enum */ Mode ThreadPerHandler = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.NoThread, Mode.ThreadPerEvent, Mode.ThreadPerHandler};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.NoThread.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ThreadPerEvent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ThreadPerHandler.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

