/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.ConnectorException;
import tigase.halcyon.core.connector.socket.SocketWorker;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.parser.StreamParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010'\u001a\u00020\u0011H\u0016J\b\u0010(\u001a\u00020\u0011H\u0016J\b\u0010)\u001a\u00020\u0011H\u0002R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R,\u0010\u0016\u001a\u0014\u0012\b\u0012\u00060\u0017j\u0002`\u0018\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Ltigase/halcyon/core/connector/socket/SocketWorker;", "Ljava/lang/Thread;", "s", "Ljava/net/Socket;", "parser", "Ltigase/halcyon/core/xml/parser/StreamParser;", "(Ljava/net/Socket;Ltigase/halcyon/core/xml/parser/StreamParser;)V", "value", "", "isActive", "()Z", "setActive", "(Z)V", "log", "Ltigase/halcyon/core/logger/Logger;", "onActiveChange", "Lkotlin/Function1;", "", "getOnActiveChange", "()Lkotlin/jvm/functions/Function1;", "setOnActiveChange", "(Lkotlin/jvm/functions/Function1;)V", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getOnError", "setOnError", "reader", "Ljava/io/Reader;", "socket", "getSocket", "()Ljava/net/Socket;", "setSocket", "(Ljava/net/Socket;)V", "<set-?>", "Ljava/io/OutputStreamWriter;", "writer", "getWriter", "()Ljava/io/OutputStreamWriter;", "interrupt", "run", "update", "halcyon-core"})
public final class SocketWorker
extends Thread {
    @NotNull
    private final StreamParser parser;
    @NotNull
    private final Logger log;
    @Nullable
    private Function1<? super Boolean, Unit> onActiveChange;
    private boolean isActive;
    @NotNull
    private Socket socket;
    private Reader reader;
    private OutputStreamWriter writer;
    @Nullable
    private Function1<? super Exception, Unit> onError;

    public SocketWorker(@NotNull Socket s, @NotNull StreamParser parser2) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
        this.parser = parser2;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.SocketWorker", false, 2, null);
        this.socket = s;
        this.setName("Socket-Worker-Thread");
        this.setDaemon(true);
        this.update();
    }

    @Nullable
    public final Function1<Boolean, Unit> getOnActiveChange() {
        return this.onActiveChange;
    }

    public final void setOnActiveChange(@Nullable Function1<? super Boolean, Unit> function1) {
        this.onActiveChange = function1;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final void setActive(boolean value) {
        block1: {
            boolean tmp2 = this.isActive;
            this.isActive = value;
            if (tmp2 == this.isActive) break block1;
            Function1<? super Boolean, Unit> function1 = this.onActiveChange;
            if (function1 != null) {
                function1.invoke((Object)this.isActive);
            }
        }
    }

    @NotNull
    public final Socket getSocket() {
        return this.socket;
    }

    public final void setSocket(@NotNull Socket value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.socket = value;
        this.update();
    }

    @NotNull
    public final OutputStreamWriter getWriter() {
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter != null) {
            return outputStreamWriter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
        return null;
    }

    @Nullable
    public final Function1<Exception, Unit> getOnError() {
        return this.onError;
    }

    public final void setOnError(@Nullable Function1<? super Exception, Unit> function1) {
        this.onError = function1;
    }

    private final void update() {
        this.reader = new InputStreamReader(this.socket.getInputStream());
        this.writer = new OutputStreamWriter(this.socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.DefaultImpls.fine$default(this.log, null, run.1.INSTANCE, 1, null);
        char[] buffer = new char[10240];
        try {
            this.setActive(true);
            while (this.isActive && !Thread.interrupted() && this.isAlive()) {
                int len;
                Reader reader = this.reader;
                if (reader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
                    reader = null;
                }
                if ((len = reader.read(buffer)) == -1) {
                    Logger.DefaultImpls.finest$default(this.log, null, run.2.INSTANCE, 1, null);
                    break;
                }
                if (!this.isActive || Thread.interrupted() || !this.isAlive()) continue;
                this.parser.parse(buffer, 0, len - 1);
            }
            if (this.isActive) {
                Logger.DefaultImpls.warning$default(this.log, null, run.3.INSTANCE, 1, null);
                Function1<? super Exception, Unit> function1 = this.onError;
                if (function1 != null) {
                    function1.invoke((Object)new ConnectorException("Unexpected stop!"));
                }
            }
        }
        catch (Exception e) {
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(this){
                final /* synthetic */ SocketWorker this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Exception in worker: isActive=" + this.this$0.isActive() + " interrupted=" + !Thread.interrupted() + " socket=" + !this.this$0.getSocket().isClosed();
                }
            }, 1, null);
            if (this.isActive) {
                this.log.fine(e, (Function0<? extends Object>)((Function0)run.5.INSTANCE));
                Function1<? super Exception, Unit> function1 = this.onError;
                if (function1 != null) {
                    function1.invoke((Object)e);
                }
            }
        }
        finally {
            this.setActive(false);
            Logger.DefaultImpls.fine$default(this.log, null, run.6.INSTANCE, 1, null);
        }
    }

    @Override
    public void interrupt() {
        this.setActive(false);
        super.interrupt();
    }
}

