/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.color;

import korlibs.crypto.SHA1Kt;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.xmpp.modules.color.Color;
import tigase.halcyon.core.xmpp.modules.color.ColorGenerationModuleConfig;
import tigase.halcyon.core.xmpp.modules.color.ColorsCache;
import tigase.halcyon.core.xmpp.modules.color.InMemoryColorsCache;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020&J\u001f\u0010'\u001a\u00020&2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020&0)\u00a2\u0006\u0002\b*J \u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000e\u00a8\u0006/"}, d2={"Ltigase/halcyon/core/xmpp/modules/color/ColorGeneratorEngine;", "Ltigase/halcyon/core/xmpp/modules/color/ColorGenerationModuleConfig;", "()V", "colorsCache", "Ltigase/halcyon/core/xmpp/modules/color/ColorsCache;", "getColorsCache", "()Ltigase/halcyon/core/xmpp/modules/color/ColorsCache;", "setColorsCache", "(Ltigase/halcyon/core/xmpp/modules/color/ColorsCache;)V", "hueMax", "", "getHueMax", "()F", "setHueMax", "(F)V", "hueMin", "getHueMin", "setHueMin", "lightnessMax", "getLightnessMax", "setLightnessMax", "lightnessMin", "getLightnessMin", "setLightnessMin", "saturationMax", "getSaturationMax", "setSaturationMax", "saturationMin", "getSaturationMin", "setSaturationMin", "calculateColor", "Ltigase/halcyon/core/xmpp/modules/color/Color;", "jid", "", "calculateValue", "data", "", "checkSettings", "", "config", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "normalizeHash", "hash", "min", "max", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nColorGenerationModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorGenerationModule.kt\ntigase/halcyon/core/xmpp/modules/color/ColorGeneratorEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1789#2,3:143\n*S KotlinDebug\n*F\n+ 1 ColorGenerationModule.kt\ntigase/halcyon/core/xmpp/modules/color/ColorGeneratorEngine\n*L\n110#1:143,3\n*E\n"})
public class ColorGeneratorEngine
implements ColorGenerationModuleConfig {
    private float hueMin;
    private float hueMax = 360.0f;
    private float saturationMin = 80.0f;
    private float saturationMax = 100.0f;
    private float lightnessMin = 25.0f;
    private float lightnessMax = 60.0f;
    @Nullable
    private ColorsCache colorsCache = new InMemoryColorsCache();

    @Override
    public float getHueMin() {
        return this.hueMin;
    }

    @Override
    public void setHueMin(float f) {
        this.hueMin = f;
    }

    @Override
    public float getHueMax() {
        return this.hueMax;
    }

    @Override
    public void setHueMax(float f) {
        this.hueMax = f;
    }

    @Override
    public float getSaturationMin() {
        return this.saturationMin;
    }

    @Override
    public void setSaturationMin(float f) {
        this.saturationMin = f;
    }

    @Override
    public float getSaturationMax() {
        return this.saturationMax;
    }

    @Override
    public void setSaturationMax(float f) {
        this.saturationMax = f;
    }

    @Override
    public float getLightnessMin() {
        return this.lightnessMin;
    }

    @Override
    public void setLightnessMin(float f) {
        this.lightnessMin = f;
    }

    @Override
    public float getLightnessMax() {
        return this.lightnessMax;
    }

    @Override
    public void setLightnessMax(float f) {
        this.lightnessMax = f;
    }

    @Override
    @Nullable
    public ColorsCache getColorsCache() {
        return this.colorsCache;
    }

    @Override
    public void setColorsCache(@Nullable ColorsCache colorsCache) {
        this.colorsCache = colorsCache;
    }

    private final float normalizeHash(float hash, float min, float max) {
        return Math.abs(hash) * (max - min) + min;
    }

    /*
     * WARNING - void declaration
     */
    private final float calculateValue(String data) {
        void $this$fold$iv;
        Iterable iterable = CollectionsKt.reversed((Iterable)ArraysKt.take((byte[])SHA1Kt.sha1((byte[])StringsKt.encodeToByteArray((String)data)).getBytes(), (int)2));
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void byteVal;
            byte by = ((Number)element$iv).byteValue();
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc << 8 | (long)UByte.constructor-impl((byte)byteVal) & 0xFFL;
        }
        return (float)accumulator$iv / 65536.0f;
    }

    public final void config(@NotNull Function1<? super ColorGenerationModuleConfig, Unit> cfg) {
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        cfg.invoke((Object)this);
        ColorsCache colorsCache = this.getColorsCache();
        if (colorsCache != null) {
            colorsCache.clear();
        }
        this.checkSettings();
    }

    public final void checkSettings() {
        if (this.getHueMin() > this.getHueMax()) {
            throw new AssertionError((Object)"hueMin cannot be greater than hueMax.");
        }
        if (this.getSaturationMin() > this.getSaturationMax()) {
            throw new AssertionError((Object)"saturationMin cannot be greater than saturationMax.");
        }
        if (this.getLightnessMin() > this.getLightnessMax()) {
            throw new AssertionError((Object)"lightnessMin cannot be greater than lightnessMax.");
        }
    }

    @NotNull
    public final Color calculateColor(@NotNull Object jid) {
        Color color;
        Color cachedColor;
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        String key = jid.toString();
        ColorsCache colorsCache = this.getColorsCache();
        Color color2 = cachedColor = colorsCache != null ? colorsCache.get(key) : null;
        if (cachedColor != null) {
            color = cachedColor;
        } else {
            float hash = this.calculateValue(key);
            Color c = new Color(this.normalizeHash(hash, this.getHueMin(), this.getHueMax()), this.normalizeHash(hash, this.getSaturationMin(), this.getSaturationMax()), this.normalizeHash(hash, this.getLightnessMin(), this.getLightnessMax()));
            ColorsCache colorsCache2 = this.getColorsCache();
            if (colorsCache2 != null) {
                colorsCache2.store(key, c);
            }
            color = c;
        }
        return color;
    }
}

