/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector;

import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.configuration.Registration;
import tigase.halcyon.core.connector.AbstractSocketSessionController;
import tigase.halcyon.core.connector.ConnectionErrorEvent;
import tigase.halcyon.core.connector.ConnectorStateChangeEvent;
import tigase.halcyon.core.connector.ParseErrorEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestBuilder;
import tigase.halcyon.core.requests.RequestsManager;
import tigase.halcyon.core.xmpp.BareJIDKt;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.forms.JabberDataForm;
import tigase.halcyon.core.xmpp.modules.BindEvent;
import tigase.halcyon.core.xmpp.modules.BindModule;
import tigase.halcyon.core.xmpp.modules.InBandRegistrationModule;
import tigase.halcyon.core.xmpp.modules.StreamErrorEvent;
import tigase.halcyon.core.xmpp.modules.StreamFeaturesEvent;
import tigase.halcyon.core.xmpp.modules.StreamFeaturesModule;
import tigase.halcyon.core.xmpp.modules.auth.SASL2Module;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;
import tigase.halcyon.core.xmpp.modules.discovery.DiscoveryModule;
import tigase.halcyon.core.xmpp.modules.presence.PresenceModule;
import tigase.halcyon.core.xmpp.modules.roster.RosterModule;
import tigase.halcyon.core.xmpp.modules.roster.RosterResponse;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;
import tigase.halcyon.core.xmpp.stanzas.IQ;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0016H$J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001aH$J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0011H\u0016J\b\u0010(\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Ltigase/halcyon/core/connector/AbstractSocketSessionController;", "Ltigase/halcyon/core/connector/SessionController;", "halcyon", "Ltigase/halcyon/core/AbstractHalcyon;", "loggerName", "", "(Ltigase/halcyon/core/AbstractHalcyon;Ljava/lang/String;)V", "eventsHandler", "Ltigase/halcyon/core/eventbus/EventHandler;", "Ltigase/halcyon/core/eventbus/Event;", "getHalcyon", "()Ltigase/halcyon/core/AbstractHalcyon;", "log", "Ltigase/halcyon/core/logger/Logger;", "getLog", "()Ltigase/halcyon/core/logger/Logger;", "bindResource", "", "processAuthError", "event", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEvent$SASLError;", "processAuthSuccessfull", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEvent$SASLSuccess;", "processBindError", "processBindSuccess", "processConnectionError", "Ltigase/halcyon/core/connector/ConnectionErrorEvent;", "processConnectorStateChangeEvent", "Ltigase/halcyon/core/connector/ConnectorStateChangeEvent;", "processEvent", "processInBandRegistration", "processParseError", "Ltigase/halcyon/core/connector/ParseErrorEvent;", "processStreamError", "Ltigase/halcyon/core/xmpp/modules/StreamErrorEvent;", "processStreamFeaturesEvent", "Ltigase/halcyon/core/xmpp/modules/StreamFeaturesEvent;", "processStreamManagementEvent", "Ltigase/halcyon/core/xmpp/modules/sm/StreamManagementModule$StreamManagementEvent;", "start", "stop", "halcyon-core"})
public abstract class AbstractSocketSessionController
implements SessionController {
    @NotNull
    private final AbstractHalcyon halcyon;
    @NotNull
    private final Logger log;
    @NotNull
    private final EventHandler<Event> eventsHandler;

    public AbstractSocketSessionController(@NotNull AbstractHalcyon halcyon, @NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        this.halcyon = halcyon;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, loggerName, false, 2, null);
        this.eventsHandler = new EventHandler<Event>(this){
            final /* synthetic */ AbstractSocketSessionController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEvent(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AbstractSocketSessionController.access$processEvent(this.this$0, event);
            }
        };
    }

    @Override
    @NotNull
    public final AbstractHalcyon getHalcyon() {
        return this.halcyon;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    protected void processStreamFeaturesEvent(@NotNull StreamFeaturesEvent event) {
        XmppModule xmppModule;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        tigase.halcyon.core.xmpp.modules.auth.State authState = this.halcyon.getAuthContext().getState();
        Object object = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion);
        boolean isResumptionAvailable = object != null && (object = ((StreamManagementModule)object).getResumptionContext()) != null ? ((StreamManagementModule.ResumptionContext)object).isResumptionAvailable() : false;
        Logger.DefaultImpls.info$default(this.log, null, (Function0)new Function0<Object>(authState, isResumptionAvailable){
            final /* synthetic */ tigase.halcyon.core.xmpp.modules.auth.State $authState;
            final /* synthetic */ boolean $isResumptionAvailable;
            {
                this.$authState = $authState;
                this.$isResumptionAvailable = $isResumptionAvailable;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "authState=" + this.$authState + "; isResumptionAvailable=" + this.$isResumptionAvailable;
            }
        }, 1, null);
        if (authState == tigase.halcyon.core.xmpp.modules.auth.State.Unknown) {
            if (!isResumptionAvailable && (xmppModule = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion)) != null) {
                ((StreamManagementModule)xmppModule).reset();
            }
            SASLModule sasl1Module = (SASLModule)this.halcyon.getModuleOrNull(SASLModule.Companion);
            SASL2Module sasl2Module = (SASL2Module)this.halcyon.getModuleOrNull(SASL2Module.Companion);
            InBandRegistrationModule registrationModule = (InBandRegistrationModule)this.halcyon.getModuleOrNull(InBandRegistrationModule.Companion.getTYPE());
            SASL2Module sASL2Module = sasl2Module;
            boolean bl = sASL2Module != null ? sASL2Module.isAllowed(event.getFeatures()) : false;
            if (bl) {
                sasl2Module.startAuth(event.getFeatures());
            } else {
                SASLModule sASLModule = sasl1Module;
                boolean bl2 = sASLModule != null ? sASLModule.isAllowed(event.getFeatures()) : false;
                if (bl2) {
                    sasl1Module.startAuth(event.getFeatures());
                } else {
                    InBandRegistrationModule inBandRegistrationModule = registrationModule;
                    boolean bl3 = inBandRegistrationModule != null ? inBandRegistrationModule.isAllowed(event.getFeatures()) : false;
                    if (bl3 && this.halcyon.getConfig().getRegistration() != null) {
                        this.processInBandRegistration();
                    } else {
                        throw new HalcyonException("Cannot find supported auth or registration method.");
                    }
                }
            }
        }
        if (authState == tigase.halcyon.core.xmpp.modules.auth.State.Success) {
            if (isResumptionAvailable) {
                ((StreamManagementModule)this.halcyon.getModule(StreamManagementModule.Companion)).resume();
            } else {
                xmppModule = (StreamFeaturesModule)this.halcyon.getModuleOrNull(StreamFeaturesModule.Companion);
                boolean bl = xmppModule != null ? ((StreamFeaturesModule)xmppModule).isFeatureAvailable("bind", "urn:ietf:params:xml:ns:xmpp-bind") : false;
                if (bl) {
                    this.bindResource();
                }
            }
        }
    }

    private final void processInBandRegistration() {
        InBandRegistrationModule registrationModule = (InBandRegistrationModule)this.halcyon.getModule(InBandRegistrationModule.Companion.getTYPE());
        Registration registration = this.halcyon.getConfig().getRegistration();
        Intrinsics.checkNotNull((Object)registration);
        Registration reg = registration;
        RequestBuilder.response$default(registrationModule.requestRegistrationForm(BareJIDKt.toBareJID(reg.getDomain())), null, (Function1)new Function1<Result<? extends JabberDataForm>, Unit>(reg, registrationModule, this){
            final /* synthetic */ Registration $reg;
            final /* synthetic */ InBandRegistrationModule $registrationModule;
            final /* synthetic */ AbstractSocketSessionController this$0;
            {
                this.$reg = $reg;
                this.$registrationModule = $registrationModule;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                Object object = it;
                Object object2 = this.$reg;
                Object object3 = this.$registrationModule;
                AbstractSocketSessionController abstractSocketSessionController = this.this$0;
                if (Result.isSuccess-impl((Object)object)) {
                    JabberDataForm jabberDataForm;
                    JabberDataForm requestForm = (JabberDataForm)object;
                    boolean bl = false;
                    Function1<JabberDataForm, Unit> function1 = ((Registration)object2).getFormHandler();
                    if (function1 != null) {
                        function1.invoke((Object)requestForm);
                    }
                    Function1<JabberDataForm, JabberDataForm> function12 = ((Registration)object2).getFormHandlerWithResponse();
                    if (function12 != null && (jabberDataForm = (JabberDataForm)function12.invoke((Object)requestForm)) != null) {
                        JabberDataForm resultForm = jabberDataForm;
                        boolean bl2 = false;
                        RequestBuilder.response$default(((InBandRegistrationModule)object3).submitRegistrationForm(BareJIDKt.toBareJID(((Registration)object2).getDomain()), resultForm), null, (Function1)new Function1<Result<? extends Unit>, Unit>(abstractSocketSessionController){
                            final /* synthetic */ AbstractSocketSessionController this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Object registrationResponse) {
                                Object object = registrationResponse;
                                AbstractSocketSessionController abstractSocketSessionController = this.this$0;
                                if (Result.isSuccess-impl((Object)object)) {
                                    Unit it = (Unit)object;
                                    boolean bl = false;
                                    abstractSocketSessionController.getLog().info("Account registered");
                                    abstractSocketSessionController.getHalcyon().disconnect();
                                }
                                object = registrationResponse;
                                abstractSocketSessionController = this.this$0;
                                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                                if (throwable != null) {
                                    Throwable throwable2;
                                    Throwable it = throwable2 = throwable;
                                    boolean bl = false;
                                    abstractSocketSessionController.getLog().info(it, (Function0<? extends Object>)((Function0)processInBandRegistration.1.1.2.1.INSTANCE));
                                    throw new HalcyonException("Cannot register account", it);
                                }
                            }
                        }, 1, null).send();
                    }
                }
                object = it;
                object2 = this.this$0;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Object it2 = object3 = throwable;
                    boolean bl = false;
                    ((AbstractSocketSessionController)object2).getLog().info((Throwable)it2, (Function0<? extends Object>)((Function0)processInBandRegistration.2.1.INSTANCE));
                    throw new HalcyonException("Cannot register account", (Throwable)it2);
                }
            }
        }, 1, null).send();
    }

    private final void bindResource() {
        Request request2;
        RequestBuilder requestBuilder;
        BindModule bindModule = (BindModule)this.halcyon.getModuleOrNull(BindModule.Companion);
        if (bindModule == null || (requestBuilder = BindModule.bind$default(bindModule, null, 1, null)) == null || (request2 = requestBuilder.send()) == null) {
            throw new HalcyonException("BindModule is required.");
        }
    }

    private final void processEvent(Event event) {
        try {
            Event event2 = event;
            if (event2 instanceof ParseErrorEvent) {
                this.processParseError((ParseErrorEvent)event);
            } else if (event2 instanceof SASLEvent.SASLError) {
                this.processAuthError((SASLEvent.SASLError)event);
            } else if (event2 instanceof StreamErrorEvent) {
                this.processStreamError((StreamErrorEvent)event);
            } else if (event2 instanceof ConnectionErrorEvent) {
                this.processConnectionError((ConnectionErrorEvent)event);
            } else if (event2 instanceof StreamFeaturesEvent) {
                this.processStreamFeaturesEvent((StreamFeaturesEvent)event);
            } else if (event2 instanceof SASLEvent.SASLSuccess) {
                this.processAuthSuccessfull((SASLEvent.SASLSuccess)event);
            } else if (event2 instanceof StreamManagementModule.StreamManagementEvent) {
                this.processStreamManagementEvent((StreamManagementModule.StreamManagementEvent)event);
            } else if (event2 instanceof ConnectorStateChangeEvent) {
                this.processConnectorStateChangeEvent((ConnectorStateChangeEvent)event);
            } else if (event2 instanceof BindEvent.Success) {
                this.processBindSuccess();
            } else if (event2 instanceof BindEvent.Failure) {
                this.processBindError();
            }
        }
        catch (XMPPException e) {
            this.log.severe(e, (Function0<? extends Object>)((Function0)processEvent.1.INSTANCE));
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Error in session processing"));
        }
        catch (HalcyonException e) {
            this.log.severe(e, (Function0<? extends Object>)((Function0)processEvent.2.INSTANCE));
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Error in session processing"));
        }
    }

    private final void processConnectorStateChangeEvent(ConnectorStateChangeEvent event) {
        if (event.getOldState() == State.Connected && (event.getNewState() == State.Disconnected || event.getNewState() == State.Disconnecting)) {
            Logger.DefaultImpls.fine$default(this.log, null, processConnectorStateChangeEvent.1.INSTANCE, 1, null);
            boolean isResumptionAvailable = ((StreamManagementModule)this.halcyon.getModule(StreamManagementModule.Companion.getTYPE())).getResumptionContext().isResumptionAvailable();
            if (!isResumptionAvailable) {
                RequestsManager.timeoutAll$default(this.halcyon.getRequestsManager(), null, 1, null);
            }
        }
    }

    private final void processStreamManagementEvent(StreamManagementModule.StreamManagementEvent event) {
        StreamManagementModule.StreamManagementEvent streamManagementEvent = event;
        if (streamManagementEvent instanceof StreamManagementModule.StreamManagementEvent.Resumed) {
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.Successful());
        } else if (streamManagementEvent instanceof StreamManagementModule.StreamManagementEvent.Failed) {
            RequestsManager.timeoutAll$default(this.halcyon.getRequestsManager(), null, 1, null);
            this.bindResource();
        } else if (streamManagementEvent instanceof StreamManagementModule.StreamManagementEvent.Enabled) {
            // empty if block
        }
    }

    private final void processBindSuccess() {
        block2: {
            RequestBuilder<RosterResponse, IQ> requestBuilder;
            this.log.info("Binded");
            XmppModule xmppModule = (DiscoveryModule)this.halcyon.getModuleOrNull(DiscoveryModule.Companion.getTYPE());
            if (xmppModule != null) {
                DiscoveryModule it = xmppModule;
                boolean bl = false;
                it.discoverServerFeatures$halcyon_core();
                it.discoverAccountFeatures$halcyon_core();
            }
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.Successful());
            xmppModule = (PresenceModule)this.halcyon.getModuleOrNull(PresenceModule.Companion.getTYPE());
            if (xmppModule != null) {
                ((PresenceModule)xmppModule).sendInitialPresence();
            }
            if ((xmppModule = (RosterModule)this.halcyon.getModuleOrNull(RosterModule.Companion.getTYPE())) == null || (requestBuilder = ((RosterModule)xmppModule).rosterGet()) == null) break block2;
            requestBuilder.send();
        }
    }

    protected abstract void processAuthSuccessfull(@NotNull SASLEvent.SASLSuccess var1);

    protected abstract void processConnectionError(@NotNull ConnectionErrorEvent var1);

    protected void processParseError(@NotNull ParseErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Parse error", false, false, 6, null));
    }

    protected void processBindError() {
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Session bind error", false, false, 6, null));
    }

    protected void processAuthError(@NotNull SASLEvent.SASLError event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Authentication error."));
    }

    protected void processStreamError(@NotNull StreamErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.halcyon.clear$halcyon_core(Scope.Connection);
        event.getErrorElement().getName();
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Stream error: " + event.getCondition(), false, false, 6, null));
    }

    @Override
    public void start() {
        EventBusInterface.DefaultImpls.register$default((EventBusInterface)this.halcyon.getEventBus(), null, this.eventsHandler, 1, null);
        Logger.DefaultImpls.info$default(this.log, null, start.1.INSTANCE, 1, null);
    }

    @Override
    public void stop() {
        this.halcyon.getEventBus().unregister(this.eventsHandler);
        Logger.DefaultImpls.info$default(this.log, null, stop.1.INSTANCE, 1, null);
    }

    public static final /* synthetic */ void access$processEvent(AbstractSocketSessionController $this, Event event) {
        $this.processEvent(event);
    }
}

