/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import com.soywiz.krypto.HMAC;
import com.soywiz.krypto.PBKDF2;
import com.soywiz.krypto.SHA1Kt;
import com.soywiz.krypto.SHA256Kt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Base64Kt;
import tigase.halcyon.core.configuration.Configuration;
import tigase.halcyon.core.configuration.JIDPasswordSaslConfig;
import tigase.halcyon.core.configuration.SaslConfig;
import tigase.halcyon.core.xmpp.modules.auth.BindType;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.MechanismData;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanism;
import tigase.halcyon.core.xmpp.modules.auth.SCRAMData;
import tigase.halcyon.core.xmpp.modules.auth.ScramHashAlgorithm;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/AbstractSASLScram;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanism;", "name", "", "hashAlgorithm", "Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "randomGenerator", "Lkotlin/Function0;", "clientKeyData", "", "serverKeyData", "(Ljava/lang/String;Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;Lkotlin/jvm/functions/Function0;[B[B)V", "getHashAlgorithm", "()Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "getName", "()Ljava/lang/String;", "serverFirstMessageRegex", "Lkotlin/text/Regex;", "serverLastMessageRegex", "evaluateChallenge", "input", "config", "Ltigase/halcyon/core/configuration/Configuration;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "isAllowedToUse", "", "scramData", "Ltigase/halcyon/core/xmpp/modules/auth/SCRAMData;", "halcyon-core"})
public abstract class AbstractSASLScram
implements SASLMechanism {
    @NotNull
    private final String name;
    @NotNull
    private final ScramHashAlgorithm hashAlgorithm;
    @NotNull
    private final Function0<String> randomGenerator;
    @NotNull
    private final byte[] clientKeyData;
    @NotNull
    private final byte[] serverKeyData;
    @NotNull
    private final Regex serverFirstMessageRegex;
    @NotNull
    private final Regex serverLastMessageRegex;

    public AbstractSASLScram(@NotNull String name2, @NotNull ScramHashAlgorithm hashAlgorithm, @NotNull Function0<String> randomGenerator, @NotNull byte[] clientKeyData, @NotNull byte[] serverKeyData) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter(randomGenerator, (String)"randomGenerator");
        Intrinsics.checkNotNullParameter((Object)clientKeyData, (String)"clientKeyData");
        Intrinsics.checkNotNullParameter((Object)serverKeyData, (String)"serverKeyData");
        this.name = name2;
        this.hashAlgorithm = hashAlgorithm;
        this.randomGenerator = randomGenerator;
        this.clientKeyData = clientKeyData;
        this.serverKeyData = serverKeyData;
        this.serverFirstMessageRegex = new Regex("^(m=[^,]+,)?r=([^,]+),s=([^,]+),i=([0-9]+)(?:,.*)?$", RegexOption.IGNORE_CASE);
        this.serverLastMessageRegex = new Regex("^(?:e=([^,]+)|v=([^,]+)(?:,.*)?)$", RegexOption.IGNORE_CASE);
    }

    public /* synthetic */ AbstractSASLScram(String string, ScramHashAlgorithm scramHashAlgorithm, Function0 function0, byte[] byArray, byte[] byArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            byArray = StringsKt.encodeToByteArray((String)"Client Key");
        }
        if ((n & 0x10) != 0) {
            byArray2 = StringsKt.encodeToByteArray((String)"Server Key");
        }
        this(string, scramHashAlgorithm, (Function0<String>)function0, byArray, byArray2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final ScramHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public boolean isAllowedToUse(@NotNull Configuration config, @NotNull SASLContext saslContext) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        return config.getSasl() instanceof JIDPasswordSaslConfig;
    }

    private final SCRAMData scramData(SASLContext saslContext) {
        if (saslContext.getMechanismData() == null) {
            saslContext.setMechanismData(new SCRAMData(null, null, null, null, null, null, null, null, null, 0, 1023, null));
        }
        MechanismData mechanismData = saslContext.getMechanismData();
        Intrinsics.checkNotNull((Object)mechanismData, (String)"null cannot be cast to non-null type tigase.halcyon.core.xmpp.modules.auth.SCRAMData");
        return (SCRAMData)mechanismData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String evaluateChallenge(@Nullable String input, @NotNull Configuration config, @NotNull SASLContext saslContext) {
        SCRAMData data;
        block50: {
            StringBuilder stringBuilder;
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            StringBuilder stringBuilder2;
            Object object;
            Object nonce;
            MatchResult r2;
            String serverFirstMessage;
            block52: {
                block51: {
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
                    data = this.scramData(saslContext);
                    SaslConfig saslConfig = config.getSasl();
                    Intrinsics.checkNotNull((Object)saslConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.configuration.JIDPasswordSaslConfig");
                    JIDPasswordSaslConfig credentials = (JIDPasswordSaslConfig)saslConfig;
                    if (data.getStage() == 0) {
                        void $this$evaluateChallenge_u24lambda_u2d2;
                        StringBuilder $this$evaluateChallenge_u24lambda_u2d1;
                        StringBuilder stringBuilder3;
                        data.setConce((String)this.randomGenerator.invoke());
                        data.setBindType(BindType.N);
                        data.setBindData(new byte[0]);
                        String string = credentials.getAuthcId();
                        if (string == null) {
                            String string2 = credentials.getUserJID().getLocalpart();
                            string = string2;
                            Intrinsics.checkNotNull((Object)string2);
                        }
                        data.setAuthcId(string);
                        data.setAuthzId(credentials.getAuthcId() != null ? credentials.getUserJID().toString() : null);
                        StringBuilder stringBuilder4 = stringBuilder3 = new StringBuilder();
                        SCRAMData sCRAMData = data;
                        boolean bl = false;
                        BindType bindType = data.getBindType();
                        Intrinsics.checkNotNull((Object)((Object)bindType));
                        switch (WhenMappings.$EnumSwitchMapping$0[bindType.ordinal()]) {
                            case 1: {
                                $this$evaluateChallenge_u24lambda_u2d1.append("n");
                                break;
                            }
                            case 2: {
                                $this$evaluateChallenge_u24lambda_u2d1.append("y");
                                break;
                            }
                            case 3: {
                                $this$evaluateChallenge_u24lambda_u2d1.append("p=tls-unique");
                                break;
                            }
                            case 4: {
                                $this$evaluateChallenge_u24lambda_u2d1.append("p=tls-server-end-point");
                            }
                        }
                        $this$evaluateChallenge_u24lambda_u2d1.append(",");
                        String string3 = data.getAuthzId();
                        if (string3 != null) {
                            String it = string3;
                            boolean bl2 = false;
                            $this$evaluateChallenge_u24lambda_u2d1.append("a=").append(it);
                        }
                        $this$evaluateChallenge_u24lambda_u2d1.append(",");
                        String string4 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                        sCRAMData.setCb(string4);
                        $this$evaluateChallenge_u24lambda_u2d1 = stringBuilder3 = new StringBuilder();
                        sCRAMData = data;
                        boolean bl3 = false;
                        $this$evaluateChallenge_u24lambda_u2d2.append("n=" + data.getAuthcId() + ',');
                        $this$evaluateChallenge_u24lambda_u2d2.append("r=" + data.getConce());
                        String string5 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                        sCRAMData.setClientFirstMessageBare(string5);
                        data.setStage(data.getStage() + 1);
                        data.getStage();
                        return Base64Kt.toBase64(data.getCb() + data.getClientFirstMessageBare());
                    }
                    if (data.getStage() != 1) break block50;
                    if (input == null) {
                        throw new ClientSaslException("Unexpected empty input!");
                    }
                    serverFirstMessage = StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input));
                    MatchResult matchResult = this.serverFirstMessageRegex.matchEntire((CharSequence)serverFirstMessage);
                    if (matchResult == null) {
                        throw new ClientSaslException("Bad challenge syntax");
                    }
                    r2 = matchResult;
                    Object object2 = r2.getGroups().get(2);
                    if (object2 == null || (object2 = object2.getValue()) == null) {
                        throw new ClientSaslException("Bad challenge syntax: missing nonce");
                    }
                    nonce = object2;
                    object = r2.getGroups().get(3);
                    if (object == null || (object = object.getValue()) == null) break block51;
                    byte[] byArray6 = Base64Kt.fromBase64((CharSequence)object);
                    object = byArray6;
                    if (byArray6 != null) break block52;
                }
                throw new ClientSaslException("Bad challenge syntax: missing salt");
            }
            Object salt = object;
            Object object3 = r2.getGroups().get(4);
            if (object3 == null || (object3 = object3.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax: missing iterations");
            }
            int iterations = Integer.parseInt((String)object3);
            String string = data.getConce();
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.startsWith$default((String)nonce, (String)string, (boolean)false, (int)2, null)) {
                throw new ClientSaslException("Wrong nonce");
            }
            StringBuilder $this$evaluateChallenge_u24lambda_u2d3 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$evaluateChallenge_u24lambda_u2d3.append("c=");
            String string6 = data.getCb();
            Intrinsics.checkNotNull((Object)string6);
            $this$evaluateChallenge_u24lambda_u2d3.append(Base64Kt.toBase64(ArraysKt.plus((byte[])StringsKt.encodeToByteArray((String)string6), (byte[])data.getBindData())));
            $this$evaluateChallenge_u24lambda_u2d3.append(",");
            $this$evaluateChallenge_u24lambda_u2d3.append("r=");
            $this$evaluateChallenge_u24lambda_u2d3.append((String)nonce);
            String string7 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
            String clientFinalMessageStep1 = string7;
            data.setAuthMessage(data.getClientFirstMessageBare() + ',' + serverFirstMessage + ',' + clientFinalMessageStep1);
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byArray5 = PBKDF2.Companion.pbkdf2WithHmacSHA1(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 160);
                    break;
                }
                case 2: {
                    byArray5 = PBKDF2.Companion.pbkdf2WithHmacSHA256(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 256);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            data.setSaltedPassword(byArray5);
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byte[] byArray7 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray7);
                    byArray4 = HMAC.Companion.hmacSHA1-I-_ln_s(byArray7, this.clientKeyData);
                    break;
                }
                case 2: {
                    byte[] byArray8 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray8);
                    byArray4 = HMAC.Companion.hmacSHA256-I-_ln_s(byArray8, this.clientKeyData);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] clientKey = byArray4;
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byArray3 = SHA1Kt.sha1((byte[])clientKey);
                    break;
                }
                case 2: {
                    byArray3 = SHA256Kt.sha256((byte[])clientKey);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] storedKey = byArray3;
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    String string8 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string8);
                    byArray2 = HMAC.Companion.hmacSHA1-I-_ln_s(storedKey, StringsKt.encodeToByteArray((String)string8));
                    break;
                }
                case 2: {
                    String string9 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string9);
                    byArray2 = HMAC.Companion.hmacSHA256-I-_ln_s(storedKey, StringsKt.encodeToByteArray((String)string9));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] clientSignature = byArray2;
            byte[] byArray9 = Arrays.copyOf(clientKey, clientKey.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray9, (String)"copyOf(this, size)");
            byte[] it = byArray = byArray9;
            boolean bl4 = false;
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                it[i] = (byte)(it[i] ^ clientSignature[i]);
            }
            byte[] clientProof = byArray;
            StringBuilder $this$evaluateChallenge_u24lambda_u2d5 = stringBuilder = new StringBuilder();
            boolean bl5 = false;
            $this$evaluateChallenge_u24lambda_u2d5.append(clientFinalMessageStep1);
            $this$evaluateChallenge_u24lambda_u2d5.append(",");
            $this$evaluateChallenge_u24lambda_u2d5.append("p=");
            $this$evaluateChallenge_u24lambda_u2d5.append(Base64Kt.toBase64(clientProof));
            String string10 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"StringBuilder().apply(builderAction).toString()");
            String clientFinalMessageStep2 = string10;
            data.setStage(data.getStage() + 1);
            data.getStage();
            return Base64Kt.toBase64(clientFinalMessageStep2);
        }
        if (data.getStage() == 2) {
            byte[] byArray;
            byte[] byArray10;
            if (input == null) {
                throw new ClientSaslException("Unexpected empty input!");
            }
            MatchResult matchResult = this.serverLastMessageRegex.matchEntire((CharSequence)StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input)));
            if (matchResult == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            MatchResult r = matchResult;
            MatchGroup r2 = r.getGroups().get(1);
            if (r2 != null) {
                MatchGroup it = r2;
                boolean bl = false;
                throw new ClientSaslException("Error: " + it);
            }
            Object object = r.getGroups().get(2);
            if (object == null || (object = object.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            Object v = object;
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    byte[] byArray11 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray11);
                    byArray10 = HMAC.Companion.hmacSHA1-I-_ln_s(byArray11, this.serverKeyData);
                    break;
                }
                case 2: {
                    byte[] byArray12 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)byArray12);
                    byArray10 = HMAC.Companion.hmacSHA256-I-_ln_s(byArray12, this.serverKeyData);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] serverKey = byArray10;
            switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1: {
                    String string = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string);
                    byArray = HMAC.Companion.hmacSHA1-I-_ln_s(serverKey, StringsKt.encodeToByteArray((String)string));
                    break;
                }
                case 2: {
                    String string = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)string);
                    byArray = HMAC.Companion.hmacSHA256-I-_ln_s(serverKey, StringsKt.encodeToByteArray((String)string));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] serverSignature = byArray;
            if (!Arrays.equals(serverSignature, Base64Kt.fromBase64((CharSequence)v))) {
                throw new ClientSaslException("Invalid Server Signature");
            }
            data.setStage(data.getStage() + 1);
            data.getStage();
            saslContext.setComplete$halcyon_core(true);
            return null;
        }
        if (saslContext.getComplete() && input == null) {
            return null;
        }
        throw new IllegalStateException("SASL Client in illegal state. stage=" + data.getStage() + " complete=" + saslContext.getComplete());
    }

    @Override
    public boolean isComplete(@NotNull SASLContext saslContext) {
        return SASLMechanism.DefaultImpls.isComplete(this, saslContext);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BindType.values().length];
            nArray[BindType.N.ordinal()] = 1;
            nArray[BindType.Y.ordinal()] = 2;
            nArray[BindType.TlsUnique.ordinal()] = 3;
            nArray[BindType.TlsServerEndPoint.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScramHashAlgorithm.values().length];
            nArray[ScramHashAlgorithm.SHA1.ordinal()] = 1;
            nArray[ScramHashAlgorithm.SHA256.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

